package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServiceEntrySpecFluent<A extends ServiceEntrySpecFluent<A>> extends BaseFluent<A>{
  public ServiceEntrySpecFluent() {
  }
  
  public ServiceEntrySpecFluent(ServiceEntrySpec instance) {
    this.copyInstance(instance);
  }
  private List<String> addresses = new ArrayList<String>();
  private ArrayList<WorkloadEntrySpecBuilder> endpoints = new ArrayList<WorkloadEntrySpecBuilder>();
  private List<String> exportTo = new ArrayList<String>();
  private List<String> hosts = new ArrayList<String>();
  private ServiceEntryLocation location;
  private ArrayList<PortBuilder> ports = new ArrayList<PortBuilder>();
  private ServiceEntryResolution resolution;
  private List<String> subjectAltNames = new ArrayList<String>();
  private WorkloadSelectorBuilder workloadSelector;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ServiceEntrySpec instance) {
    instance = (instance != null ? instance : new ServiceEntrySpec());
    if (instance != null) {
          this.withAddresses(instance.getAddresses());
          this.withEndpoints(instance.getEndpoints());
          this.withExportTo(instance.getExportTo());
          this.withHosts(instance.getHosts());
          this.withLocation(instance.getLocation());
          this.withPorts(instance.getPorts());
          this.withResolution(instance.getResolution());
          this.withSubjectAltNames(instance.getSubjectAltNames());
          this.withWorkloadSelector(instance.getWorkloadSelector());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAddresses(int index,String item) {
    if (this.addresses == null) {this.addresses = new ArrayList<String>();}
    this.addresses.add(index, item);
    return (A)this;
  }
  
  public A setToAddresses(int index,String item) {
    if (this.addresses == null) {this.addresses = new ArrayList<String>();}
    this.addresses.set(index, item); return (A)this;
  }
  
  public A addToAddresses(java.lang.String... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<String>();}
    for (String item : items) {this.addresses.add(item);} return (A)this;
  }
  
  public A addAllToAddresses(Collection<String> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<String>();}
    for (String item : items) {this.addresses.add(item);} return (A)this;
  }
  
  public A removeFromAddresses(java.lang.String... items) {
    if (this.addresses == null) return (A)this;
    for (String item : items) { this.addresses.remove(item);} return (A)this;
  }
  
  public A removeAllFromAddresses(Collection<String> items) {
    if (this.addresses == null) return (A)this;
    for (String item : items) { this.addresses.remove(item);} return (A)this;
  }
  
  public List<String> getAddresses() {
    return this.addresses;
  }
  
  public String getAddress(int index) {
    return this.addresses.get(index);
  }
  
  public String getFirstAddress() {
    return this.addresses.get(0);
  }
  
  public String getLastAddress() {
    return this.addresses.get(addresses.size() - 1);
  }
  
  public String getMatchingAddress(Predicate<String> predicate) {
      for (String item : addresses) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAddress(Predicate<String> predicate) {
      for (String item : addresses) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAddresses(List<String> addresses) {
    if (addresses != null) {
        this.addresses = new ArrayList();
        for (String item : addresses) {
          this.addToAddresses(item);
        }
    } else {
      this.addresses = null;
    }
    return (A) this;
  }
  
  public A withAddresses(java.lang.String... addresses) {
    if (this.addresses != null) {
        this.addresses.clear();
        _visitables.remove("addresses");
    }
    if (addresses != null) {
      for (String item : addresses) {
        this.addToAddresses(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAddresses() {
    return this.addresses != null && !this.addresses.isEmpty();
  }
  
  public A addToEndpoints(int index,WorkloadEntrySpec item) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();}
    WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);
    if (index < 0 || index >= endpoints.size()) { _visitables.get("endpoints").add(builder); endpoints.add(builder); } else { _visitables.get("endpoints").add(index, builder); endpoints.add(index, builder);}
    return (A)this;
  }
  
  public A setToEndpoints(int index,WorkloadEntrySpec item) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();}
    WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);
    if (index < 0 || index >= endpoints.size()) { _visitables.get("endpoints").add(builder); endpoints.add(builder); } else { _visitables.get("endpoints").set(index, builder); endpoints.set(index, builder);}
    return (A)this;
  }
  
  public A addToEndpoints(io.fabric8.istio.api.networking.v1beta1.WorkloadEntrySpec... items) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();}
    for (WorkloadEntrySpec item : items) {WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  
  public A addAllToEndpoints(Collection<WorkloadEntrySpec> items) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();}
    for (WorkloadEntrySpec item : items) {WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  
  public A removeFromEndpoints(io.fabric8.istio.api.networking.v1beta1.WorkloadEntrySpec... items) {
    if (this.endpoints == null) return (A)this;
    for (WorkloadEntrySpec item : items) {WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").remove(builder); this.endpoints.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEndpoints(Collection<WorkloadEntrySpec> items) {
    if (this.endpoints == null) return (A)this;
    for (WorkloadEntrySpec item : items) {WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").remove(builder); this.endpoints.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEndpoints(Predicate<WorkloadEntrySpecBuilder> predicate) {
    if (endpoints == null) return (A) this;
    final Iterator<WorkloadEntrySpecBuilder> each = endpoints.iterator();
    final List visitables = _visitables.get("endpoints");
    while (each.hasNext()) {
      WorkloadEntrySpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<WorkloadEntrySpec> buildEndpoints() {
    return this.endpoints != null ? build(endpoints) : null;
  }
  
  public WorkloadEntrySpec buildEndpoint(int index) {
    return this.endpoints.get(index).build();
  }
  
  public WorkloadEntrySpec buildFirstEndpoint() {
    return this.endpoints.get(0).build();
  }
  
  public WorkloadEntrySpec buildLastEndpoint() {
    return this.endpoints.get(endpoints.size() - 1).build();
  }
  
  public WorkloadEntrySpec buildMatchingEndpoint(Predicate<WorkloadEntrySpecBuilder> predicate) {
      for (WorkloadEntrySpecBuilder item : endpoints) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEndpoint(Predicate<WorkloadEntrySpecBuilder> predicate) {
      for (WorkloadEntrySpecBuilder item : endpoints) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEndpoints(List<WorkloadEntrySpec> endpoints) {
    if (this.endpoints != null) {
      this._visitables.get("endpoints").clear();
    }
    if (endpoints != null) {
        this.endpoints = new ArrayList();
        for (WorkloadEntrySpec item : endpoints) {
          this.addToEndpoints(item);
        }
    } else {
      this.endpoints = null;
    }
    return (A) this;
  }
  
  public A withEndpoints(io.fabric8.istio.api.networking.v1beta1.WorkloadEntrySpec... endpoints) {
    if (this.endpoints != null) {
        this.endpoints.clear();
        _visitables.remove("endpoints");
    }
    if (endpoints != null) {
      for (WorkloadEntrySpec item : endpoints) {
        this.addToEndpoints(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEndpoints() {
    return this.endpoints != null && !this.endpoints.isEmpty();
  }
  
  public EndpointsNested<A> addNewEndpoint() {
    return new EndpointsNested(-1, null);
  }
  
  public EndpointsNested<A> addNewEndpointLike(WorkloadEntrySpec item) {
    return new EndpointsNested(-1, item);
  }
  
  public EndpointsNested<A> setNewEndpointLike(int index,WorkloadEntrySpec item) {
    return new EndpointsNested(index, item);
  }
  
  public EndpointsNested<A> editEndpoint(int index) {
    if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  
  public EndpointsNested<A> editFirstEndpoint() {
    if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
    return setNewEndpointLike(0, buildEndpoint(0));
  }
  
  public EndpointsNested<A> editLastEndpoint() {
    int index = endpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  
  public EndpointsNested<A> editMatchingEndpoint(Predicate<WorkloadEntrySpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<endpoints.size();i++) { 
    if (predicate.test(endpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  
  public A addToExportTo(int index,String item) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    this.exportTo.add(index, item);
    return (A)this;
  }
  
  public A setToExportTo(int index,String item) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    this.exportTo.set(index, item); return (A)this;
  }
  
  public A addToExportTo(java.lang.String... items) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    for (String item : items) {this.exportTo.add(item);} return (A)this;
  }
  
  public A addAllToExportTo(Collection<String> items) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    for (String item : items) {this.exportTo.add(item);} return (A)this;
  }
  
  public A removeFromExportTo(java.lang.String... items) {
    if (this.exportTo == null) return (A)this;
    for (String item : items) { this.exportTo.remove(item);} return (A)this;
  }
  
  public A removeAllFromExportTo(Collection<String> items) {
    if (this.exportTo == null) return (A)this;
    for (String item : items) { this.exportTo.remove(item);} return (A)this;
  }
  
  public List<String> getExportTo() {
    return this.exportTo;
  }
  
  public String getExportTo(int index) {
    return this.exportTo.get(index);
  }
  
  public String getFirstExportTo() {
    return this.exportTo.get(0);
  }
  
  public String getLastExportTo() {
    return this.exportTo.get(exportTo.size() - 1);
  }
  
  public String getMatchingExportTo(Predicate<String> predicate) {
      for (String item : exportTo) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingExportTo(Predicate<String> predicate) {
      for (String item : exportTo) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExportTo(List<String> exportTo) {
    if (exportTo != null) {
        this.exportTo = new ArrayList();
        for (String item : exportTo) {
          this.addToExportTo(item);
        }
    } else {
      this.exportTo = null;
    }
    return (A) this;
  }
  
  public A withExportTo(java.lang.String... exportTo) {
    if (this.exportTo != null) {
        this.exportTo.clear();
        _visitables.remove("exportTo");
    }
    if (exportTo != null) {
      for (String item : exportTo) {
        this.addToExportTo(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExportTo() {
    return this.exportTo != null && !this.exportTo.isEmpty();
  }
  
  public A addToHosts(int index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.add(index, item);
    return (A)this;
  }
  
  public A setToHosts(int index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.set(index, item); return (A)this;
  }
  
  public A addToHosts(java.lang.String... items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  
  public A addAllToHosts(Collection<String> items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  
  public A removeFromHosts(java.lang.String... items) {
    if (this.hosts == null) return (A)this;
    for (String item : items) { this.hosts.remove(item);} return (A)this;
  }
  
  public A removeAllFromHosts(Collection<String> items) {
    if (this.hosts == null) return (A)this;
    for (String item : items) { this.hosts.remove(item);} return (A)this;
  }
  
  public List<String> getHosts() {
    return this.hosts;
  }
  
  public String getHost(int index) {
    return this.hosts.get(index);
  }
  
  public String getFirstHost() {
    return this.hosts.get(0);
  }
  
  public String getLastHost() {
    return this.hosts.get(hosts.size() - 1);
  }
  
  public String getMatchingHost(Predicate<String> predicate) {
      for (String item : hosts) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingHost(Predicate<String> predicate) {
      for (String item : hosts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHosts(List<String> hosts) {
    if (hosts != null) {
        this.hosts = new ArrayList();
        for (String item : hosts) {
          this.addToHosts(item);
        }
    } else {
      this.hosts = null;
    }
    return (A) this;
  }
  
  public A withHosts(java.lang.String... hosts) {
    if (this.hosts != null) {
        this.hosts.clear();
        _visitables.remove("hosts");
    }
    if (hosts != null) {
      for (String item : hosts) {
        this.addToHosts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHosts() {
    return this.hosts != null && !this.hosts.isEmpty();
  }
  
  public ServiceEntryLocation getLocation() {
    return this.location;
  }
  
  public A withLocation(ServiceEntryLocation location) {
    this.location = location;
    return (A) this;
  }
  
  public boolean hasLocation() {
    return this.location != null;
  }
  
  public A addToPorts(int index,Port item) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    PortBuilder builder = new PortBuilder(item);
    if (index < 0 || index >= ports.size()) { _visitables.get("ports").add(builder); ports.add(builder); } else { _visitables.get("ports").add(index, builder); ports.add(index, builder);}
    return (A)this;
  }
  
  public A setToPorts(int index,Port item) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    PortBuilder builder = new PortBuilder(item);
    if (index < 0 || index >= ports.size()) { _visitables.get("ports").add(builder); ports.add(builder); } else { _visitables.get("ports").set(index, builder); ports.set(index, builder);}
    return (A)this;
  }
  
  public A addToPorts(io.fabric8.istio.api.networking.v1beta1.Port... items) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  
  public A addAllToPorts(Collection<Port> items) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  
  public A removeFromPorts(io.fabric8.istio.api.networking.v1beta1.Port... items) {
    if (this.ports == null) return (A)this;
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").remove(builder); this.ports.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPorts(Collection<Port> items) {
    if (this.ports == null) return (A)this;
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").remove(builder); this.ports.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPorts(Predicate<PortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<PortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      PortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Port> buildPorts() {
    return this.ports != null ? build(ports) : null;
  }
  
  public Port buildPort(int index) {
    return this.ports.get(index).build();
  }
  
  public Port buildFirstPort() {
    return this.ports.get(0).build();
  }
  
  public Port buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  
  public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
      for (PortBuilder item : ports) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPort(Predicate<PortBuilder> predicate) {
      for (PortBuilder item : ports) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPorts(List<Port> ports) {
    if (this.ports != null) {
      this._visitables.get("ports").clear();
    }
    if (ports != null) {
        this.ports = new ArrayList();
        for (Port item : ports) {
          this.addToPorts(item);
        }
    } else {
      this.ports = null;
    }
    return (A) this;
  }
  
  public A withPorts(io.fabric8.istio.api.networking.v1beta1.Port... ports) {
    if (this.ports != null) {
        this.ports.clear();
        _visitables.remove("ports");
    }
    if (ports != null) {
      for (Port item : ports) {
        this.addToPorts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPorts() {
    return this.ports != null && !this.ports.isEmpty();
  }
  
  public A addNewPort(String name,Integer number,String protocol,Integer targetPort) {
    return (A)addToPorts(new Port(name, number, protocol, targetPort));
  }
  
  public PortsNested<A> addNewPort() {
    return new PortsNested(-1, null);
  }
  
  public PortsNested<A> addNewPortLike(Port item) {
    return new PortsNested(-1, item);
  }
  
  public PortsNested<A> setNewPortLike(int index,Port item) {
    return new PortsNested(index, item);
  }
  
  public PortsNested<A> editPort(int index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  
  public PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  
  public PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  
  public PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  
  public ServiceEntryResolution getResolution() {
    return this.resolution;
  }
  
  public A withResolution(ServiceEntryResolution resolution) {
    this.resolution = resolution;
    return (A) this;
  }
  
  public boolean hasResolution() {
    return this.resolution != null;
  }
  
  public A addToSubjectAltNames(int index,String item) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    this.subjectAltNames.add(index, item);
    return (A)this;
  }
  
  public A setToSubjectAltNames(int index,String item) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    this.subjectAltNames.set(index, item); return (A)this;
  }
  
  public A addToSubjectAltNames(java.lang.String... items) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
  }
  
  public A addAllToSubjectAltNames(Collection<String> items) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
  }
  
  public A removeFromSubjectAltNames(java.lang.String... items) {
    if (this.subjectAltNames == null) return (A)this;
    for (String item : items) { this.subjectAltNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromSubjectAltNames(Collection<String> items) {
    if (this.subjectAltNames == null) return (A)this;
    for (String item : items) { this.subjectAltNames.remove(item);} return (A)this;
  }
  
  public List<String> getSubjectAltNames() {
    return this.subjectAltNames;
  }
  
  public String getSubjectAltName(int index) {
    return this.subjectAltNames.get(index);
  }
  
  public String getFirstSubjectAltName() {
    return this.subjectAltNames.get(0);
  }
  
  public String getLastSubjectAltName() {
    return this.subjectAltNames.get(subjectAltNames.size() - 1);
  }
  
  public String getMatchingSubjectAltName(Predicate<String> predicate) {
      for (String item : subjectAltNames) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingSubjectAltName(Predicate<String> predicate) {
      for (String item : subjectAltNames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSubjectAltNames(List<String> subjectAltNames) {
    if (subjectAltNames != null) {
        this.subjectAltNames = new ArrayList();
        for (String item : subjectAltNames) {
          this.addToSubjectAltNames(item);
        }
    } else {
      this.subjectAltNames = null;
    }
    return (A) this;
  }
  
  public A withSubjectAltNames(java.lang.String... subjectAltNames) {
    if (this.subjectAltNames != null) {
        this.subjectAltNames.clear();
        _visitables.remove("subjectAltNames");
    }
    if (subjectAltNames != null) {
      for (String item : subjectAltNames) {
        this.addToSubjectAltNames(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSubjectAltNames() {
    return this.subjectAltNames != null && !this.subjectAltNames.isEmpty();
  }
  
  public WorkloadSelector buildWorkloadSelector() {
    return this.workloadSelector != null ? this.workloadSelector.build() : null;
  }
  
  public A withWorkloadSelector(WorkloadSelector workloadSelector) {
    this._visitables.remove("workloadSelector");
    if (workloadSelector != null) {
        this.workloadSelector = new WorkloadSelectorBuilder(workloadSelector);
        this._visitables.get("workloadSelector").add(this.workloadSelector);
    } else {
        this.workloadSelector = null;
        this._visitables.get("workloadSelector").remove(this.workloadSelector);
    }
    return (A) this;
  }
  
  public boolean hasWorkloadSelector() {
    return this.workloadSelector != null;
  }
  
  public WorkloadSelectorNested<A> withNewWorkloadSelector() {
    return new WorkloadSelectorNested(null);
  }
  
  public WorkloadSelectorNested<A> withNewWorkloadSelectorLike(WorkloadSelector item) {
    return new WorkloadSelectorNested(item);
  }
  
  public WorkloadSelectorNested<A> editWorkloadSelector() {
    return withNewWorkloadSelectorLike(java.util.Optional.ofNullable(buildWorkloadSelector()).orElse(null));
  }
  
  public WorkloadSelectorNested<A> editOrNewWorkloadSelector() {
    return withNewWorkloadSelectorLike(java.util.Optional.ofNullable(buildWorkloadSelector()).orElse(new WorkloadSelectorBuilder().build()));
  }
  
  public WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(WorkloadSelector item) {
    return withNewWorkloadSelectorLike(java.util.Optional.ofNullable(buildWorkloadSelector()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceEntrySpecFluent that = (ServiceEntrySpecFluent) o;
    if (!java.util.Objects.equals(addresses, that.addresses)) return false;
    if (!java.util.Objects.equals(endpoints, that.endpoints)) return false;
    if (!java.util.Objects.equals(exportTo, that.exportTo)) return false;
    if (!java.util.Objects.equals(hosts, that.hosts)) return false;
    if (!java.util.Objects.equals(location, that.location)) return false;
    if (!java.util.Objects.equals(ports, that.ports)) return false;
    if (!java.util.Objects.equals(resolution, that.resolution)) return false;
    if (!java.util.Objects.equals(subjectAltNames, that.subjectAltNames)) return false;
    if (!java.util.Objects.equals(workloadSelector, that.workloadSelector)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(addresses,  endpoints,  exportTo,  hosts,  location,  ports,  resolution,  subjectAltNames,  workloadSelector,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (endpoints != null && !endpoints.isEmpty()) { sb.append("endpoints:"); sb.append(endpoints + ","); }
    if (exportTo != null && !exportTo.isEmpty()) { sb.append("exportTo:"); sb.append(exportTo + ","); }
    if (hosts != null && !hosts.isEmpty()) { sb.append("hosts:"); sb.append(hosts + ","); }
    if (location != null) { sb.append("location:"); sb.append(location + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (resolution != null) { sb.append("resolution:"); sb.append(resolution + ","); }
    if (subjectAltNames != null && !subjectAltNames.isEmpty()) { sb.append("subjectAltNames:"); sb.append(subjectAltNames + ","); }
    if (workloadSelector != null) { sb.append("workloadSelector:"); sb.append(workloadSelector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EndpointsNested<N> extends WorkloadEntrySpecFluent<EndpointsNested<N>> implements Nested<N>{
    EndpointsNested(int index,WorkloadEntrySpec item) {
      this.index = index;
      this.builder = new WorkloadEntrySpecBuilder(this, item);
    }
    WorkloadEntrySpecBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceEntrySpecFluent.this.setToEndpoints(index,builder.build());
    }
    
    public N endEndpoint() {
      return and();
    }
    
  
  }
  public class PortsNested<N> extends PortFluent<PortsNested<N>> implements Nested<N>{
    PortsNested(int index,Port item) {
      this.index = index;
      this.builder = new PortBuilder(this, item);
    }
    PortBuilder builder;
    int index;
    
    public N and() {
      return (N) ServiceEntrySpecFluent.this.setToPorts(index,builder.build());
    }
    
    public N endPort() {
      return and();
    }
    
  
  }
  public class WorkloadSelectorNested<N> extends WorkloadSelectorFluent<WorkloadSelectorNested<N>> implements Nested<N>{
    WorkloadSelectorNested(WorkloadSelector item) {
      this.builder = new WorkloadSelectorBuilder(this, item);
    }
    WorkloadSelectorBuilder builder;
    
    public N and() {
      return (N) ServiceEntrySpecFluent.this.withWorkloadSelector(builder.build());
    }
    
    public N endWorkloadSelector() {
      return and();
    }
    
  
  }

}