package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GatewaySpecFluent<A extends GatewaySpecFluent<A>> extends BaseFluent<A>{
  public GatewaySpecFluent() {
  }
  
  public GatewaySpecFluent(GatewaySpec instance) {
    this.copyInstance(instance);
  }
  private Map<String,String> selector;
  private ArrayList<ServerBuilder> servers = new ArrayList<ServerBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GatewaySpec instance) {
    instance = (instance != null ? instance : new GatewaySpec());
    if (instance != null) {
          this.withSelector(instance.getSelector());
          this.withServers(instance.getServers());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToSelector(String key,String value) {
    if(this.selector == null && key != null && value != null) { this.selector = new LinkedHashMap(); }
    if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
  }
  
  public A addToSelector(Map<String,String> map) {
    if(this.selector == null && map != null) { this.selector = new LinkedHashMap(); }
    if(map != null) { this.selector.putAll(map);} return (A)this;
  }
  
  public A removeFromSelector(String key) {
    if(this.selector == null) { return (A) this; }
    if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
  }
  
  public A removeFromSelector(Map<String,String> map) {
    if(this.selector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getSelector() {
    return this.selector;
  }
  
  public <K,V>A withSelector(Map<String,String> selector) {
    if (selector == null) {
      this.selector = null;
    } else {
      this.selector = new LinkedHashMap(selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public A addToServers(int index,Server item) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    ServerBuilder builder = new ServerBuilder(item);
    if (index < 0 || index >= servers.size()) { _visitables.get("servers").add(builder); servers.add(builder); } else { _visitables.get("servers").add(index, builder); servers.add(index, builder);}
    return (A)this;
  }
  
  public A setToServers(int index,Server item) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    ServerBuilder builder = new ServerBuilder(item);
    if (index < 0 || index >= servers.size()) { _visitables.get("servers").add(builder); servers.add(builder); } else { _visitables.get("servers").set(index, builder); servers.set(index, builder);}
    return (A)this;
  }
  
  public A addToServers(io.fabric8.istio.api.networking.v1beta1.Server... items) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  
  public A addAllToServers(Collection<Server> items) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  
  public A removeFromServers(io.fabric8.istio.api.networking.v1beta1.Server... items) {
    if (this.servers == null) return (A)this;
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").remove(builder); this.servers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromServers(Collection<Server> items) {
    if (this.servers == null) return (A)this;
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").remove(builder); this.servers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromServers(Predicate<ServerBuilder> predicate) {
    if (servers == null) return (A) this;
    final Iterator<ServerBuilder> each = servers.iterator();
    final List visitables = _visitables.get("servers");
    while (each.hasNext()) {
      ServerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Server> buildServers() {
    return this.servers != null ? build(servers) : null;
  }
  
  public Server buildServer(int index) {
    return this.servers.get(index).build();
  }
  
  public Server buildFirstServer() {
    return this.servers.get(0).build();
  }
  
  public Server buildLastServer() {
    return this.servers.get(servers.size() - 1).build();
  }
  
  public Server buildMatchingServer(Predicate<ServerBuilder> predicate) {
      for (ServerBuilder item : servers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingServer(Predicate<ServerBuilder> predicate) {
      for (ServerBuilder item : servers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withServers(List<Server> servers) {
    if (this.servers != null) {
      this._visitables.get("servers").clear();
    }
    if (servers != null) {
        this.servers = new ArrayList();
        for (Server item : servers) {
          this.addToServers(item);
        }
    } else {
      this.servers = null;
    }
    return (A) this;
  }
  
  public A withServers(io.fabric8.istio.api.networking.v1beta1.Server... servers) {
    if (this.servers != null) {
        this.servers.clear();
        _visitables.remove("servers");
    }
    if (servers != null) {
      for (Server item : servers) {
        this.addToServers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasServers() {
    return this.servers != null && !this.servers.isEmpty();
  }
  
  public ServersNested<A> addNewServer() {
    return new ServersNested(-1, null);
  }
  
  public ServersNested<A> addNewServerLike(Server item) {
    return new ServersNested(-1, item);
  }
  
  public ServersNested<A> setNewServerLike(int index,Server item) {
    return new ServersNested(index, item);
  }
  
  public ServersNested<A> editServer(int index) {
    if (servers.size() <= index) throw new RuntimeException("Can't edit servers. Index exceeds size.");
    return setNewServerLike(index, buildServer(index));
  }
  
  public ServersNested<A> editFirstServer() {
    if (servers.size() == 0) throw new RuntimeException("Can't edit first servers. The list is empty.");
    return setNewServerLike(0, buildServer(0));
  }
  
  public ServersNested<A> editLastServer() {
    int index = servers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last servers. The list is empty.");
    return setNewServerLike(index, buildServer(index));
  }
  
  public ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<servers.size();i++) { 
    if (predicate.test(servers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching servers. No match found.");
    return setNewServerLike(index, buildServer(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GatewaySpecFluent that = (GatewaySpecFluent) o;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(servers, that.servers)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(selector,  servers,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (selector != null && !selector.isEmpty()) { sb.append("selector:"); sb.append(selector + ","); }
    if (servers != null && !servers.isEmpty()) { sb.append("servers:"); sb.append(servers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ServersNested<N> extends ServerFluent<ServersNested<N>> implements Nested<N>{
    ServersNested(int index,Server item) {
      this.index = index;
      this.builder = new ServerBuilder(this, item);
    }
    ServerBuilder builder;
    int index;
    
    public N and() {
      return (N) GatewaySpecFluent.this.setToServers(index,builder.build());
    }
    
    public N endServer() {
      return and();
    }
    
  
  }

}