/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.istio.api.networking.v1beta1.L4MatchAttributes;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class L4MatchAttributesFluent<A extends L4MatchAttributesFluent<A>>
extends BaseFluent<A> {
    private List<String> destinationSubnets = new ArrayList<String>();
    private List<String> gateways = new ArrayList<String>();
    private Integer port;
    private Map<String, String> sourceLabels;
    private String sourceNamespace;
    private String sourceSubnet;

    public L4MatchAttributesFluent() {
    }

    public L4MatchAttributesFluent(L4MatchAttributes instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(L4MatchAttributes instance) {
        L4MatchAttributes l4MatchAttributes = instance = instance != null ? instance : new L4MatchAttributes();
        if (instance != null) {
            this.withDestinationSubnets(instance.getDestinationSubnets());
            this.withGateways(instance.getGateways());
            this.withPort(instance.getPort());
            this.withSourceLabels(instance.getSourceLabels());
            this.withSourceNamespace(instance.getSourceNamespace());
            this.withSourceSubnet(instance.getSourceSubnet());
            this.withDestinationSubnets(instance.getDestinationSubnets());
            this.withGateways(instance.getGateways());
            this.withPort(instance.getPort());
            this.withSourceLabels(instance.getSourceLabels());
            this.withSourceNamespace(instance.getSourceNamespace());
            this.withSourceSubnet(instance.getSourceSubnet());
        }
    }

    public A addToDestinationSubnets(int index, String item) {
        if (this.destinationSubnets == null) {
            this.destinationSubnets = new ArrayList<String>();
        }
        this.destinationSubnets.add(index, item);
        return (A)((Object)this);
    }

    public A setToDestinationSubnets(int index, String item) {
        if (this.destinationSubnets == null) {
            this.destinationSubnets = new ArrayList<String>();
        }
        this.destinationSubnets.set(index, item);
        return (A)((Object)this);
    }

    public A addToDestinationSubnets(String ... items) {
        if (this.destinationSubnets == null) {
            this.destinationSubnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.destinationSubnets.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDestinationSubnets(Collection<String> items) {
        if (this.destinationSubnets == null) {
            this.destinationSubnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.destinationSubnets.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDestinationSubnets(String ... items) {
        if (this.destinationSubnets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.destinationSubnets.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDestinationSubnets(Collection<String> items) {
        if (this.destinationSubnets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.destinationSubnets.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDestinationSubnets() {
        return this.destinationSubnets;
    }

    public String getDestinationSubnet(int index) {
        return this.destinationSubnets.get(index);
    }

    public String getFirstDestinationSubnet() {
        return this.destinationSubnets.get(0);
    }

    public String getLastDestinationSubnet() {
        return this.destinationSubnets.get(this.destinationSubnets.size() - 1);
    }

    public String getMatchingDestinationSubnet(Predicate<String> predicate) {
        for (String item : this.destinationSubnets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDestinationSubnet(Predicate<String> predicate) {
        for (String item : this.destinationSubnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDestinationSubnets(List<String> destinationSubnets) {
        if (destinationSubnets != null) {
            this.destinationSubnets = new ArrayList<String>();
            for (String item : destinationSubnets) {
                this.addToDestinationSubnets(item);
            }
        } else {
            this.destinationSubnets = null;
        }
        return (A)((Object)this);
    }

    public A withDestinationSubnets(String ... destinationSubnets) {
        if (this.destinationSubnets != null) {
            this.destinationSubnets.clear();
            this._visitables.remove((Object)"destinationSubnets");
        }
        if (destinationSubnets != null) {
            for (String item : destinationSubnets) {
                this.addToDestinationSubnets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDestinationSubnets() {
        return this.destinationSubnets != null && !this.destinationSubnets.isEmpty();
    }

    public A addToGateways(int index, String item) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        this.gateways.add(index, item);
        return (A)((Object)this);
    }

    public A setToGateways(int index, String item) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        this.gateways.set(index, item);
        return (A)((Object)this);
    }

    public A addToGateways(String ... items) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        for (String item : items) {
            this.gateways.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToGateways(Collection<String> items) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        for (String item : items) {
            this.gateways.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromGateways(String ... items) {
        if (this.gateways == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.gateways.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGateways(Collection<String> items) {
        if (this.gateways == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.gateways.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getGateways() {
        return this.gateways;
    }

    public String getGateway(int index) {
        return this.gateways.get(index);
    }

    public String getFirstGateway() {
        return this.gateways.get(0);
    }

    public String getLastGateway() {
        return this.gateways.get(this.gateways.size() - 1);
    }

    public String getMatchingGateway(Predicate<String> predicate) {
        for (String item : this.gateways) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGateway(Predicate<String> predicate) {
        for (String item : this.gateways) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGateways(List<String> gateways) {
        if (gateways != null) {
            this.gateways = new ArrayList<String>();
            for (String item : gateways) {
                this.addToGateways(item);
            }
        } else {
            this.gateways = null;
        }
        return (A)((Object)this);
    }

    public A withGateways(String ... gateways) {
        if (this.gateways != null) {
            this.gateways.clear();
            this._visitables.remove((Object)"gateways");
        }
        if (gateways != null) {
            for (String item : gateways) {
                this.addToGateways(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGateways() {
        return this.gateways != null && !this.gateways.isEmpty();
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A addToSourceLabels(String key, String value) {
        if (this.sourceLabels == null && key != null && value != null) {
            this.sourceLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.sourceLabels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSourceLabels(Map<String, String> map) {
        if (this.sourceLabels == null && map != null) {
            this.sourceLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.sourceLabels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromSourceLabels(String key) {
        if (this.sourceLabels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.sourceLabels != null) {
            this.sourceLabels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromSourceLabels(Map<String, String> map) {
        if (this.sourceLabels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.sourceLabels == null) continue;
                this.sourceLabels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getSourceLabels() {
        return this.sourceLabels;
    }

    public <K, V> A withSourceLabels(Map<String, String> sourceLabels) {
        this.sourceLabels = sourceLabels == null ? null : new LinkedHashMap<String, String>(sourceLabels);
        return (A)((Object)this);
    }

    public boolean hasSourceLabels() {
        return this.sourceLabels != null;
    }

    public String getSourceNamespace() {
        return this.sourceNamespace;
    }

    public A withSourceNamespace(String sourceNamespace) {
        this.sourceNamespace = sourceNamespace;
        return (A)((Object)this);
    }

    public boolean hasSourceNamespace() {
        return this.sourceNamespace != null;
    }

    public String getSourceSubnet() {
        return this.sourceSubnet;
    }

    public A withSourceSubnet(String sourceSubnet) {
        this.sourceSubnet = sourceSubnet;
        return (A)((Object)this);
    }

    public boolean hasSourceSubnet() {
        return this.sourceSubnet != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        L4MatchAttributesFluent that = (L4MatchAttributesFluent)((Object)o);
        if (!Objects.equals(this.destinationSubnets, that.destinationSubnets)) {
            return false;
        }
        if (!Objects.equals(this.gateways, that.gateways)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.sourceLabels, that.sourceLabels)) {
            return false;
        }
        if (!Objects.equals(this.sourceNamespace, that.sourceNamespace)) {
            return false;
        }
        return Objects.equals(this.sourceSubnet, that.sourceSubnet);
    }

    public int hashCode() {
        return Objects.hash(this.destinationSubnets, this.gateways, this.port, this.sourceLabels, this.sourceNamespace, this.sourceSubnet, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.destinationSubnets != null && !this.destinationSubnets.isEmpty()) {
            sb.append("destinationSubnets:");
            sb.append(this.destinationSubnets + ",");
        }
        if (this.gateways != null && !this.gateways.isEmpty()) {
            sb.append("gateways:");
            sb.append(this.gateways + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.sourceLabels != null && !this.sourceLabels.isEmpty()) {
            sb.append("sourceLabels:");
            sb.append(this.sourceLabels + ",");
        }
        if (this.sourceNamespace != null) {
            sb.append("sourceNamespace:");
            sb.append(this.sourceNamespace + ",");
        }
        if (this.sourceSubnet != null) {
            sb.append("sourceSubnet:");
            sb.append(this.sourceSubnet);
        }
        sb.append("}");
        return sb.toString();
    }
}

