/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.CaptureMode;
import io.fabric8.istio.api.networking.v1alpha3.IstioIngressListener;
import io.fabric8.istio.api.networking.v1alpha3.Port;
import io.fabric8.istio.api.networking.v1alpha3.PortBuilder;
import io.fabric8.istio.api.networking.v1alpha3.PortFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class IstioIngressListenerFluent<A extends IstioIngressListenerFluent<A>>
extends BaseFluent<A> {
    private String bind;
    private CaptureMode captureMode;
    private String defaultEndpoint;
    private PortBuilder port;

    public IstioIngressListenerFluent() {
    }

    public IstioIngressListenerFluent(IstioIngressListener instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IstioIngressListener instance) {
        IstioIngressListener istioIngressListener = instance = instance != null ? instance : new IstioIngressListener();
        if (instance != null) {
            this.withBind(instance.getBind());
            this.withCaptureMode(instance.getCaptureMode());
            this.withDefaultEndpoint(instance.getDefaultEndpoint());
            this.withPort(instance.getPort());
            this.withBind(instance.getBind());
            this.withCaptureMode(instance.getCaptureMode());
            this.withDefaultEndpoint(instance.getDefaultEndpoint());
            this.withPort(instance.getPort());
        }
    }

    public String getBind() {
        return this.bind;
    }

    public A withBind(String bind) {
        this.bind = bind;
        return (A)((Object)this);
    }

    public boolean hasBind() {
        return this.bind != null;
    }

    public CaptureMode getCaptureMode() {
        return this.captureMode;
    }

    public A withCaptureMode(CaptureMode captureMode) {
        this.captureMode = captureMode;
        return (A)((Object)this);
    }

    public boolean hasCaptureMode() {
        return this.captureMode != null;
    }

    public String getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public A withDefaultEndpoint(String defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
        return (A)((Object)this);
    }

    public boolean hasDefaultEndpoint() {
        return this.defaultEndpoint != null;
    }

    public Port buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    public A withPort(Port port) {
        this._visitables.remove((Object)this.port);
        if (port != null) {
            this.port = new PortBuilder(port);
            this._visitables.get((Object)"port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get((Object)"port").remove((Object)this.port);
        }
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(String name, Integer number, String protocol, Integer targetPort) {
        return this.withPort(new Port(name, number, protocol, targetPort));
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public PortNested<A> withNewPortLike(Port item) {
        return new PortNested(item);
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new PortBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(Port item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IstioIngressListenerFluent that = (IstioIngressListenerFluent)((Object)o);
        if (!Objects.equals(this.bind, that.bind)) {
            return false;
        }
        if (!Objects.equals((Object)this.captureMode, (Object)that.captureMode)) {
            return false;
        }
        if (!Objects.equals(this.defaultEndpoint, that.defaultEndpoint)) {
            return false;
        }
        return Objects.equals((Object)this.port, (Object)that.port);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bind, this.captureMode, this.defaultEndpoint, this.port, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bind != null) {
            sb.append("bind:");
            sb.append(this.bind + ",");
        }
        if (this.captureMode != null) {
            sb.append("captureMode:");
            sb.append((Object)((Object)this.captureMode) + ",");
        }
        if (this.defaultEndpoint != null) {
            sb.append("defaultEndpoint:");
            sb.append(this.defaultEndpoint + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append((Object)this.port);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortNested<N>
    extends PortFluent<PortNested<N>>
    implements Nested<N> {
        PortBuilder builder;

        PortNested(Port item) {
            this.builder = new PortBuilder(this, item);
        }

        public N and() {
            return (N)IstioIngressListenerFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

