/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.DestinationRuleSpec;
import io.fabric8.istio.api.networking.v1alpha3.Subset;
import io.fabric8.istio.api.networking.v1alpha3.SubsetBuilder;
import io.fabric8.istio.api.networking.v1alpha3.SubsetFluent;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicy;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyBuilder;
import io.fabric8.istio.api.networking.v1alpha3.TrafficPolicyFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class DestinationRuleSpecFluent<A extends DestinationRuleSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> exportTo = new ArrayList<String>();
    private String host;
    private ArrayList<SubsetBuilder> subsets = new ArrayList();
    private TrafficPolicyBuilder trafficPolicy;

    public DestinationRuleSpecFluent() {
    }

    public DestinationRuleSpecFluent(DestinationRuleSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DestinationRuleSpec instance) {
        DestinationRuleSpec destinationRuleSpec = instance = instance != null ? instance : new DestinationRuleSpec();
        if (instance != null) {
            this.withExportTo(instance.getExportTo());
            this.withHost(instance.getHost());
            this.withSubsets(instance.getSubsets());
            this.withTrafficPolicy(instance.getTrafficPolicy());
            this.withExportTo(instance.getExportTo());
            this.withHost(instance.getHost());
            this.withSubsets(instance.getSubsets());
            this.withTrafficPolicy(instance.getTrafficPolicy());
        }
    }

    public A addToExportTo(int index, String item) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        this.exportTo.add(index, item);
        return (A)((Object)this);
    }

    public A setToExportTo(int index, String item) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        this.exportTo.set(index, item);
        return (A)((Object)this);
    }

    public A addToExportTo(String ... items) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        for (String item : items) {
            this.exportTo.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToExportTo(Collection<String> items) {
        if (this.exportTo == null) {
            this.exportTo = new ArrayList<String>();
        }
        for (String item : items) {
            this.exportTo.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromExportTo(String ... items) {
        if (this.exportTo == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.exportTo.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExportTo(Collection<String> items) {
        if (this.exportTo == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.exportTo.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getExportTo() {
        return this.exportTo;
    }

    public String getExportTo(int index) {
        return this.exportTo.get(index);
    }

    public String getFirstExportTo() {
        return this.exportTo.get(0);
    }

    public String getLastExportTo() {
        return this.exportTo.get(this.exportTo.size() - 1);
    }

    public String getMatchingExportTo(Predicate<String> predicate) {
        for (String item : this.exportTo) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExportTo(Predicate<String> predicate) {
        for (String item : this.exportTo) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExportTo(List<String> exportTo) {
        if (exportTo != null) {
            this.exportTo = new ArrayList<String>();
            for (String item : exportTo) {
                this.addToExportTo(item);
            }
        } else {
            this.exportTo = null;
        }
        return (A)((Object)this);
    }

    public A withExportTo(String ... exportTo) {
        if (this.exportTo != null) {
            this.exportTo.clear();
            this._visitables.remove((Object)"exportTo");
        }
        if (exportTo != null) {
            for (String item : exportTo) {
                this.addToExportTo(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExportTo() {
        return this.exportTo != null && !this.exportTo.isEmpty();
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public A addToSubsets(int index, Subset item) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        SubsetBuilder builder = new SubsetBuilder(item);
        if (index < 0 || index >= this.subsets.size()) {
            this._visitables.get((Object)"subsets").add(builder);
            this.subsets.add(builder);
        } else {
            this._visitables.get((Object)"subsets").add(index, builder);
            this.subsets.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSubsets(int index, Subset item) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        SubsetBuilder builder = new SubsetBuilder(item);
        if (index < 0 || index >= this.subsets.size()) {
            this._visitables.get((Object)"subsets").add(builder);
            this.subsets.add(builder);
        } else {
            this._visitables.get((Object)"subsets").set(index, builder);
            this.subsets.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSubsets(Subset ... items) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        for (Subset item : items) {
            SubsetBuilder builder = new SubsetBuilder(item);
            this._visitables.get((Object)"subsets").add(builder);
            this.subsets.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSubsets(Collection<Subset> items) {
        if (this.subsets == null) {
            this.subsets = new ArrayList();
        }
        for (Subset item : items) {
            SubsetBuilder builder = new SubsetBuilder(item);
            this._visitables.get((Object)"subsets").add(builder);
            this.subsets.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSubsets(Subset ... items) {
        if (this.subsets == null) {
            return (A)((Object)this);
        }
        for (Subset item : items) {
            SubsetBuilder builder = new SubsetBuilder(item);
            this._visitables.get((Object)"subsets").remove((Object)builder);
            this.subsets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSubsets(Collection<Subset> items) {
        if (this.subsets == null) {
            return (A)((Object)this);
        }
        for (Subset item : items) {
            SubsetBuilder builder = new SubsetBuilder(item);
            this._visitables.get((Object)"subsets").remove((Object)builder);
            this.subsets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSubsets(Predicate<SubsetBuilder> predicate) {
        if (this.subsets == null) {
            return (A)((Object)this);
        }
        Iterator<SubsetBuilder> each = this.subsets.iterator();
        List visitables = this._visitables.get((Object)"subsets");
        while (each.hasNext()) {
            SubsetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Subset> buildSubsets() {
        return this.subsets != null ? DestinationRuleSpecFluent.build(this.subsets) : null;
    }

    public Subset buildSubset(int index) {
        return this.subsets.get(index).build();
    }

    public Subset buildFirstSubset() {
        return this.subsets.get(0).build();
    }

    public Subset buildLastSubset() {
        return this.subsets.get(this.subsets.size() - 1).build();
    }

    public Subset buildMatchingSubset(Predicate<SubsetBuilder> predicate) {
        for (SubsetBuilder item : this.subsets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubset(Predicate<SubsetBuilder> predicate) {
        for (SubsetBuilder item : this.subsets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubsets(List<Subset> subsets) {
        if (this.subsets != null) {
            this._visitables.get((Object)"subsets").clear();
        }
        if (subsets != null) {
            this.subsets = new ArrayList();
            for (Subset item : subsets) {
                this.addToSubsets(item);
            }
        } else {
            this.subsets = null;
        }
        return (A)((Object)this);
    }

    public A withSubsets(Subset ... subsets) {
        if (this.subsets != null) {
            this.subsets.clear();
            this._visitables.remove((Object)"subsets");
        }
        if (subsets != null) {
            for (Subset item : subsets) {
                this.addToSubsets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSubsets() {
        return this.subsets != null && !this.subsets.isEmpty();
    }

    public SubsetsNested<A> addNewSubset() {
        return new SubsetsNested(-1, null);
    }

    public SubsetsNested<A> addNewSubsetLike(Subset item) {
        return new SubsetsNested(-1, item);
    }

    public SubsetsNested<A> setNewSubsetLike(int index, Subset item) {
        return new SubsetsNested(index, item);
    }

    public SubsetsNested<A> editSubset(int index) {
        if (this.subsets.size() <= index) {
            throw new RuntimeException("Can't edit subsets. Index exceeds size.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    public SubsetsNested<A> editFirstSubset() {
        if (this.subsets.size() == 0) {
            throw new RuntimeException("Can't edit first subsets. The list is empty.");
        }
        return this.setNewSubsetLike(0, this.buildSubset(0));
    }

    public SubsetsNested<A> editLastSubset() {
        int index = this.subsets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subsets. The list is empty.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    public SubsetsNested<A> editMatchingSubset(Predicate<SubsetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subsets.size(); ++i) {
            if (!predicate.test(this.subsets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subsets. No match found.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    public TrafficPolicy buildTrafficPolicy() {
        return this.trafficPolicy != null ? this.trafficPolicy.build() : null;
    }

    public A withTrafficPolicy(TrafficPolicy trafficPolicy) {
        this._visitables.remove((Object)this.trafficPolicy);
        if (trafficPolicy != null) {
            this.trafficPolicy = new TrafficPolicyBuilder(trafficPolicy);
            this._visitables.get((Object)"trafficPolicy").add(this.trafficPolicy);
        } else {
            this.trafficPolicy = null;
            this._visitables.get((Object)"trafficPolicy").remove((Object)this.trafficPolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasTrafficPolicy() {
        return this.trafficPolicy != null;
    }

    public TrafficPolicyNested<A> withNewTrafficPolicy() {
        return new TrafficPolicyNested(null);
    }

    public TrafficPolicyNested<A> withNewTrafficPolicyLike(TrafficPolicy item) {
        return new TrafficPolicyNested(item);
    }

    public TrafficPolicyNested<A> editTrafficPolicy() {
        return this.withNewTrafficPolicyLike(Optional.ofNullable(this.buildTrafficPolicy()).orElse(null));
    }

    public TrafficPolicyNested<A> editOrNewTrafficPolicy() {
        return this.withNewTrafficPolicyLike(Optional.ofNullable(this.buildTrafficPolicy()).orElse(new TrafficPolicyBuilder().build()));
    }

    public TrafficPolicyNested<A> editOrNewTrafficPolicyLike(TrafficPolicy item) {
        return this.withNewTrafficPolicyLike(Optional.ofNullable(this.buildTrafficPolicy()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DestinationRuleSpecFluent that = (DestinationRuleSpecFluent)((Object)o);
        if (!Objects.equals(this.exportTo, that.exportTo)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.subsets, that.subsets)) {
            return false;
        }
        return Objects.equals((Object)this.trafficPolicy, (Object)that.trafficPolicy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.exportTo, this.host, this.subsets, this.trafficPolicy, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exportTo != null && !this.exportTo.isEmpty()) {
            sb.append("exportTo:");
            sb.append(this.exportTo + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.subsets != null && !this.subsets.isEmpty()) {
            sb.append("subsets:");
            sb.append(this.subsets + ",");
        }
        if (this.trafficPolicy != null) {
            sb.append("trafficPolicy:");
            sb.append((Object)this.trafficPolicy);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TrafficPolicyNested<N>
    extends TrafficPolicyFluent<TrafficPolicyNested<N>>
    implements Nested<N> {
        TrafficPolicyBuilder builder;

        TrafficPolicyNested(TrafficPolicy item) {
            this.builder = new TrafficPolicyBuilder(this, item);
        }

        public N and() {
            return (N)DestinationRuleSpecFluent.this.withTrafficPolicy(this.builder.build());
        }

        public N endTrafficPolicy() {
            return this.and();
        }
    }

    public class SubsetsNested<N>
    extends SubsetFluent<SubsetsNested<N>>
    implements Nested<N> {
        SubsetBuilder builder;
        int index;

        SubsetsNested(int index, Subset item) {
            this.index = index;
            this.builder = new SubsetBuilder(this, item);
        }

        public N and() {
            return (N)DestinationRuleSpecFluent.this.setToSubsets(this.index, this.builder.build());
        }

        public N endSubset() {
            return this.and();
        }
    }
}

