/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.istio.api.networking.v1beta1.ServerTLSSettings;
import io.fabric8.istio.api.networking.v1beta1.ServerTLSSettingsTLSProtocol;
import io.fabric8.istio.api.networking.v1beta1.ServerTLSSettingsTLSmode;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ServerTLSSettingsFluent<A extends ServerTLSSettingsFluent<A>>
extends BaseFluent<A> {
    private String caCertificates;
    private List<String> cipherSuites = new ArrayList<String>();
    private String credentialName;
    private Boolean httpsRedirect;
    private ServerTLSSettingsTLSProtocol maxProtocolVersion;
    private ServerTLSSettingsTLSProtocol minProtocolVersion;
    private ServerTLSSettingsTLSmode mode;
    private String privateKey;
    private String serverCertificate;
    private List<String> subjectAltNames = new ArrayList<String>();
    private List<String> verifyCertificateHash = new ArrayList<String>();
    private List<String> verifyCertificateSpki = new ArrayList<String>();

    public ServerTLSSettingsFluent() {
    }

    public ServerTLSSettingsFluent(ServerTLSSettings instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServerTLSSettings instance) {
        ServerTLSSettings serverTLSSettings = instance = instance != null ? instance : new ServerTLSSettings();
        if (instance != null) {
            this.withCaCertificates(instance.getCaCertificates());
            this.withCipherSuites(instance.getCipherSuites());
            this.withCredentialName(instance.getCredentialName());
            this.withHttpsRedirect(instance.getHttpsRedirect());
            this.withMaxProtocolVersion(instance.getMaxProtocolVersion());
            this.withMinProtocolVersion(instance.getMinProtocolVersion());
            this.withMode(instance.getMode());
            this.withPrivateKey(instance.getPrivateKey());
            this.withServerCertificate(instance.getServerCertificate());
            this.withSubjectAltNames(instance.getSubjectAltNames());
            this.withVerifyCertificateHash(instance.getVerifyCertificateHash());
            this.withVerifyCertificateSpki(instance.getVerifyCertificateSpki());
            this.withCaCertificates(instance.getCaCertificates());
            this.withCipherSuites(instance.getCipherSuites());
            this.withCredentialName(instance.getCredentialName());
            this.withHttpsRedirect(instance.getHttpsRedirect());
            this.withMaxProtocolVersion(instance.getMaxProtocolVersion());
            this.withMinProtocolVersion(instance.getMinProtocolVersion());
            this.withMode(instance.getMode());
            this.withPrivateKey(instance.getPrivateKey());
            this.withServerCertificate(instance.getServerCertificate());
            this.withSubjectAltNames(instance.getSubjectAltNames());
            this.withVerifyCertificateHash(instance.getVerifyCertificateHash());
            this.withVerifyCertificateSpki(instance.getVerifyCertificateSpki());
        }
    }

    public String getCaCertificates() {
        return this.caCertificates;
    }

    public A withCaCertificates(String caCertificates) {
        this.caCertificates = caCertificates;
        return (A)((Object)this);
    }

    public boolean hasCaCertificates() {
        return this.caCertificates != null;
    }

    public A addToCipherSuites(int index, String item) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        this.cipherSuites.add(index, item);
        return (A)((Object)this);
    }

    public A setToCipherSuites(int index, String item) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        this.cipherSuites.set(index, item);
        return (A)((Object)this);
    }

    public A addToCipherSuites(String ... items) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        for (String item : items) {
            this.cipherSuites.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCipherSuites(Collection<String> items) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        for (String item : items) {
            this.cipherSuites.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCipherSuites(String ... items) {
        if (this.cipherSuites == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.cipherSuites.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCipherSuites(Collection<String> items) {
        if (this.cipherSuites == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.cipherSuites.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCipherSuites() {
        return this.cipherSuites;
    }

    public String getCipherSuite(int index) {
        return this.cipherSuites.get(index);
    }

    public String getFirstCipherSuite() {
        return this.cipherSuites.get(0);
    }

    public String getLastCipherSuite() {
        return this.cipherSuites.get(this.cipherSuites.size() - 1);
    }

    public String getMatchingCipherSuite(Predicate<String> predicate) {
        for (String item : this.cipherSuites) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCipherSuite(Predicate<String> predicate) {
        for (String item : this.cipherSuites) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCipherSuites(List<String> cipherSuites) {
        if (cipherSuites != null) {
            this.cipherSuites = new ArrayList<String>();
            for (String item : cipherSuites) {
                this.addToCipherSuites(item);
            }
        } else {
            this.cipherSuites = null;
        }
        return (A)((Object)this);
    }

    public A withCipherSuites(String ... cipherSuites) {
        if (this.cipherSuites != null) {
            this.cipherSuites.clear();
            this._visitables.remove((Object)"cipherSuites");
        }
        if (cipherSuites != null) {
            for (String item : cipherSuites) {
                this.addToCipherSuites(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCipherSuites() {
        return this.cipherSuites != null && !this.cipherSuites.isEmpty();
    }

    public String getCredentialName() {
        return this.credentialName;
    }

    public A withCredentialName(String credentialName) {
        this.credentialName = credentialName;
        return (A)((Object)this);
    }

    public boolean hasCredentialName() {
        return this.credentialName != null;
    }

    public Boolean getHttpsRedirect() {
        return this.httpsRedirect;
    }

    public A withHttpsRedirect(Boolean httpsRedirect) {
        this.httpsRedirect = httpsRedirect;
        return (A)((Object)this);
    }

    public boolean hasHttpsRedirect() {
        return this.httpsRedirect != null;
    }

    public ServerTLSSettingsTLSProtocol getMaxProtocolVersion() {
        return this.maxProtocolVersion;
    }

    public A withMaxProtocolVersion(ServerTLSSettingsTLSProtocol maxProtocolVersion) {
        this.maxProtocolVersion = maxProtocolVersion;
        return (A)((Object)this);
    }

    public boolean hasMaxProtocolVersion() {
        return this.maxProtocolVersion != null;
    }

    public ServerTLSSettingsTLSProtocol getMinProtocolVersion() {
        return this.minProtocolVersion;
    }

    public A withMinProtocolVersion(ServerTLSSettingsTLSProtocol minProtocolVersion) {
        this.minProtocolVersion = minProtocolVersion;
        return (A)((Object)this);
    }

    public boolean hasMinProtocolVersion() {
        return this.minProtocolVersion != null;
    }

    public ServerTLSSettingsTLSmode getMode() {
        return this.mode;
    }

    public A withMode(ServerTLSSettingsTLSmode mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public A withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return (A)((Object)this);
    }

    public boolean hasPrivateKey() {
        return this.privateKey != null;
    }

    public String getServerCertificate() {
        return this.serverCertificate;
    }

    public A withServerCertificate(String serverCertificate) {
        this.serverCertificate = serverCertificate;
        return (A)((Object)this);
    }

    public boolean hasServerCertificate() {
        return this.serverCertificate != null;
    }

    public A addToSubjectAltNames(int index, String item) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.add(index, item);
        return (A)((Object)this);
    }

    public A setToSubjectAltNames(int index, String item) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.set(index, item);
        return (A)((Object)this);
    }

    public A addToSubjectAltNames(String ... items) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.subjectAltNames.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSubjectAltNames(Collection<String> items) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.subjectAltNames.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSubjectAltNames(String ... items) {
        if (this.subjectAltNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.subjectAltNames.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSubjectAltNames(Collection<String> items) {
        if (this.subjectAltNames == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.subjectAltNames.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSubjectAltNames() {
        return this.subjectAltNames;
    }

    public String getSubjectAltName(int index) {
        return this.subjectAltNames.get(index);
    }

    public String getFirstSubjectAltName() {
        return this.subjectAltNames.get(0);
    }

    public String getLastSubjectAltName() {
        return this.subjectAltNames.get(this.subjectAltNames.size() - 1);
    }

    public String getMatchingSubjectAltName(Predicate<String> predicate) {
        for (String item : this.subjectAltNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSubjectAltName(Predicate<String> predicate) {
        for (String item : this.subjectAltNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubjectAltNames(List<String> subjectAltNames) {
        if (subjectAltNames != null) {
            this.subjectAltNames = new ArrayList<String>();
            for (String item : subjectAltNames) {
                this.addToSubjectAltNames(item);
            }
        } else {
            this.subjectAltNames = null;
        }
        return (A)((Object)this);
    }

    public A withSubjectAltNames(String ... subjectAltNames) {
        if (this.subjectAltNames != null) {
            this.subjectAltNames.clear();
            this._visitables.remove((Object)"subjectAltNames");
        }
        if (subjectAltNames != null) {
            for (String item : subjectAltNames) {
                this.addToSubjectAltNames(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSubjectAltNames() {
        return this.subjectAltNames != null && !this.subjectAltNames.isEmpty();
    }

    public A addToVerifyCertificateHash(int index, String item) {
        if (this.verifyCertificateHash == null) {
            this.verifyCertificateHash = new ArrayList<String>();
        }
        this.verifyCertificateHash.add(index, item);
        return (A)((Object)this);
    }

    public A setToVerifyCertificateHash(int index, String item) {
        if (this.verifyCertificateHash == null) {
            this.verifyCertificateHash = new ArrayList<String>();
        }
        this.verifyCertificateHash.set(index, item);
        return (A)((Object)this);
    }

    public A addToVerifyCertificateHash(String ... items) {
        if (this.verifyCertificateHash == null) {
            this.verifyCertificateHash = new ArrayList<String>();
        }
        for (String item : items) {
            this.verifyCertificateHash.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToVerifyCertificateHash(Collection<String> items) {
        if (this.verifyCertificateHash == null) {
            this.verifyCertificateHash = new ArrayList<String>();
        }
        for (String item : items) {
            this.verifyCertificateHash.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromVerifyCertificateHash(String ... items) {
        if (this.verifyCertificateHash == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.verifyCertificateHash.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVerifyCertificateHash(Collection<String> items) {
        if (this.verifyCertificateHash == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.verifyCertificateHash.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getVerifyCertificateHash() {
        return this.verifyCertificateHash;
    }

    public String getVerifyCertificateHash(int index) {
        return this.verifyCertificateHash.get(index);
    }

    public String getFirstVerifyCertificateHash() {
        return this.verifyCertificateHash.get(0);
    }

    public String getLastVerifyCertificateHash() {
        return this.verifyCertificateHash.get(this.verifyCertificateHash.size() - 1);
    }

    public String getMatchingVerifyCertificateHash(Predicate<String> predicate) {
        for (String item : this.verifyCertificateHash) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVerifyCertificateHash(Predicate<String> predicate) {
        for (String item : this.verifyCertificateHash) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVerifyCertificateHash(List<String> verifyCertificateHash) {
        if (verifyCertificateHash != null) {
            this.verifyCertificateHash = new ArrayList<String>();
            for (String item : verifyCertificateHash) {
                this.addToVerifyCertificateHash(item);
            }
        } else {
            this.verifyCertificateHash = null;
        }
        return (A)((Object)this);
    }

    public A withVerifyCertificateHash(String ... verifyCertificateHash) {
        if (this.verifyCertificateHash != null) {
            this.verifyCertificateHash.clear();
            this._visitables.remove((Object)"verifyCertificateHash");
        }
        if (verifyCertificateHash != null) {
            for (String item : verifyCertificateHash) {
                this.addToVerifyCertificateHash(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVerifyCertificateHash() {
        return this.verifyCertificateHash != null && !this.verifyCertificateHash.isEmpty();
    }

    public A addToVerifyCertificateSpki(int index, String item) {
        if (this.verifyCertificateSpki == null) {
            this.verifyCertificateSpki = new ArrayList<String>();
        }
        this.verifyCertificateSpki.add(index, item);
        return (A)((Object)this);
    }

    public A setToVerifyCertificateSpki(int index, String item) {
        if (this.verifyCertificateSpki == null) {
            this.verifyCertificateSpki = new ArrayList<String>();
        }
        this.verifyCertificateSpki.set(index, item);
        return (A)((Object)this);
    }

    public A addToVerifyCertificateSpki(String ... items) {
        if (this.verifyCertificateSpki == null) {
            this.verifyCertificateSpki = new ArrayList<String>();
        }
        for (String item : items) {
            this.verifyCertificateSpki.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToVerifyCertificateSpki(Collection<String> items) {
        if (this.verifyCertificateSpki == null) {
            this.verifyCertificateSpki = new ArrayList<String>();
        }
        for (String item : items) {
            this.verifyCertificateSpki.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromVerifyCertificateSpki(String ... items) {
        if (this.verifyCertificateSpki == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.verifyCertificateSpki.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVerifyCertificateSpki(Collection<String> items) {
        if (this.verifyCertificateSpki == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.verifyCertificateSpki.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getVerifyCertificateSpki() {
        return this.verifyCertificateSpki;
    }

    public String getVerifyCertificateSpki(int index) {
        return this.verifyCertificateSpki.get(index);
    }

    public String getFirstVerifyCertificateSpki() {
        return this.verifyCertificateSpki.get(0);
    }

    public String getLastVerifyCertificateSpki() {
        return this.verifyCertificateSpki.get(this.verifyCertificateSpki.size() - 1);
    }

    public String getMatchingVerifyCertificateSpki(Predicate<String> predicate) {
        for (String item : this.verifyCertificateSpki) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVerifyCertificateSpki(Predicate<String> predicate) {
        for (String item : this.verifyCertificateSpki) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVerifyCertificateSpki(List<String> verifyCertificateSpki) {
        if (verifyCertificateSpki != null) {
            this.verifyCertificateSpki = new ArrayList<String>();
            for (String item : verifyCertificateSpki) {
                this.addToVerifyCertificateSpki(item);
            }
        } else {
            this.verifyCertificateSpki = null;
        }
        return (A)((Object)this);
    }

    public A withVerifyCertificateSpki(String ... verifyCertificateSpki) {
        if (this.verifyCertificateSpki != null) {
            this.verifyCertificateSpki.clear();
            this._visitables.remove((Object)"verifyCertificateSpki");
        }
        if (verifyCertificateSpki != null) {
            for (String item : verifyCertificateSpki) {
                this.addToVerifyCertificateSpki(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVerifyCertificateSpki() {
        return this.verifyCertificateSpki != null && !this.verifyCertificateSpki.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerTLSSettingsFluent that = (ServerTLSSettingsFluent)((Object)o);
        if (!Objects.equals(this.caCertificates, that.caCertificates)) {
            return false;
        }
        if (!Objects.equals(this.cipherSuites, that.cipherSuites)) {
            return false;
        }
        if (!Objects.equals(this.credentialName, that.credentialName)) {
            return false;
        }
        if (!Objects.equals(this.httpsRedirect, that.httpsRedirect)) {
            return false;
        }
        if (!Objects.equals((Object)this.maxProtocolVersion, (Object)that.maxProtocolVersion)) {
            return false;
        }
        if (!Objects.equals((Object)this.minProtocolVersion, (Object)that.minProtocolVersion)) {
            return false;
        }
        if (!Objects.equals((Object)this.mode, (Object)that.mode)) {
            return false;
        }
        if (!Objects.equals(this.privateKey, that.privateKey)) {
            return false;
        }
        if (!Objects.equals(this.serverCertificate, that.serverCertificate)) {
            return false;
        }
        if (!Objects.equals(this.subjectAltNames, that.subjectAltNames)) {
            return false;
        }
        if (!Objects.equals(this.verifyCertificateHash, that.verifyCertificateHash)) {
            return false;
        }
        return Objects.equals(this.verifyCertificateSpki, that.verifyCertificateSpki);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.caCertificates, this.cipherSuites, this.credentialName, this.httpsRedirect, this.maxProtocolVersion, this.minProtocolVersion, this.mode, this.privateKey, this.serverCertificate, this.subjectAltNames, this.verifyCertificateHash, this.verifyCertificateSpki, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caCertificates != null) {
            sb.append("caCertificates:");
            sb.append(this.caCertificates + ",");
        }
        if (this.cipherSuites != null && !this.cipherSuites.isEmpty()) {
            sb.append("cipherSuites:");
            sb.append(this.cipherSuites + ",");
        }
        if (this.credentialName != null) {
            sb.append("credentialName:");
            sb.append(this.credentialName + ",");
        }
        if (this.httpsRedirect != null) {
            sb.append("httpsRedirect:");
            sb.append(this.httpsRedirect + ",");
        }
        if (this.maxProtocolVersion != null) {
            sb.append("maxProtocolVersion:");
            sb.append((Object)((Object)this.maxProtocolVersion) + ",");
        }
        if (this.minProtocolVersion != null) {
            sb.append("minProtocolVersion:");
            sb.append((Object)((Object)this.minProtocolVersion) + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append((Object)((Object)this.mode) + ",");
        }
        if (this.privateKey != null) {
            sb.append("privateKey:");
            sb.append(this.privateKey + ",");
        }
        if (this.serverCertificate != null) {
            sb.append("serverCertificate:");
            sb.append(this.serverCertificate + ",");
        }
        if (this.subjectAltNames != null && !this.subjectAltNames.isEmpty()) {
            sb.append("subjectAltNames:");
            sb.append(this.subjectAltNames + ",");
        }
        if (this.verifyCertificateHash != null && !this.verifyCertificateHash.isEmpty()) {
            sb.append("verifyCertificateHash:");
            sb.append(this.verifyCertificateHash + ",");
        }
        if (this.verifyCertificateSpki != null && !this.verifyCertificateSpki.isEmpty()) {
            sb.append("verifyCertificateSpki:");
            sb.append(this.verifyCertificateSpki);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withHttpsRedirect() {
        return this.withHttpsRedirect(true);
    }
}

