/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.istio.api.networking.v1beta1.OutlierDetection;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Objects;

public class OutlierDetectionFluent<A extends OutlierDetectionFluent<A>>
extends BaseFluent<A> {
    private String baseEjectionTime;
    private Integer consecutive5xxErrors;
    private Integer consecutiveErrors;
    private Integer consecutiveGatewayErrors;
    private Integer consecutiveLocalOriginFailures;
    private String interval;
    private Integer maxEjectionPercent;
    private Integer minHealthPercent;
    private Boolean splitExternalLocalOriginErrors;

    public OutlierDetectionFluent() {
    }

    public OutlierDetectionFluent(OutlierDetection instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OutlierDetection instance) {
        OutlierDetection outlierDetection = instance = instance != null ? instance : new OutlierDetection();
        if (instance != null) {
            this.withBaseEjectionTime(instance.getBaseEjectionTime());
            this.withConsecutive5xxErrors(instance.getConsecutive5xxErrors());
            this.withConsecutiveErrors(instance.getConsecutiveErrors());
            this.withConsecutiveGatewayErrors(instance.getConsecutiveGatewayErrors());
            this.withConsecutiveLocalOriginFailures(instance.getConsecutiveLocalOriginFailures());
            this.withInterval(instance.getInterval());
            this.withMaxEjectionPercent(instance.getMaxEjectionPercent());
            this.withMinHealthPercent(instance.getMinHealthPercent());
            this.withSplitExternalLocalOriginErrors(instance.getSplitExternalLocalOriginErrors());
            this.withBaseEjectionTime(instance.getBaseEjectionTime());
            this.withConsecutive5xxErrors(instance.getConsecutive5xxErrors());
            this.withConsecutiveErrors(instance.getConsecutiveErrors());
            this.withConsecutiveGatewayErrors(instance.getConsecutiveGatewayErrors());
            this.withConsecutiveLocalOriginFailures(instance.getConsecutiveLocalOriginFailures());
            this.withInterval(instance.getInterval());
            this.withMaxEjectionPercent(instance.getMaxEjectionPercent());
            this.withMinHealthPercent(instance.getMinHealthPercent());
            this.withSplitExternalLocalOriginErrors(instance.getSplitExternalLocalOriginErrors());
        }
    }

    public String getBaseEjectionTime() {
        return this.baseEjectionTime;
    }

    public A withBaseEjectionTime(String baseEjectionTime) {
        this.baseEjectionTime = baseEjectionTime;
        return (A)((Object)this);
    }

    public boolean hasBaseEjectionTime() {
        return this.baseEjectionTime != null;
    }

    public Integer getConsecutive5xxErrors() {
        return this.consecutive5xxErrors;
    }

    public A withConsecutive5xxErrors(Integer consecutive5xxErrors) {
        this.consecutive5xxErrors = consecutive5xxErrors;
        return (A)((Object)this);
    }

    public boolean hasConsecutive5xxErrors() {
        return this.consecutive5xxErrors != null;
    }

    public Integer getConsecutiveErrors() {
        return this.consecutiveErrors;
    }

    public A withConsecutiveErrors(Integer consecutiveErrors) {
        this.consecutiveErrors = consecutiveErrors;
        return (A)((Object)this);
    }

    public boolean hasConsecutiveErrors() {
        return this.consecutiveErrors != null;
    }

    public Integer getConsecutiveGatewayErrors() {
        return this.consecutiveGatewayErrors;
    }

    public A withConsecutiveGatewayErrors(Integer consecutiveGatewayErrors) {
        this.consecutiveGatewayErrors = consecutiveGatewayErrors;
        return (A)((Object)this);
    }

    public boolean hasConsecutiveGatewayErrors() {
        return this.consecutiveGatewayErrors != null;
    }

    public Integer getConsecutiveLocalOriginFailures() {
        return this.consecutiveLocalOriginFailures;
    }

    public A withConsecutiveLocalOriginFailures(Integer consecutiveLocalOriginFailures) {
        this.consecutiveLocalOriginFailures = consecutiveLocalOriginFailures;
        return (A)((Object)this);
    }

    public boolean hasConsecutiveLocalOriginFailures() {
        return this.consecutiveLocalOriginFailures != null;
    }

    public String getInterval() {
        return this.interval;
    }

    public A withInterval(String interval) {
        this.interval = interval;
        return (A)((Object)this);
    }

    public boolean hasInterval() {
        return this.interval != null;
    }

    public Integer getMaxEjectionPercent() {
        return this.maxEjectionPercent;
    }

    public A withMaxEjectionPercent(Integer maxEjectionPercent) {
        this.maxEjectionPercent = maxEjectionPercent;
        return (A)((Object)this);
    }

    public boolean hasMaxEjectionPercent() {
        return this.maxEjectionPercent != null;
    }

    public Integer getMinHealthPercent() {
        return this.minHealthPercent;
    }

    public A withMinHealthPercent(Integer minHealthPercent) {
        this.minHealthPercent = minHealthPercent;
        return (A)((Object)this);
    }

    public boolean hasMinHealthPercent() {
        return this.minHealthPercent != null;
    }

    public Boolean getSplitExternalLocalOriginErrors() {
        return this.splitExternalLocalOriginErrors;
    }

    public A withSplitExternalLocalOriginErrors(Boolean splitExternalLocalOriginErrors) {
        this.splitExternalLocalOriginErrors = splitExternalLocalOriginErrors;
        return (A)((Object)this);
    }

    public boolean hasSplitExternalLocalOriginErrors() {
        return this.splitExternalLocalOriginErrors != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OutlierDetectionFluent that = (OutlierDetectionFluent)((Object)o);
        if (!Objects.equals(this.baseEjectionTime, that.baseEjectionTime)) {
            return false;
        }
        if (!Objects.equals(this.consecutive5xxErrors, that.consecutive5xxErrors)) {
            return false;
        }
        if (!Objects.equals(this.consecutiveErrors, that.consecutiveErrors)) {
            return false;
        }
        if (!Objects.equals(this.consecutiveGatewayErrors, that.consecutiveGatewayErrors)) {
            return false;
        }
        if (!Objects.equals(this.consecutiveLocalOriginFailures, that.consecutiveLocalOriginFailures)) {
            return false;
        }
        if (!Objects.equals(this.interval, that.interval)) {
            return false;
        }
        if (!Objects.equals(this.maxEjectionPercent, that.maxEjectionPercent)) {
            return false;
        }
        if (!Objects.equals(this.minHealthPercent, that.minHealthPercent)) {
            return false;
        }
        return Objects.equals(this.splitExternalLocalOriginErrors, that.splitExternalLocalOriginErrors);
    }

    public int hashCode() {
        return Objects.hash(this.baseEjectionTime, this.consecutive5xxErrors, this.consecutiveErrors, this.consecutiveGatewayErrors, this.consecutiveLocalOriginFailures, this.interval, this.maxEjectionPercent, this.minHealthPercent, this.splitExternalLocalOriginErrors, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseEjectionTime != null) {
            sb.append("baseEjectionTime:");
            sb.append(this.baseEjectionTime + ",");
        }
        if (this.consecutive5xxErrors != null) {
            sb.append("consecutive5xxErrors:");
            sb.append(this.consecutive5xxErrors + ",");
        }
        if (this.consecutiveErrors != null) {
            sb.append("consecutiveErrors:");
            sb.append(this.consecutiveErrors + ",");
        }
        if (this.consecutiveGatewayErrors != null) {
            sb.append("consecutiveGatewayErrors:");
            sb.append(this.consecutiveGatewayErrors + ",");
        }
        if (this.consecutiveLocalOriginFailures != null) {
            sb.append("consecutiveLocalOriginFailures:");
            sb.append(this.consecutiveLocalOriginFailures + ",");
        }
        if (this.interval != null) {
            sb.append("interval:");
            sb.append(this.interval + ",");
        }
        if (this.maxEjectionPercent != null) {
            sb.append("maxEjectionPercent:");
            sb.append(this.maxEjectionPercent + ",");
        }
        if (this.minHealthPercent != null) {
            sb.append("minHealthPercent:");
            sb.append(this.minHealthPercent + ",");
        }
        if (this.splitExternalLocalOriginErrors != null) {
            sb.append("splitExternalLocalOriginErrors:");
            sb.append(this.splitExternalLocalOriginErrors);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSplitExternalLocalOriginErrors() {
        return this.withSplitExternalLocalOriginErrors(true);
    }
}

