package io.fabric8.istio.api.security.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelector;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorFluent;
import java.util.Map;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PeerAuthenticationSpecFluent<A extends PeerAuthenticationSpecFluent<A>> extends BaseFluent<A>{
  public PeerAuthenticationSpecFluent() {
  }
  
  public PeerAuthenticationSpecFluent(PeerAuthenticationSpec instance) {
    this.copyInstance(instance);
  }
  private PeerAuthenticationMutualTLSBuilder mtls;
  private Map<Long,PeerAuthenticationMutualTLS> portLevelMtls;
  private WorkloadSelectorBuilder selector;
  
  protected void copyInstance(PeerAuthenticationSpec instance) {
    instance = (instance != null ? instance : new PeerAuthenticationSpec());
  
    if (instance != null) {
        this.withMtls(instance.getMtls());
        this.withPortLevelMtls(instance.getPortLevelMtls());
        this.withSelector(instance.getSelector());
        this.withMtls(instance.getMtls());
        this.withPortLevelMtls(instance.getPortLevelMtls());
        this.withSelector(instance.getSelector());
      }
  }
  
  public PeerAuthenticationMutualTLS buildMtls() {
    return this.mtls!=null ?this.mtls.build():null;
  }
  
  public A withMtls(PeerAuthenticationMutualTLS mtls) {
    _visitables.get("mtls").remove(this.mtls);
    if (mtls!=null){ this.mtls= new PeerAuthenticationMutualTLSBuilder(mtls); _visitables.get("mtls").add(this.mtls);} else { this.mtls = null; _visitables.get("mtls").remove(this.mtls); } return (A) this;
  }
  
  public boolean hasMtls() {
    return this.mtls != null;
  }
  
  public MtlsNested<A> withNewMtls() {
    return new MtlsNested(null);
  }
  
  public MtlsNested<A> withNewMtlsLike(PeerAuthenticationMutualTLS item) {
    return new MtlsNested(item);
  }
  
  public MtlsNested<A> editMtls() {
    return withNewMtlsLike(java.util.Optional.ofNullable(buildMtls()).orElse(null));
  }
  
  public MtlsNested<A> editOrNewMtls() {
    return withNewMtlsLike(java.util.Optional.ofNullable(buildMtls()).orElse(new PeerAuthenticationMutualTLSBuilder().build()));
  }
  
  public MtlsNested<A> editOrNewMtlsLike(PeerAuthenticationMutualTLS item) {
    return withNewMtlsLike(java.util.Optional.ofNullable(buildMtls()).orElse(item));
  }
  
  public A addToPortLevelMtls(Long key,PeerAuthenticationMutualTLS value) {
    if(this.portLevelMtls == null && key != null && value != null) { this.portLevelMtls = new LinkedHashMap(); }
    if(key != null && value != null) {this.portLevelMtls.put(key, value);} return (A)this;
  }
  
  public A addToPortLevelMtls(Map<Long,PeerAuthenticationMutualTLS> map) {
    if(this.portLevelMtls == null && map != null) { this.portLevelMtls = new LinkedHashMap(); }
    if(map != null) { this.portLevelMtls.putAll(map);} return (A)this;
  }
  
  public A removeFromPortLevelMtls(Long key) {
    if(this.portLevelMtls == null) { return (A) this; }
    if(key != null && this.portLevelMtls != null) {this.portLevelMtls.remove(key);} return (A)this;
  }
  
  public A removeFromPortLevelMtls(Map<Long,PeerAuthenticationMutualTLS> map) {
    if(this.portLevelMtls == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.portLevelMtls != null){this.portLevelMtls.remove(key);}}} return (A)this;
  }
  
  public Map<Long,PeerAuthenticationMutualTLS> getPortLevelMtls() {
    return this.portLevelMtls;
  }
  
  public <K,V>A withPortLevelMtls(Map<Long,PeerAuthenticationMutualTLS> portLevelMtls) {
    if (portLevelMtls == null) { this.portLevelMtls =  null;} else {this.portLevelMtls = new LinkedHashMap(portLevelMtls);} return (A) this;
  }
  
  public boolean hasPortLevelMtls() {
    return this.portLevelMtls != null;
  }
  
  public WorkloadSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  
  public A withSelector(WorkloadSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new WorkloadSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public TypeSelectorNested<A> withNewTypeSelector() {
    return new TypeSelectorNested(null);
  }
  
  public TypeSelectorNested<A> withNewSelectorLike(WorkloadSelector item) {
    return new TypeSelectorNested(item);
  }
  
  public TypeSelectorNested<A> editTypeSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public TypeSelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new WorkloadSelectorBuilder().build()));
  }
  
  public TypeSelectorNested<A> editOrNewSelectorLike(WorkloadSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PeerAuthenticationSpecFluent that = (PeerAuthenticationSpecFluent) o;
    if (!java.util.Objects.equals(mtls, that.mtls)) return false;
  
    if (!java.util.Objects.equals(portLevelMtls, that.portLevelMtls)) return false;
  
    if (!java.util.Objects.equals(selector, that.selector)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(mtls,  portLevelMtls,  selector,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mtls != null) { sb.append("mtls:"); sb.append(mtls + ","); }
    if (portLevelMtls != null && !portLevelMtls.isEmpty()) { sb.append("portLevelMtls:"); sb.append(portLevelMtls + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector); }
    sb.append("}");
    return sb.toString();
  }
  public class MtlsNested<N> extends PeerAuthenticationMutualTLSFluent<MtlsNested<N>> implements Nested<N>{
    MtlsNested(PeerAuthenticationMutualTLS item) {
      this.builder = new PeerAuthenticationMutualTLSBuilder(this, item);
    }
    PeerAuthenticationMutualTLSBuilder builder;
    
    public N and() {
      return (N) PeerAuthenticationSpecFluent.this.withMtls(builder.build());
    }
    
    public N endMtls() {
      return and();
    }
    
  
  }
  public class TypeSelectorNested<N> extends WorkloadSelectorFluent<TypeSelectorNested<N>> implements Nested<N>{
    TypeSelectorNested(WorkloadSelector item) {
      this.builder = new WorkloadSelectorBuilder(this, item);
    }
    WorkloadSelectorBuilder builder;
    
    public N and() {
      return (N) PeerAuthenticationSpecFluent.this.withSelector(builder.build());
    }
    
    public N endTypeSelector() {
      return and();
    }
    
  
  }

}