package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JWTRuleBuilder extends JWTRuleFluent<JWTRuleBuilder> implements VisitableBuilder<JWTRule,JWTRuleBuilder>{
  public JWTRuleBuilder() {
    this(new JWTRule());
  }
  
  public JWTRuleBuilder(JWTRuleFluent<?> fluent) {
    this(fluent, new JWTRule());
  }
  
  public JWTRuleBuilder(JWTRuleFluent<?> fluent,JWTRule instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JWTRuleBuilder(JWTRule instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JWTRuleFluent<?> fluent;
  
  public JWTRule build() {
    JWTRule buildable = new JWTRule(fluent.getAudiences(),fluent.getForwardOriginalToken(),fluent.buildFromHeaders(),fluent.getFromParams(),fluent.getIssuer(),fluent.getJwks(),fluent.getJwksUri(),fluent.getOutputPayloadToHeader());
    return buildable;
  }
  

}