package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JWTHeaderBuilder extends JWTHeaderFluent<JWTHeaderBuilder> implements VisitableBuilder<JWTHeader,JWTHeaderBuilder>{
  public JWTHeaderBuilder() {
    this(new JWTHeader());
  }
  
  public JWTHeaderBuilder(JWTHeaderFluent<?> fluent) {
    this(fluent, new JWTHeader());
  }
  
  public JWTHeaderBuilder(JWTHeaderFluent<?> fluent,JWTHeader instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JWTHeaderBuilder(JWTHeader instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JWTHeaderFluent<?> fluent;
  
  public JWTHeader build() {
    JWTHeader buildable = new JWTHeader(fluent.getName(),fluent.getPrefix());
    return buildable;
  }
  

}