package io.fabric8.istio.api.security.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConditionFluent<A extends ConditionFluent<A>> extends BaseFluent<A>{
  public ConditionFluent() {
  }
  
  public ConditionFluent(Condition instance) {
    this.copyInstance(instance);
  }
  private String key;
  private List<String> notValues = new ArrayList<String>();
  private List<String> values = new ArrayList<String>();
  
  protected void copyInstance(Condition instance) {
    instance = (instance != null ? instance : new Condition());
  
    if (instance != null) {
        this.withKey(instance.getKey());
        this.withNotValues(instance.getNotValues());
        this.withValues(instance.getValues());
        this.withKey(instance.getKey());
        this.withNotValues(instance.getNotValues());
        this.withValues(instance.getValues());
      }
  }
  
  public String getKey() {
    return this.key;
  }
  
  public A withKey(String key) {
    this.key=key; return (A) this;
  }
  
  public boolean hasKey() {
    return this.key != null;
  }
  
  public A addToNotValues(int index,String item) {
    if (this.notValues == null) {this.notValues = new ArrayList<String>();}
    this.notValues.add(index, item);
    return (A)this;
  }
  
  public A setToNotValues(int index,String item) {
    if (this.notValues == null) {this.notValues = new ArrayList<String>();}
    this.notValues.set(index, item); return (A)this;
  }
  
  public A addToNotValues(java.lang.String... items) {
    if (this.notValues == null) {this.notValues = new ArrayList<String>();}
    for (String item : items) {this.notValues.add(item);} return (A)this;
  }
  
  public A addAllToNotValues(Collection<String> items) {
    if (this.notValues == null) {this.notValues = new ArrayList<String>();}
    for (String item : items) {this.notValues.add(item);} return (A)this;
  }
  
  public A removeFromNotValues(java.lang.String... items) {
    if (this.notValues == null) return (A)this;
    for (String item : items) { this.notValues.remove(item);} return (A)this;
  }
  
  public A removeAllFromNotValues(Collection<String> items) {
    if (this.notValues == null) return (A)this;
    for (String item : items) { this.notValues.remove(item);} return (A)this;
  }
  
  public List<String> getNotValues() {
    return this.notValues;
  }
  
  public String getNotValue(int index) {
    return this.notValues.get(index);
  }
  
  public String getFirstNotValue() {
    return this.notValues.get(0);
  }
  
  public String getLastNotValue() {
    return this.notValues.get(notValues.size() - 1);
  }
  
  public String getMatchingNotValue(Predicate<String> predicate) {
    for (String item: notValues) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingNotValue(Predicate<String> predicate) {
    for (String item: notValues) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withNotValues(List<String> notValues) {
    if (notValues != null) {this.notValues = new ArrayList(); for (String item : notValues){this.addToNotValues(item);}} else { this.notValues = null;} return (A) this;
  }
  
  public A withNotValues(java.lang.String... notValues) {
    if (this.notValues != null) {this.notValues.clear(); _visitables.remove("notValues"); }
    if (notValues != null) {for (String item :notValues){ this.addToNotValues(item);}} return (A) this;
  }
  
  public boolean hasNotValues() {
    return notValues != null && !notValues.isEmpty();
  }
  
  public A addToValues(int index,String item) {
    if (this.values == null) {this.values = new ArrayList<String>();}
    this.values.add(index, item);
    return (A)this;
  }
  
  public A setToValues(int index,String item) {
    if (this.values == null) {this.values = new ArrayList<String>();}
    this.values.set(index, item); return (A)this;
  }
  
  public A addToValues(java.lang.String... items) {
    if (this.values == null) {this.values = new ArrayList<String>();}
    for (String item : items) {this.values.add(item);} return (A)this;
  }
  
  public A addAllToValues(Collection<String> items) {
    if (this.values == null) {this.values = new ArrayList<String>();}
    for (String item : items) {this.values.add(item);} return (A)this;
  }
  
  public A removeFromValues(java.lang.String... items) {
    if (this.values == null) return (A)this;
    for (String item : items) { this.values.remove(item);} return (A)this;
  }
  
  public A removeAllFromValues(Collection<String> items) {
    if (this.values == null) return (A)this;
    for (String item : items) { this.values.remove(item);} return (A)this;
  }
  
  public List<String> getValues() {
    return this.values;
  }
  
  public String getValue(int index) {
    return this.values.get(index);
  }
  
  public String getFirstValue() {
    return this.values.get(0);
  }
  
  public String getLastValue() {
    return this.values.get(values.size() - 1);
  }
  
  public String getMatchingValue(Predicate<String> predicate) {
    for (String item: values) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingValue(Predicate<String> predicate) {
    for (String item: values) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withValues(List<String> values) {
    if (values != null) {this.values = new ArrayList(); for (String item : values){this.addToValues(item);}} else { this.values = null;} return (A) this;
  }
  
  public A withValues(java.lang.String... values) {
    if (this.values != null) {this.values.clear(); _visitables.remove("values"); }
    if (values != null) {for (String item :values){ this.addToValues(item);}} return (A) this;
  }
  
  public boolean hasValues() {
    return values != null && !values.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConditionFluent that = (ConditionFluent) o;
    if (!java.util.Objects.equals(key, that.key)) return false;
  
    if (!java.util.Objects.equals(notValues, that.notValues)) return false;
  
    if (!java.util.Objects.equals(values, that.values)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(key,  notValues,  values,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (key != null) { sb.append("key:"); sb.append(key + ","); }
    if (notValues != null && !notValues.isEmpty()) { sb.append("notValues:"); sb.append(notValues + ","); }
    if (values != null && !values.isEmpty()) { sb.append("values:"); sb.append(values); }
    sb.append("}");
    return sb.toString();
  }
  

}