package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WorkloadEntrySpecBuilder extends WorkloadEntrySpecFluent<WorkloadEntrySpecBuilder> implements VisitableBuilder<WorkloadEntrySpec,WorkloadEntrySpecBuilder>{
  public WorkloadEntrySpecBuilder() {
    this(new WorkloadEntrySpec());
  }
  
  public WorkloadEntrySpecBuilder(WorkloadEntrySpecFluent<?> fluent) {
    this(fluent, new WorkloadEntrySpec());
  }
  
  public WorkloadEntrySpecBuilder(WorkloadEntrySpecFluent<?> fluent,WorkloadEntrySpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WorkloadEntrySpecBuilder(WorkloadEntrySpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WorkloadEntrySpecFluent<?> fluent;
  
  public WorkloadEntrySpec build() {
    WorkloadEntrySpec buildable = new WorkloadEntrySpec(fluent.getAddress(),fluent.getLabels(),fluent.getLocality(),fluent.getNetwork(),fluent.getPorts(),fluent.getServiceAccount(),fluent.getWeight());
    return buildable;
  }
  

}