package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TrafficPolicyFluent<A extends TrafficPolicyFluent<A>> extends BaseFluent<A>{
  public TrafficPolicyFluent() {
  }
  
  public TrafficPolicyFluent(TrafficPolicy instance) {
    this.copyInstance(instance);
  }
  private ConnectionPoolSettingsBuilder connectionPool;
  private LoadBalancerSettingsBuilder loadBalancer;
  private OutlierDetectionBuilder outlierDetection;
  private ArrayList<TrafficPolicyPortTrafficPolicyBuilder> portLevelSettings = new ArrayList<TrafficPolicyPortTrafficPolicyBuilder>();
  private ClientTLSSettingsBuilder tls;
  
  protected void copyInstance(TrafficPolicy instance) {
    instance = (instance != null ? instance : new TrafficPolicy());
  
    if (instance != null) {
        this.withConnectionPool(instance.getConnectionPool());
        this.withLoadBalancer(instance.getLoadBalancer());
        this.withOutlierDetection(instance.getOutlierDetection());
        this.withPortLevelSettings(instance.getPortLevelSettings());
        this.withTls(instance.getTls());
        this.withConnectionPool(instance.getConnectionPool());
        this.withLoadBalancer(instance.getLoadBalancer());
        this.withOutlierDetection(instance.getOutlierDetection());
        this.withPortLevelSettings(instance.getPortLevelSettings());
        this.withTls(instance.getTls());
      }
  }
  
  public ConnectionPoolSettings buildConnectionPool() {
    return this.connectionPool!=null ?this.connectionPool.build():null;
  }
  
  public A withConnectionPool(ConnectionPoolSettings connectionPool) {
    _visitables.get("connectionPool").remove(this.connectionPool);
    if (connectionPool!=null){ this.connectionPool= new ConnectionPoolSettingsBuilder(connectionPool); _visitables.get("connectionPool").add(this.connectionPool);} else { this.connectionPool = null; _visitables.get("connectionPool").remove(this.connectionPool); } return (A) this;
  }
  
  public boolean hasConnectionPool() {
    return this.connectionPool != null;
  }
  
  public ConnectionPoolNested<A> withNewConnectionPool() {
    return new ConnectionPoolNested(null);
  }
  
  public ConnectionPoolNested<A> withNewConnectionPoolLike(ConnectionPoolSettings item) {
    return new ConnectionPoolNested(item);
  }
  
  public ConnectionPoolNested<A> editConnectionPool() {
    return withNewConnectionPoolLike(java.util.Optional.ofNullable(buildConnectionPool()).orElse(null));
  }
  
  public ConnectionPoolNested<A> editOrNewConnectionPool() {
    return withNewConnectionPoolLike(java.util.Optional.ofNullable(buildConnectionPool()).orElse(new ConnectionPoolSettingsBuilder().build()));
  }
  
  public ConnectionPoolNested<A> editOrNewConnectionPoolLike(ConnectionPoolSettings item) {
    return withNewConnectionPoolLike(java.util.Optional.ofNullable(buildConnectionPool()).orElse(item));
  }
  
  public LoadBalancerSettings buildLoadBalancer() {
    return this.loadBalancer!=null ?this.loadBalancer.build():null;
  }
  
  public A withLoadBalancer(LoadBalancerSettings loadBalancer) {
    _visitables.get("loadBalancer").remove(this.loadBalancer);
    if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerSettingsBuilder(loadBalancer); _visitables.get("loadBalancer").add(this.loadBalancer);} else { this.loadBalancer = null; _visitables.get("loadBalancer").remove(this.loadBalancer); } return (A) this;
  }
  
  public boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  
  public LoadBalancerNested<A> withNewLoadBalancer() {
    return new LoadBalancerNested(null);
  }
  
  public LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerSettings item) {
    return new LoadBalancerNested(item);
  }
  
  public LoadBalancerNested<A> editLoadBalancer() {
    return withNewLoadBalancerLike(java.util.Optional.ofNullable(buildLoadBalancer()).orElse(null));
  }
  
  public LoadBalancerNested<A> editOrNewLoadBalancer() {
    return withNewLoadBalancerLike(java.util.Optional.ofNullable(buildLoadBalancer()).orElse(new LoadBalancerSettingsBuilder().build()));
  }
  
  public LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerSettings item) {
    return withNewLoadBalancerLike(java.util.Optional.ofNullable(buildLoadBalancer()).orElse(item));
  }
  
  public OutlierDetection buildOutlierDetection() {
    return this.outlierDetection!=null ?this.outlierDetection.build():null;
  }
  
  public A withOutlierDetection(OutlierDetection outlierDetection) {
    _visitables.get("outlierDetection").remove(this.outlierDetection);
    if (outlierDetection!=null){ this.outlierDetection= new OutlierDetectionBuilder(outlierDetection); _visitables.get("outlierDetection").add(this.outlierDetection);} else { this.outlierDetection = null; _visitables.get("outlierDetection").remove(this.outlierDetection); } return (A) this;
  }
  
  public boolean hasOutlierDetection() {
    return this.outlierDetection != null;
  }
  
  public OutlierDetectionNested<A> withNewOutlierDetection() {
    return new OutlierDetectionNested(null);
  }
  
  public OutlierDetectionNested<A> withNewOutlierDetectionLike(OutlierDetection item) {
    return new OutlierDetectionNested(item);
  }
  
  public OutlierDetectionNested<A> editOutlierDetection() {
    return withNewOutlierDetectionLike(java.util.Optional.ofNullable(buildOutlierDetection()).orElse(null));
  }
  
  public OutlierDetectionNested<A> editOrNewOutlierDetection() {
    return withNewOutlierDetectionLike(java.util.Optional.ofNullable(buildOutlierDetection()).orElse(new OutlierDetectionBuilder().build()));
  }
  
  public OutlierDetectionNested<A> editOrNewOutlierDetectionLike(OutlierDetection item) {
    return withNewOutlierDetectionLike(java.util.Optional.ofNullable(buildOutlierDetection()).orElse(item));
  }
  
  public A addToPortLevelSettings(int index,TrafficPolicyPortTrafficPolicy item) {
    if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<TrafficPolicyPortTrafficPolicyBuilder>();}
    TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);
    if (index < 0 || index >= portLevelSettings.size()) { _visitables.get("portLevelSettings").add(builder); portLevelSettings.add(builder); } else { _visitables.get("portLevelSettings").add(index, builder); portLevelSettings.add(index, builder);}
    return (A)this;
  }
  
  public A setToPortLevelSettings(int index,TrafficPolicyPortTrafficPolicy item) {
    if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<TrafficPolicyPortTrafficPolicyBuilder>();}
    TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);
    if (index < 0 || index >= portLevelSettings.size()) { _visitables.get("portLevelSettings").add(builder); portLevelSettings.add(builder); } else { _visitables.get("portLevelSettings").set(index, builder); portLevelSettings.set(index, builder);}
    return (A)this;
  }
  
  public A addToPortLevelSettings(io.fabric8.istio.api.networking.v1beta1.TrafficPolicyPortTrafficPolicy... items) {
    if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<TrafficPolicyPortTrafficPolicyBuilder>();}
    for (TrafficPolicyPortTrafficPolicy item : items) {TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").add(builder);this.portLevelSettings.add(builder);} return (A)this;
  }
  
  public A addAllToPortLevelSettings(Collection<TrafficPolicyPortTrafficPolicy> items) {
    if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<TrafficPolicyPortTrafficPolicyBuilder>();}
    for (TrafficPolicyPortTrafficPolicy item : items) {TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").add(builder);this.portLevelSettings.add(builder);} return (A)this;
  }
  
  public A removeFromPortLevelSettings(io.fabric8.istio.api.networking.v1beta1.TrafficPolicyPortTrafficPolicy... items) {
    if (this.portLevelSettings == null) return (A)this;
    for (TrafficPolicyPortTrafficPolicy item : items) {TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").remove(builder); this.portLevelSettings.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPortLevelSettings(Collection<TrafficPolicyPortTrafficPolicy> items) {
    if (this.portLevelSettings == null) return (A)this;
    for (TrafficPolicyPortTrafficPolicy item : items) {TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").remove(builder); this.portLevelSettings.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPortLevelSettings(Predicate<TrafficPolicyPortTrafficPolicyBuilder> predicate) {
    if (portLevelSettings == null) return (A) this;
    final Iterator<TrafficPolicyPortTrafficPolicyBuilder> each = portLevelSettings.iterator();
    final List visitables = _visitables.get("portLevelSettings");
    while (each.hasNext()) {
      TrafficPolicyPortTrafficPolicyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TrafficPolicyPortTrafficPolicy> buildPortLevelSettings() {
    return portLevelSettings != null ? build(portLevelSettings) : null;
  }
  
  public TrafficPolicyPortTrafficPolicy buildPortLevelSetting(int index) {
    return this.portLevelSettings.get(index).build();
  }
  
  public TrafficPolicyPortTrafficPolicy buildFirstPortLevelSetting() {
    return this.portLevelSettings.get(0).build();
  }
  
  public TrafficPolicyPortTrafficPolicy buildLastPortLevelSetting() {
    return this.portLevelSettings.get(portLevelSettings.size() - 1).build();
  }
  
  public TrafficPolicyPortTrafficPolicy buildMatchingPortLevelSetting(Predicate<TrafficPolicyPortTrafficPolicyBuilder> predicate) {
    for (TrafficPolicyPortTrafficPolicyBuilder item: portLevelSettings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingPortLevelSetting(Predicate<TrafficPolicyPortTrafficPolicyBuilder> predicate) {
    for (TrafficPolicyPortTrafficPolicyBuilder item: portLevelSettings) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withPortLevelSettings(List<TrafficPolicyPortTrafficPolicy> portLevelSettings) {
    if (this.portLevelSettings != null) { _visitables.get("portLevelSettings").clear();}
    if (portLevelSettings != null) {this.portLevelSettings = new ArrayList(); for (TrafficPolicyPortTrafficPolicy item : portLevelSettings){this.addToPortLevelSettings(item);}} else { this.portLevelSettings = null;} return (A) this;
  }
  
  public A withPortLevelSettings(io.fabric8.istio.api.networking.v1beta1.TrafficPolicyPortTrafficPolicy... portLevelSettings) {
    if (this.portLevelSettings != null) {this.portLevelSettings.clear(); _visitables.remove("portLevelSettings"); }
    if (portLevelSettings != null) {for (TrafficPolicyPortTrafficPolicy item :portLevelSettings){ this.addToPortLevelSettings(item);}} return (A) this;
  }
  
  public boolean hasPortLevelSettings() {
    return portLevelSettings != null && !portLevelSettings.isEmpty();
  }
  
  public PortLevelSettingsNested<A> addNewPortLevelSetting() {
    return new PortLevelSettingsNested(-1, null);
  }
  
  public PortLevelSettingsNested<A> addNewPortLevelSettingLike(TrafficPolicyPortTrafficPolicy item) {
    return new PortLevelSettingsNested(-1, item);
  }
  
  public PortLevelSettingsNested<A> setNewPortLevelSettingLike(int index,TrafficPolicyPortTrafficPolicy item) {
    return new PortLevelSettingsNested(index, item);
  }
  
  public PortLevelSettingsNested<A> editPortLevelSetting(int index) {
    if (portLevelSettings.size() <= index) throw new RuntimeException("Can't edit portLevelSettings. Index exceeds size.");
    return setNewPortLevelSettingLike(index, buildPortLevelSetting(index));
  }
  
  public PortLevelSettingsNested<A> editFirstPortLevelSetting() {
    if (portLevelSettings.size() == 0) throw new RuntimeException("Can't edit first portLevelSettings. The list is empty.");
    return setNewPortLevelSettingLike(0, buildPortLevelSetting(0));
  }
  
  public PortLevelSettingsNested<A> editLastPortLevelSetting() {
    int index = portLevelSettings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last portLevelSettings. The list is empty.");
    return setNewPortLevelSettingLike(index, buildPortLevelSetting(index));
  }
  
  public PortLevelSettingsNested<A> editMatchingPortLevelSetting(Predicate<TrafficPolicyPortTrafficPolicyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<portLevelSettings.size();i++) { 
    if (predicate.test(portLevelSettings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching portLevelSettings. No match found.");
    return setNewPortLevelSettingLike(index, buildPortLevelSetting(index));
  }
  
  public ClientTLSSettings buildTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  
  public A withTls(ClientTLSSettings tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new ClientTLSSettingsBuilder(tls); _visitables.get("tls").add(this.tls);} else { this.tls = null; _visitables.get("tls").remove(this.tls); } return (A) this;
  }
  
  public boolean hasTls() {
    return this.tls != null;
  }
  
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  
  public TlsNested<A> withNewTlsLike(ClientTLSSettings item) {
    return new TlsNested(item);
  }
  
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(null));
  }
  
  public TlsNested<A> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(new ClientTLSSettingsBuilder().build()));
  }
  
  public TlsNested<A> editOrNewTlsLike(ClientTLSSettings item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TrafficPolicyFluent that = (TrafficPolicyFluent) o;
    if (!java.util.Objects.equals(connectionPool, that.connectionPool)) return false;
  
    if (!java.util.Objects.equals(loadBalancer, that.loadBalancer)) return false;
  
    if (!java.util.Objects.equals(outlierDetection, that.outlierDetection)) return false;
  
    if (!java.util.Objects.equals(portLevelSettings, that.portLevelSettings)) return false;
  
    if (!java.util.Objects.equals(tls, that.tls)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(connectionPool,  loadBalancer,  outlierDetection,  portLevelSettings,  tls,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectionPool != null) { sb.append("connectionPool:"); sb.append(connectionPool + ","); }
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (outlierDetection != null) { sb.append("outlierDetection:"); sb.append(outlierDetection + ","); }
    if (portLevelSettings != null && !portLevelSettings.isEmpty()) { sb.append("portLevelSettings:"); sb.append(portLevelSettings + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls); }
    sb.append("}");
    return sb.toString();
  }
  public class ConnectionPoolNested<N> extends ConnectionPoolSettingsFluent<ConnectionPoolNested<N>> implements Nested<N>{
    ConnectionPoolNested(ConnectionPoolSettings item) {
      this.builder = new ConnectionPoolSettingsBuilder(this, item);
    }
    ConnectionPoolSettingsBuilder builder;
    
    public N and() {
      return (N) TrafficPolicyFluent.this.withConnectionPool(builder.build());
    }
    
    public N endConnectionPool() {
      return and();
    }
    
  
  }
  public class LoadBalancerNested<N> extends LoadBalancerSettingsFluent<LoadBalancerNested<N>> implements Nested<N>{
    LoadBalancerNested(LoadBalancerSettings item) {
      this.builder = new LoadBalancerSettingsBuilder(this, item);
    }
    LoadBalancerSettingsBuilder builder;
    
    public N and() {
      return (N) TrafficPolicyFluent.this.withLoadBalancer(builder.build());
    }
    
    public N endLoadBalancer() {
      return and();
    }
    
  
  }
  public class OutlierDetectionNested<N> extends OutlierDetectionFluent<OutlierDetectionNested<N>> implements Nested<N>{
    OutlierDetectionNested(OutlierDetection item) {
      this.builder = new OutlierDetectionBuilder(this, item);
    }
    OutlierDetectionBuilder builder;
    
    public N and() {
      return (N) TrafficPolicyFluent.this.withOutlierDetection(builder.build());
    }
    
    public N endOutlierDetection() {
      return and();
    }
    
  
  }
  public class PortLevelSettingsNested<N> extends TrafficPolicyPortTrafficPolicyFluent<PortLevelSettingsNested<N>> implements Nested<N>{
    PortLevelSettingsNested(int index,TrafficPolicyPortTrafficPolicy item) {
      this.index = index;
      this.builder = new TrafficPolicyPortTrafficPolicyBuilder(this, item);
    }
    TrafficPolicyPortTrafficPolicyBuilder builder;
    int index;
    
    public N and() {
      return (N) TrafficPolicyFluent.this.setToPortLevelSettings(index,builder.build());
    }
    
    public N endPortLevelSetting() {
      return and();
    }
    
  
  }
  public class TlsNested<N> extends ClientTLSSettingsFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(ClientTLSSettings item) {
      this.builder = new ClientTLSSettingsBuilder(this, item);
    }
    ClientTLSSettingsBuilder builder;
    
    public N and() {
      return (N) TrafficPolicyFluent.this.withTls(builder.build());
    }
    
    public N endTls() {
      return and();
    }
    
  
  }

}