package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SidecarSpecBuilder extends SidecarSpecFluent<SidecarSpecBuilder> implements VisitableBuilder<SidecarSpec,SidecarSpecBuilder>{
  public SidecarSpecBuilder() {
    this(new SidecarSpec());
  }
  
  public SidecarSpecBuilder(SidecarSpecFluent<?> fluent) {
    this(fluent, new SidecarSpec());
  }
  
  public SidecarSpecBuilder(SidecarSpecFluent<?> fluent,SidecarSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SidecarSpecBuilder(SidecarSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SidecarSpecFluent<?> fluent;
  
  public SidecarSpec build() {
    SidecarSpec buildable = new SidecarSpec(fluent.buildEgress(),fluent.buildIngress(),fluent.buildOutboundTrafficPolicy(),fluent.buildWorkloadSelector());
    return buildable;
  }
  

}