package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceEntrySpecBuilder extends ServiceEntrySpecFluent<ServiceEntrySpecBuilder> implements VisitableBuilder<ServiceEntrySpec,ServiceEntrySpecBuilder>{
  public ServiceEntrySpecBuilder() {
    this(new ServiceEntrySpec());
  }
  
  public ServiceEntrySpecBuilder(ServiceEntrySpecFluent<?> fluent) {
    this(fluent, new ServiceEntrySpec());
  }
  
  public ServiceEntrySpecBuilder(ServiceEntrySpecFluent<?> fluent,ServiceEntrySpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceEntrySpecBuilder(ServiceEntrySpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceEntrySpecFluent<?> fluent;
  
  public ServiceEntrySpec build() {
    ServiceEntrySpec buildable = new ServiceEntrySpec(fluent.getAddresses(),fluent.buildEndpoints(),fluent.getExportTo(),fluent.getHosts(),fluent.getLocation(),fluent.buildPorts(),fluent.getResolution(),fluent.getSubjectAltNames(),fluent.buildWorkloadSelector());
    return buildable;
  }
  

}