package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PortBuilder extends PortFluent<PortBuilder> implements VisitableBuilder<Port,PortBuilder>{
  public PortBuilder() {
    this(new Port());
  }
  
  public PortBuilder(PortFluent<?> fluent) {
    this(fluent, new Port());
  }
  
  public PortBuilder(PortFluent<?> fluent,Port instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PortBuilder(Port instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PortFluent<?> fluent;
  
  public Port build() {
    Port buildable = new Port(fluent.getName(),fluent.getNumber(),fluent.getProtocol(),fluent.getTargetPort());
    return buildable;
  }
  

}