package io.fabric8.istio.api.networking.v1beta1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OutlierDetectionFluent<A extends OutlierDetectionFluent<A>> extends BaseFluent<A>{
  public OutlierDetectionFluent() {
  }
  
  public OutlierDetectionFluent(OutlierDetection instance) {
    this.copyInstance(instance);
  }
  private String baseEjectionTime;
  private Integer consecutive5xxErrors;
  private Integer consecutiveErrors;
  private Integer consecutiveGatewayErrors;
  private Integer consecutiveLocalOriginFailures;
  private String interval;
  private Integer maxEjectionPercent;
  private Integer minHealthPercent;
  private Boolean splitExternalLocalOriginErrors;
  
  protected void copyInstance(OutlierDetection instance) {
    instance = (instance != null ? instance : new OutlierDetection());
  
    if (instance != null) {
        this.withBaseEjectionTime(instance.getBaseEjectionTime());
        this.withConsecutive5xxErrors(instance.getConsecutive5xxErrors());
        this.withConsecutiveErrors(instance.getConsecutiveErrors());
        this.withConsecutiveGatewayErrors(instance.getConsecutiveGatewayErrors());
        this.withConsecutiveLocalOriginFailures(instance.getConsecutiveLocalOriginFailures());
        this.withInterval(instance.getInterval());
        this.withMaxEjectionPercent(instance.getMaxEjectionPercent());
        this.withMinHealthPercent(instance.getMinHealthPercent());
        this.withSplitExternalLocalOriginErrors(instance.getSplitExternalLocalOriginErrors());
        this.withBaseEjectionTime(instance.getBaseEjectionTime());
        this.withConsecutive5xxErrors(instance.getConsecutive5xxErrors());
        this.withConsecutiveErrors(instance.getConsecutiveErrors());
        this.withConsecutiveGatewayErrors(instance.getConsecutiveGatewayErrors());
        this.withConsecutiveLocalOriginFailures(instance.getConsecutiveLocalOriginFailures());
        this.withInterval(instance.getInterval());
        this.withMaxEjectionPercent(instance.getMaxEjectionPercent());
        this.withMinHealthPercent(instance.getMinHealthPercent());
        this.withSplitExternalLocalOriginErrors(instance.getSplitExternalLocalOriginErrors());
      }
  }
  
  public String getBaseEjectionTime() {
    return this.baseEjectionTime;
  }
  
  public A withBaseEjectionTime(String baseEjectionTime) {
    this.baseEjectionTime=baseEjectionTime; return (A) this;
  }
  
  public boolean hasBaseEjectionTime() {
    return this.baseEjectionTime != null;
  }
  
  public Integer getConsecutive5xxErrors() {
    return this.consecutive5xxErrors;
  }
  
  public A withConsecutive5xxErrors(Integer consecutive5xxErrors) {
    this.consecutive5xxErrors=consecutive5xxErrors; return (A) this;
  }
  
  public boolean hasConsecutive5xxErrors() {
    return this.consecutive5xxErrors != null;
  }
  
  public Integer getConsecutiveErrors() {
    return this.consecutiveErrors;
  }
  
  public A withConsecutiveErrors(Integer consecutiveErrors) {
    this.consecutiveErrors=consecutiveErrors; return (A) this;
  }
  
  public boolean hasConsecutiveErrors() {
    return this.consecutiveErrors != null;
  }
  
  public Integer getConsecutiveGatewayErrors() {
    return this.consecutiveGatewayErrors;
  }
  
  public A withConsecutiveGatewayErrors(Integer consecutiveGatewayErrors) {
    this.consecutiveGatewayErrors=consecutiveGatewayErrors; return (A) this;
  }
  
  public boolean hasConsecutiveGatewayErrors() {
    return this.consecutiveGatewayErrors != null;
  }
  
  public Integer getConsecutiveLocalOriginFailures() {
    return this.consecutiveLocalOriginFailures;
  }
  
  public A withConsecutiveLocalOriginFailures(Integer consecutiveLocalOriginFailures) {
    this.consecutiveLocalOriginFailures=consecutiveLocalOriginFailures; return (A) this;
  }
  
  public boolean hasConsecutiveLocalOriginFailures() {
    return this.consecutiveLocalOriginFailures != null;
  }
  
  public String getInterval() {
    return this.interval;
  }
  
  public A withInterval(String interval) {
    this.interval=interval; return (A) this;
  }
  
  public boolean hasInterval() {
    return this.interval != null;
  }
  
  public Integer getMaxEjectionPercent() {
    return this.maxEjectionPercent;
  }
  
  public A withMaxEjectionPercent(Integer maxEjectionPercent) {
    this.maxEjectionPercent=maxEjectionPercent; return (A) this;
  }
  
  public boolean hasMaxEjectionPercent() {
    return this.maxEjectionPercent != null;
  }
  
  public Integer getMinHealthPercent() {
    return this.minHealthPercent;
  }
  
  public A withMinHealthPercent(Integer minHealthPercent) {
    this.minHealthPercent=minHealthPercent; return (A) this;
  }
  
  public boolean hasMinHealthPercent() {
    return this.minHealthPercent != null;
  }
  
  public Boolean getSplitExternalLocalOriginErrors() {
    return this.splitExternalLocalOriginErrors;
  }
  
  public A withSplitExternalLocalOriginErrors(Boolean splitExternalLocalOriginErrors) {
    this.splitExternalLocalOriginErrors=splitExternalLocalOriginErrors; return (A) this;
  }
  
  public boolean hasSplitExternalLocalOriginErrors() {
    return this.splitExternalLocalOriginErrors != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OutlierDetectionFluent that = (OutlierDetectionFluent) o;
    if (!java.util.Objects.equals(baseEjectionTime, that.baseEjectionTime)) return false;
  
    if (!java.util.Objects.equals(consecutive5xxErrors, that.consecutive5xxErrors)) return false;
  
    if (!java.util.Objects.equals(consecutiveErrors, that.consecutiveErrors)) return false;
  
    if (!java.util.Objects.equals(consecutiveGatewayErrors, that.consecutiveGatewayErrors)) return false;
  
    if (!java.util.Objects.equals(consecutiveLocalOriginFailures, that.consecutiveLocalOriginFailures)) return false;
  
    if (!java.util.Objects.equals(interval, that.interval)) return false;
  
    if (!java.util.Objects.equals(maxEjectionPercent, that.maxEjectionPercent)) return false;
  
    if (!java.util.Objects.equals(minHealthPercent, that.minHealthPercent)) return false;
  
    if (!java.util.Objects.equals(splitExternalLocalOriginErrors, that.splitExternalLocalOriginErrors)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(baseEjectionTime,  consecutive5xxErrors,  consecutiveErrors,  consecutiveGatewayErrors,  consecutiveLocalOriginFailures,  interval,  maxEjectionPercent,  minHealthPercent,  splitExternalLocalOriginErrors,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseEjectionTime != null) { sb.append("baseEjectionTime:"); sb.append(baseEjectionTime + ","); }
    if (consecutive5xxErrors != null) { sb.append("consecutive5xxErrors:"); sb.append(consecutive5xxErrors + ","); }
    if (consecutiveErrors != null) { sb.append("consecutiveErrors:"); sb.append(consecutiveErrors + ","); }
    if (consecutiveGatewayErrors != null) { sb.append("consecutiveGatewayErrors:"); sb.append(consecutiveGatewayErrors + ","); }
    if (consecutiveLocalOriginFailures != null) { sb.append("consecutiveLocalOriginFailures:"); sb.append(consecutiveLocalOriginFailures + ","); }
    if (interval != null) { sb.append("interval:"); sb.append(interval + ","); }
    if (maxEjectionPercent != null) { sb.append("maxEjectionPercent:"); sb.append(maxEjectionPercent + ","); }
    if (minHealthPercent != null) { sb.append("minHealthPercent:"); sb.append(minHealthPercent + ","); }
    if (splitExternalLocalOriginErrors != null) { sb.append("splitExternalLocalOriginErrors:"); sb.append(splitExternalLocalOriginErrors); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withSplitExternalLocalOriginErrors() {
    return withSplitExternalLocalOriginErrors(true);
  }
  

}