package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class LocalityLoadBalancerSettingFluent<A extends LocalityLoadBalancerSettingFluent<A>> extends BaseFluent<A>{
  public LocalityLoadBalancerSettingFluent() {
  }
  
  public LocalityLoadBalancerSettingFluent(LocalityLoadBalancerSetting instance) {
    this.copyInstance(instance);
  }
  private ArrayList<LocalityLoadBalancerSettingDistributeBuilder> distribute = new ArrayList<LocalityLoadBalancerSettingDistributeBuilder>();
  private Boolean enabled;
  private ArrayList<LocalityLoadBalancerSettingFailoverBuilder> failover = new ArrayList<LocalityLoadBalancerSettingFailoverBuilder>();
  private List<String> failoverPriority = new ArrayList<String>();
  
  protected void copyInstance(LocalityLoadBalancerSetting instance) {
    instance = (instance != null ? instance : new LocalityLoadBalancerSetting());
  
    if (instance != null) {
        this.withDistribute(instance.getDistribute());
        this.withEnabled(instance.getEnabled());
        this.withFailover(instance.getFailover());
        this.withFailoverPriority(instance.getFailoverPriority());
        this.withDistribute(instance.getDistribute());
        this.withEnabled(instance.getEnabled());
        this.withFailover(instance.getFailover());
        this.withFailoverPriority(instance.getFailoverPriority());
      }
  }
  
  public A addToDistribute(int index,LocalityLoadBalancerSettingDistribute item) {
    if (this.distribute == null) {this.distribute = new ArrayList<LocalityLoadBalancerSettingDistributeBuilder>();}
    LocalityLoadBalancerSettingDistributeBuilder builder = new LocalityLoadBalancerSettingDistributeBuilder(item);
    if (index < 0 || index >= distribute.size()) { _visitables.get("distribute").add(builder); distribute.add(builder); } else { _visitables.get("distribute").add(index, builder); distribute.add(index, builder);}
    return (A)this;
  }
  
  public A setToDistribute(int index,LocalityLoadBalancerSettingDistribute item) {
    if (this.distribute == null) {this.distribute = new ArrayList<LocalityLoadBalancerSettingDistributeBuilder>();}
    LocalityLoadBalancerSettingDistributeBuilder builder = new LocalityLoadBalancerSettingDistributeBuilder(item);
    if (index < 0 || index >= distribute.size()) { _visitables.get("distribute").add(builder); distribute.add(builder); } else { _visitables.get("distribute").set(index, builder); distribute.set(index, builder);}
    return (A)this;
  }
  
  public A addToDistribute(io.fabric8.istio.api.networking.v1beta1.LocalityLoadBalancerSettingDistribute... items) {
    if (this.distribute == null) {this.distribute = new ArrayList<LocalityLoadBalancerSettingDistributeBuilder>();}
    for (LocalityLoadBalancerSettingDistribute item : items) {LocalityLoadBalancerSettingDistributeBuilder builder = new LocalityLoadBalancerSettingDistributeBuilder(item);_visitables.get("distribute").add(builder);this.distribute.add(builder);} return (A)this;
  }
  
  public A addAllToDistribute(Collection<LocalityLoadBalancerSettingDistribute> items) {
    if (this.distribute == null) {this.distribute = new ArrayList<LocalityLoadBalancerSettingDistributeBuilder>();}
    for (LocalityLoadBalancerSettingDistribute item : items) {LocalityLoadBalancerSettingDistributeBuilder builder = new LocalityLoadBalancerSettingDistributeBuilder(item);_visitables.get("distribute").add(builder);this.distribute.add(builder);} return (A)this;
  }
  
  public A removeFromDistribute(io.fabric8.istio.api.networking.v1beta1.LocalityLoadBalancerSettingDistribute... items) {
    if (this.distribute == null) return (A)this;
    for (LocalityLoadBalancerSettingDistribute item : items) {LocalityLoadBalancerSettingDistributeBuilder builder = new LocalityLoadBalancerSettingDistributeBuilder(item);_visitables.get("distribute").remove(builder); this.distribute.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDistribute(Collection<LocalityLoadBalancerSettingDistribute> items) {
    if (this.distribute == null) return (A)this;
    for (LocalityLoadBalancerSettingDistribute item : items) {LocalityLoadBalancerSettingDistributeBuilder builder = new LocalityLoadBalancerSettingDistributeBuilder(item);_visitables.get("distribute").remove(builder); this.distribute.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDistribute(Predicate<LocalityLoadBalancerSettingDistributeBuilder> predicate) {
    if (distribute == null) return (A) this;
    final Iterator<LocalityLoadBalancerSettingDistributeBuilder> each = distribute.iterator();
    final List visitables = _visitables.get("distribute");
    while (each.hasNext()) {
      LocalityLoadBalancerSettingDistributeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LocalityLoadBalancerSettingDistribute> buildDistribute() {
    return distribute != null ? build(distribute) : null;
  }
  
  public LocalityLoadBalancerSettingDistribute buildDistribute(int index) {
    return this.distribute.get(index).build();
  }
  
  public LocalityLoadBalancerSettingDistribute buildFirstDistribute() {
    return this.distribute.get(0).build();
  }
  
  public LocalityLoadBalancerSettingDistribute buildLastDistribute() {
    return this.distribute.get(distribute.size() - 1).build();
  }
  
  public LocalityLoadBalancerSettingDistribute buildMatchingDistribute(Predicate<LocalityLoadBalancerSettingDistributeBuilder> predicate) {
    for (LocalityLoadBalancerSettingDistributeBuilder item: distribute) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingDistribute(Predicate<LocalityLoadBalancerSettingDistributeBuilder> predicate) {
    for (LocalityLoadBalancerSettingDistributeBuilder item: distribute) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withDistribute(List<LocalityLoadBalancerSettingDistribute> distribute) {
    if (this.distribute != null) { _visitables.get("distribute").clear();}
    if (distribute != null) {this.distribute = new ArrayList(); for (LocalityLoadBalancerSettingDistribute item : distribute){this.addToDistribute(item);}} else { this.distribute = null;} return (A) this;
  }
  
  public A withDistribute(io.fabric8.istio.api.networking.v1beta1.LocalityLoadBalancerSettingDistribute... distribute) {
    if (this.distribute != null) {this.distribute.clear(); _visitables.remove("distribute"); }
    if (distribute != null) {for (LocalityLoadBalancerSettingDistribute item :distribute){ this.addToDistribute(item);}} return (A) this;
  }
  
  public boolean hasDistribute() {
    return distribute != null && !distribute.isEmpty();
  }
  
  public DistributeNested<A> addNewDistribute() {
    return new DistributeNested(-1, null);
  }
  
  public DistributeNested<A> addNewDistributeLike(LocalityLoadBalancerSettingDistribute item) {
    return new DistributeNested(-1, item);
  }
  
  public DistributeNested<A> setNewDistributeLike(int index,LocalityLoadBalancerSettingDistribute item) {
    return new DistributeNested(index, item);
  }
  
  public DistributeNested<A> editDistribute(int index) {
    if (distribute.size() <= index) throw new RuntimeException("Can't edit distribute. Index exceeds size.");
    return setNewDistributeLike(index, buildDistribute(index));
  }
  
  public DistributeNested<A> editFirstDistribute() {
    if (distribute.size() == 0) throw new RuntimeException("Can't edit first distribute. The list is empty.");
    return setNewDistributeLike(0, buildDistribute(0));
  }
  
  public DistributeNested<A> editLastDistribute() {
    int index = distribute.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last distribute. The list is empty.");
    return setNewDistributeLike(index, buildDistribute(index));
  }
  
  public DistributeNested<A> editMatchingDistribute(Predicate<LocalityLoadBalancerSettingDistributeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<distribute.size();i++) { 
    if (predicate.test(distribute.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching distribute. No match found.");
    return setNewDistributeLike(index, buildDistribute(index));
  }
  
  public Boolean getEnabled() {
    return this.enabled;
  }
  
  public A withEnabled(Boolean enabled) {
    this.enabled=enabled; return (A) this;
  }
  
  public boolean hasEnabled() {
    return this.enabled != null;
  }
  
  public A addToFailover(int index,LocalityLoadBalancerSettingFailover item) {
    if (this.failover == null) {this.failover = new ArrayList<LocalityLoadBalancerSettingFailoverBuilder>();}
    LocalityLoadBalancerSettingFailoverBuilder builder = new LocalityLoadBalancerSettingFailoverBuilder(item);
    if (index < 0 || index >= failover.size()) { _visitables.get("failover").add(builder); failover.add(builder); } else { _visitables.get("failover").add(index, builder); failover.add(index, builder);}
    return (A)this;
  }
  
  public A setToFailover(int index,LocalityLoadBalancerSettingFailover item) {
    if (this.failover == null) {this.failover = new ArrayList<LocalityLoadBalancerSettingFailoverBuilder>();}
    LocalityLoadBalancerSettingFailoverBuilder builder = new LocalityLoadBalancerSettingFailoverBuilder(item);
    if (index < 0 || index >= failover.size()) { _visitables.get("failover").add(builder); failover.add(builder); } else { _visitables.get("failover").set(index, builder); failover.set(index, builder);}
    return (A)this;
  }
  
  public A addToFailover(io.fabric8.istio.api.networking.v1beta1.LocalityLoadBalancerSettingFailover... items) {
    if (this.failover == null) {this.failover = new ArrayList<LocalityLoadBalancerSettingFailoverBuilder>();}
    for (LocalityLoadBalancerSettingFailover item : items) {LocalityLoadBalancerSettingFailoverBuilder builder = new LocalityLoadBalancerSettingFailoverBuilder(item);_visitables.get("failover").add(builder);this.failover.add(builder);} return (A)this;
  }
  
  public A addAllToFailover(Collection<LocalityLoadBalancerSettingFailover> items) {
    if (this.failover == null) {this.failover = new ArrayList<LocalityLoadBalancerSettingFailoverBuilder>();}
    for (LocalityLoadBalancerSettingFailover item : items) {LocalityLoadBalancerSettingFailoverBuilder builder = new LocalityLoadBalancerSettingFailoverBuilder(item);_visitables.get("failover").add(builder);this.failover.add(builder);} return (A)this;
  }
  
  public A removeFromFailover(io.fabric8.istio.api.networking.v1beta1.LocalityLoadBalancerSettingFailover... items) {
    if (this.failover == null) return (A)this;
    for (LocalityLoadBalancerSettingFailover item : items) {LocalityLoadBalancerSettingFailoverBuilder builder = new LocalityLoadBalancerSettingFailoverBuilder(item);_visitables.get("failover").remove(builder); this.failover.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFailover(Collection<LocalityLoadBalancerSettingFailover> items) {
    if (this.failover == null) return (A)this;
    for (LocalityLoadBalancerSettingFailover item : items) {LocalityLoadBalancerSettingFailoverBuilder builder = new LocalityLoadBalancerSettingFailoverBuilder(item);_visitables.get("failover").remove(builder); this.failover.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFailover(Predicate<LocalityLoadBalancerSettingFailoverBuilder> predicate) {
    if (failover == null) return (A) this;
    final Iterator<LocalityLoadBalancerSettingFailoverBuilder> each = failover.iterator();
    final List visitables = _visitables.get("failover");
    while (each.hasNext()) {
      LocalityLoadBalancerSettingFailoverBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LocalityLoadBalancerSettingFailover> buildFailover() {
    return failover != null ? build(failover) : null;
  }
  
  public LocalityLoadBalancerSettingFailover buildFailover(int index) {
    return this.failover.get(index).build();
  }
  
  public LocalityLoadBalancerSettingFailover buildFirstFailover() {
    return this.failover.get(0).build();
  }
  
  public LocalityLoadBalancerSettingFailover buildLastFailover() {
    return this.failover.get(failover.size() - 1).build();
  }
  
  public LocalityLoadBalancerSettingFailover buildMatchingFailover(Predicate<LocalityLoadBalancerSettingFailoverBuilder> predicate) {
    for (LocalityLoadBalancerSettingFailoverBuilder item: failover) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingFailover(Predicate<LocalityLoadBalancerSettingFailoverBuilder> predicate) {
    for (LocalityLoadBalancerSettingFailoverBuilder item: failover) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withFailover(List<LocalityLoadBalancerSettingFailover> failover) {
    if (this.failover != null) { _visitables.get("failover").clear();}
    if (failover != null) {this.failover = new ArrayList(); for (LocalityLoadBalancerSettingFailover item : failover){this.addToFailover(item);}} else { this.failover = null;} return (A) this;
  }
  
  public A withFailover(io.fabric8.istio.api.networking.v1beta1.LocalityLoadBalancerSettingFailover... failover) {
    if (this.failover != null) {this.failover.clear(); _visitables.remove("failover"); }
    if (failover != null) {for (LocalityLoadBalancerSettingFailover item :failover){ this.addToFailover(item);}} return (A) this;
  }
  
  public boolean hasFailover() {
    return failover != null && !failover.isEmpty();
  }
  
  public A addNewFailover(String from,String to) {
    return (A)addToFailover(new LocalityLoadBalancerSettingFailover(from, to));
  }
  
  public FailoverNested<A> addNewFailover() {
    return new FailoverNested(-1, null);
  }
  
  public FailoverNested<A> addNewFailoverLike(LocalityLoadBalancerSettingFailover item) {
    return new FailoverNested(-1, item);
  }
  
  public FailoverNested<A> setNewFailoverLike(int index,LocalityLoadBalancerSettingFailover item) {
    return new FailoverNested(index, item);
  }
  
  public FailoverNested<A> editFailover(int index) {
    if (failover.size() <= index) throw new RuntimeException("Can't edit failover. Index exceeds size.");
    return setNewFailoverLike(index, buildFailover(index));
  }
  
  public FailoverNested<A> editFirstFailover() {
    if (failover.size() == 0) throw new RuntimeException("Can't edit first failover. The list is empty.");
    return setNewFailoverLike(0, buildFailover(0));
  }
  
  public FailoverNested<A> editLastFailover() {
    int index = failover.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last failover. The list is empty.");
    return setNewFailoverLike(index, buildFailover(index));
  }
  
  public FailoverNested<A> editMatchingFailover(Predicate<LocalityLoadBalancerSettingFailoverBuilder> predicate) {
    int index = -1;
    for (int i=0;i<failover.size();i++) { 
    if (predicate.test(failover.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching failover. No match found.");
    return setNewFailoverLike(index, buildFailover(index));
  }
  
  public A addToFailoverPriority(int index,String item) {
    if (this.failoverPriority == null) {this.failoverPriority = new ArrayList<String>();}
    this.failoverPriority.add(index, item);
    return (A)this;
  }
  
  public A setToFailoverPriority(int index,String item) {
    if (this.failoverPriority == null) {this.failoverPriority = new ArrayList<String>();}
    this.failoverPriority.set(index, item); return (A)this;
  }
  
  public A addToFailoverPriority(java.lang.String... items) {
    if (this.failoverPriority == null) {this.failoverPriority = new ArrayList<String>();}
    for (String item : items) {this.failoverPriority.add(item);} return (A)this;
  }
  
  public A addAllToFailoverPriority(Collection<String> items) {
    if (this.failoverPriority == null) {this.failoverPriority = new ArrayList<String>();}
    for (String item : items) {this.failoverPriority.add(item);} return (A)this;
  }
  
  public A removeFromFailoverPriority(java.lang.String... items) {
    if (this.failoverPriority == null) return (A)this;
    for (String item : items) { this.failoverPriority.remove(item);} return (A)this;
  }
  
  public A removeAllFromFailoverPriority(Collection<String> items) {
    if (this.failoverPriority == null) return (A)this;
    for (String item : items) { this.failoverPriority.remove(item);} return (A)this;
  }
  
  public List<String> getFailoverPriority() {
    return this.failoverPriority;
  }
  
  public String getFailoverPriority(int index) {
    return this.failoverPriority.get(index);
  }
  
  public String getFirstFailoverPriority() {
    return this.failoverPriority.get(0);
  }
  
  public String getLastFailoverPriority() {
    return this.failoverPriority.get(failoverPriority.size() - 1);
  }
  
  public String getMatchingFailoverPriority(Predicate<String> predicate) {
    for (String item: failoverPriority) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingFailoverPriority(Predicate<String> predicate) {
    for (String item: failoverPriority) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withFailoverPriority(List<String> failoverPriority) {
    if (failoverPriority != null) {this.failoverPriority = new ArrayList(); for (String item : failoverPriority){this.addToFailoverPriority(item);}} else { this.failoverPriority = null;} return (A) this;
  }
  
  public A withFailoverPriority(java.lang.String... failoverPriority) {
    if (this.failoverPriority != null) {this.failoverPriority.clear(); _visitables.remove("failoverPriority"); }
    if (failoverPriority != null) {for (String item :failoverPriority){ this.addToFailoverPriority(item);}} return (A) this;
  }
  
  public boolean hasFailoverPriority() {
    return failoverPriority != null && !failoverPriority.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LocalityLoadBalancerSettingFluent that = (LocalityLoadBalancerSettingFluent) o;
    if (!java.util.Objects.equals(distribute, that.distribute)) return false;
  
    if (!java.util.Objects.equals(enabled, that.enabled)) return false;
  
    if (!java.util.Objects.equals(failover, that.failover)) return false;
  
    if (!java.util.Objects.equals(failoverPriority, that.failoverPriority)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(distribute,  enabled,  failover,  failoverPriority,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (distribute != null && !distribute.isEmpty()) { sb.append("distribute:"); sb.append(distribute + ","); }
    if (enabled != null) { sb.append("enabled:"); sb.append(enabled + ","); }
    if (failover != null && !failover.isEmpty()) { sb.append("failover:"); sb.append(failover + ","); }
    if (failoverPriority != null && !failoverPriority.isEmpty()) { sb.append("failoverPriority:"); sb.append(failoverPriority); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEnabled() {
    return withEnabled(true);
  }
  public class DistributeNested<N> extends LocalityLoadBalancerSettingDistributeFluent<DistributeNested<N>> implements Nested<N>{
    DistributeNested(int index,LocalityLoadBalancerSettingDistribute item) {
      this.index = index;
      this.builder = new LocalityLoadBalancerSettingDistributeBuilder(this, item);
    }
    LocalityLoadBalancerSettingDistributeBuilder builder;
    int index;
    
    public N and() {
      return (N) LocalityLoadBalancerSettingFluent.this.setToDistribute(index,builder.build());
    }
    
    public N endDistribute() {
      return and();
    }
    
  
  }
  public class FailoverNested<N> extends LocalityLoadBalancerSettingFailoverFluent<FailoverNested<N>> implements Nested<N>{
    FailoverNested(int index,LocalityLoadBalancerSettingFailover item) {
      this.index = index;
      this.builder = new LocalityLoadBalancerSettingFailoverBuilder(this, item);
    }
    LocalityLoadBalancerSettingFailoverBuilder builder;
    int index;
    
    public N and() {
      return (N) LocalityLoadBalancerSettingFluent.this.setToFailover(index,builder.build());
    }
    
    public N endFailover() {
      return and();
    }
    
  
  }

}