package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPFaultInjectionAbortFluent<A extends HTTPFaultInjectionAbortFluent<A>> extends BaseFluent<A>{
  public HTTPFaultInjectionAbortFluent() {
  }
  
  public HTTPFaultInjectionAbortFluent(HTTPFaultInjectionAbort instance) {
    this.copyInstance(instance);
  }
  private VisitableBuilder<? extends IsHTTPFaultInjectionAbortErrorType,?> errorType;
  private PercentBuilder percentage;
  
  protected void copyInstance(HTTPFaultInjectionAbort instance) {
    instance = (instance != null ? instance : new HTTPFaultInjectionAbort());
  
    if (instance != null) {
        this.withErrorType(instance.getErrorType());
        this.withPercentage(instance.getPercentage());
        this.withErrorType(instance.getErrorType());
        this.withPercentage(instance.getPercentage());
      }
  }
  
  public IsHTTPFaultInjectionAbortErrorType buildErrorType() {
    return this.errorType!=null?this.errorType.build():null;
  }
  
  public A withErrorType(IsHTTPFaultInjectionAbortErrorType errorType) {
    if (errorType==null){ this.errorType = null; _visitables.remove("errorType"); return (A) this;}
    VisitableBuilder<? extends IsHTTPFaultInjectionAbortErrorType,?> builder = builder(errorType); _visitables.get("errorType").clear();_visitables.get("errorType").add(builder);this.errorType = builder;
    return (A) this;
  }
  
  public boolean hasErrorType() {
    return this.errorType != null;
  }
  
  public HTTPFaultInjectionAbortHttpStatusErrorTypeNested<A> withNewHTTPFaultInjectionAbortHttpStatusErrorType() {
    return new HTTPFaultInjectionAbortHttpStatusErrorTypeNested(null);
  }
  
  public HTTPFaultInjectionAbortHttpStatusErrorTypeNested<A> withNewHTTPFaultInjectionAbortHttpStatusErrorTypeLike(HTTPFaultInjectionAbortHttpStatus item) {
    return new HTTPFaultInjectionAbortHttpStatusErrorTypeNested(item);
  }
  
  public A withNewHTTPFaultInjectionAbortHttpStatusErrorType(Integer httpStatus) {
    return (A)withErrorType(new HTTPFaultInjectionAbortHttpStatus(httpStatus));
  }
  
  public HTTPFaultInjectionAbortGrpcStatusErrorTypeNested<A> withNewHTTPFaultInjectionAbortGrpcStatusErrorType() {
    return new HTTPFaultInjectionAbortGrpcStatusErrorTypeNested(null);
  }
  
  public HTTPFaultInjectionAbortGrpcStatusErrorTypeNested<A> withNewHTTPFaultInjectionAbortGrpcStatusErrorTypeLike(HTTPFaultInjectionAbortGrpcStatus item) {
    return new HTTPFaultInjectionAbortGrpcStatusErrorTypeNested(item);
  }
  
  public A withNewHTTPFaultInjectionAbortGrpcStatusErrorType(String grpcStatus) {
    return (A)withErrorType(new HTTPFaultInjectionAbortGrpcStatus(grpcStatus));
  }
  
  public HTTPFaultInjectionAbortHttp2ErrorTypeNested<A> withNewHTTPFaultInjectionAbortHttp2ErrorType() {
    return new HTTPFaultInjectionAbortHttp2ErrorTypeNested(null);
  }
  
  public HTTPFaultInjectionAbortHttp2ErrorTypeNested<A> withNewHTTPFaultInjectionAbortHttp2ErrorTypeLike(HTTPFaultInjectionAbortHttp2Error item) {
    return new HTTPFaultInjectionAbortHttp2ErrorTypeNested(item);
  }
  
  public A withNewHTTPFaultInjectionAbortHttp2ErrorType(String http2Error) {
    return (A)withErrorType(new HTTPFaultInjectionAbortHttp2Error(http2Error));
  }
  
  public Percent buildPercentage() {
    return this.percentage!=null ?this.percentage.build():null;
  }
  
  public A withPercentage(Percent percentage) {
    _visitables.get("percentage").remove(this.percentage);
    if (percentage!=null){ this.percentage= new PercentBuilder(percentage); _visitables.get("percentage").add(this.percentage);} else { this.percentage = null; _visitables.get("percentage").remove(this.percentage); } return (A) this;
  }
  
  public boolean hasPercentage() {
    return this.percentage != null;
  }
  
  public A withNewPercentage(Double value) {
    return (A)withPercentage(new Percent(value));
  }
  
  public PercentageNested<A> withNewPercentage() {
    return new PercentageNested(null);
  }
  
  public PercentageNested<A> withNewPercentageLike(Percent item) {
    return new PercentageNested(item);
  }
  
  public PercentageNested<A> editPercentage() {
    return withNewPercentageLike(java.util.Optional.ofNullable(buildPercentage()).orElse(null));
  }
  
  public PercentageNested<A> editOrNewPercentage() {
    return withNewPercentageLike(java.util.Optional.ofNullable(buildPercentage()).orElse(new PercentBuilder().build()));
  }
  
  public PercentageNested<A> editOrNewPercentageLike(Percent item) {
    return withNewPercentageLike(java.util.Optional.ofNullable(buildPercentage()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPFaultInjectionAbortFluent that = (HTTPFaultInjectionAbortFluent) o;
    if (!java.util.Objects.equals(errorType, that.errorType)) return false;
  
    if (!java.util.Objects.equals(percentage, that.percentage)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(errorType,  percentage,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (errorType != null) { sb.append("errorType:"); sb.append(errorType + ","); }
    if (percentage != null) { sb.append("percentage:"); sb.append(percentage); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.istio.api.networking.v1beta1."+"HTTPFaultInjectionAbortHttpStatus": return (VisitableBuilder<T, ?>)new HTTPFaultInjectionAbortHttpStatusBuilder((HTTPFaultInjectionAbortHttpStatus) item);
    case "io.fabric8.istio.api.networking.v1beta1."+"HTTPFaultInjectionAbortGrpcStatus": return (VisitableBuilder<T, ?>)new HTTPFaultInjectionAbortGrpcStatusBuilder((HTTPFaultInjectionAbortGrpcStatus) item);
    case "io.fabric8.istio.api.networking.v1beta1."+"HTTPFaultInjectionAbortHttp2Error": return (VisitableBuilder<T, ?>)new HTTPFaultInjectionAbortHttp2ErrorBuilder((HTTPFaultInjectionAbortHttp2Error) item);
    }
   return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class HTTPFaultInjectionAbortHttpStatusErrorTypeNested<N> extends HTTPFaultInjectionAbortHttpStatusFluent<HTTPFaultInjectionAbortHttpStatusErrorTypeNested<N>> implements Nested<N>{
    HTTPFaultInjectionAbortHttpStatusErrorTypeNested(HTTPFaultInjectionAbortHttpStatus item) {
      this.builder = new HTTPFaultInjectionAbortHttpStatusBuilder(this, item);
    }
    HTTPFaultInjectionAbortHttpStatusBuilder builder;
    
    public N and() {
      return (N) HTTPFaultInjectionAbortFluent.this.withErrorType(builder.build());
    }
    
    public N endHTTPFaultInjectionAbortHttpStatusErrorType() {
      return and();
    }
    
  
  }
  public class HTTPFaultInjectionAbortGrpcStatusErrorTypeNested<N> extends HTTPFaultInjectionAbortGrpcStatusFluent<HTTPFaultInjectionAbortGrpcStatusErrorTypeNested<N>> implements Nested<N>{
    HTTPFaultInjectionAbortGrpcStatusErrorTypeNested(HTTPFaultInjectionAbortGrpcStatus item) {
      this.builder = new HTTPFaultInjectionAbortGrpcStatusBuilder(this, item);
    }
    HTTPFaultInjectionAbortGrpcStatusBuilder builder;
    
    public N and() {
      return (N) HTTPFaultInjectionAbortFluent.this.withErrorType(builder.build());
    }
    
    public N endHTTPFaultInjectionAbortGrpcStatusErrorType() {
      return and();
    }
    
  
  }
  public class HTTPFaultInjectionAbortHttp2ErrorTypeNested<N> extends HTTPFaultInjectionAbortHttp2ErrorFluent<HTTPFaultInjectionAbortHttp2ErrorTypeNested<N>> implements Nested<N>{
    HTTPFaultInjectionAbortHttp2ErrorTypeNested(HTTPFaultInjectionAbortHttp2Error item) {
      this.builder = new HTTPFaultInjectionAbortHttp2ErrorBuilder(this, item);
    }
    HTTPFaultInjectionAbortHttp2ErrorBuilder builder;
    
    public N and() {
      return (N) HTTPFaultInjectionAbortFluent.this.withErrorType(builder.build());
    }
    
    public N endHTTPFaultInjectionAbortHttp2ErrorType() {
      return and();
    }
    
  
  }
  public class PercentageNested<N> extends PercentFluent<PercentageNested<N>> implements Nested<N>{
    PercentageNested(Percent item) {
      this.builder = new PercentBuilder(this, item);
    }
    PercentBuilder builder;
    
    public N and() {
      return (N) HTTPFaultInjectionAbortFluent.this.withPercentage(builder.build());
    }
    
    public N endPercentage() {
      return and();
    }
    
  
  }

}