package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DestinationBuilder extends DestinationFluent<DestinationBuilder> implements VisitableBuilder<Destination,DestinationBuilder>{
  public DestinationBuilder() {
    this(new Destination());
  }
  
  public DestinationBuilder(DestinationFluent<?> fluent) {
    this(fluent, new Destination());
  }
  
  public DestinationBuilder(DestinationFluent<?> fluent,Destination instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DestinationBuilder(Destination instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DestinationFluent<?> fluent;
  
  public Destination build() {
    Destination buildable = new Destination(fluent.getHost(),fluent.buildPort(),fluent.getSubset());
    return buildable;
  }
  

}