package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClientTLSSettingsBuilder extends ClientTLSSettingsFluent<ClientTLSSettingsBuilder> implements VisitableBuilder<ClientTLSSettings,ClientTLSSettingsBuilder>{
  public ClientTLSSettingsBuilder() {
    this(new ClientTLSSettings());
  }
  
  public ClientTLSSettingsBuilder(ClientTLSSettingsFluent<?> fluent) {
    this(fluent, new ClientTLSSettings());
  }
  
  public ClientTLSSettingsBuilder(ClientTLSSettingsFluent<?> fluent,ClientTLSSettings instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClientTLSSettingsBuilder(ClientTLSSettings instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClientTLSSettingsFluent<?> fluent;
  
  public ClientTLSSettings build() {
    ClientTLSSettings buildable = new ClientTLSSettings(fluent.getCaCertificates(),fluent.getClientCertificate(),fluent.getCredentialName(),fluent.getInsecureSkipVerify(),fluent.getMode(),fluent.getPrivateKey(),fluent.getSni(),fluent.getSubjectAltNames());
    return buildable;
  }
  

}