/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.istio.api.networking.v1beta1.Port;
import io.fabric8.istio.api.networking.v1beta1.PortBuilder;
import io.fabric8.istio.api.networking.v1beta1.PortFluent;
import io.fabric8.istio.api.networking.v1beta1.Server;
import io.fabric8.istio.api.networking.v1beta1.ServerTLSSettings;
import io.fabric8.istio.api.networking.v1beta1.ServerTLSSettingsBuilder;
import io.fabric8.istio.api.networking.v1beta1.ServerTLSSettingsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ServerFluent<A extends ServerFluent<A>>
extends BaseFluent<A> {
    private String bind;
    private String defaultEndpoint;
    private List<String> hosts = new ArrayList<String>();
    private String name;
    private PortBuilder port;
    private ServerTLSSettingsBuilder tls;

    public ServerFluent() {
    }

    public ServerFluent(Server instance) {
        Server server = instance = instance != null ? instance : new Server();
        if (instance != null) {
            this.withBind(instance.getBind());
            this.withDefaultEndpoint(instance.getDefaultEndpoint());
            this.withHosts(instance.getHosts());
            this.withName(instance.getName());
            this.withPort(instance.getPort());
            this.withTls(instance.getTls());
            this.withBind(instance.getBind());
            this.withDefaultEndpoint(instance.getDefaultEndpoint());
            this.withHosts(instance.getHosts());
            this.withName(instance.getName());
            this.withPort(instance.getPort());
            this.withTls(instance.getTls());
        }
    }

    public String getBind() {
        return this.bind;
    }

    public A withBind(String bind) {
        this.bind = bind;
        return (A)((Object)this);
    }

    public boolean hasBind() {
        return this.bind != null;
    }

    public String getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public A withDefaultEndpoint(String defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
        return (A)((Object)this);
    }

    public boolean hasDefaultEndpoint() {
        return this.defaultEndpoint != null;
    }

    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)((Object)this);
    }

    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)((Object)this);
    }

    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromHosts(String ... items) {
        if (this.hosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHosts(Collection<String> items) {
        if (this.hosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getHost(int index) {
        return this.hosts.get(index);
    }

    public String getFirstHost() {
        return this.hosts.get(0);
    }

    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHosts(List<String> hosts) {
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)((Object)this);
    }

    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
            this._visitables.remove((Object)"hosts");
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Port buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    public A withPort(Port port) {
        this._visitables.get((Object)"port").remove((Object)this.port);
        if (port != null) {
            this.port = new PortBuilder(port);
            this._visitables.get((Object)"port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get((Object)"port").remove((Object)this.port);
        }
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(String name, Integer number, String protocol, Integer targetPort) {
        return this.withPort(new Port(name, number, protocol, targetPort));
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public PortNested<A> withNewPortLike(Port item) {
        return new PortNested(item);
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new PortBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(Port item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    public ServerTLSSettings buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    public A withTls(ServerTLSSettings tls) {
        this._visitables.get((Object)"tls").remove((Object)this.tls);
        if (tls != null) {
            this.tls = new ServerTLSSettingsBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        } else {
            this.tls = null;
            this._visitables.get((Object)"tls").remove((Object)this.tls);
        }
        return (A)((Object)this);
    }

    public boolean hasTls() {
        return this.tls != null;
    }

    public TlsNested<A> withNewTls() {
        return new TlsNested(null);
    }

    public TlsNested<A> withNewTlsLike(ServerTLSSettings item) {
        return new TlsNested(item);
    }

    public TlsNested<A> editTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(null));
    }

    public TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(new ServerTLSSettingsBuilder().build()));
    }

    public TlsNested<A> editOrNewTlsLike(ServerTLSSettings item) {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerFluent that = (ServerFluent)((Object)o);
        if (!Objects.equals(this.bind, that.bind)) {
            return false;
        }
        if (!Objects.equals(this.defaultEndpoint, that.defaultEndpoint)) {
            return false;
        }
        if (!Objects.equals(this.hosts, that.hosts)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.port, (Object)that.port)) {
            return false;
        }
        return Objects.equals((Object)this.tls, (Object)that.tls);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bind, this.defaultEndpoint, this.hosts, this.name, this.port, this.tls, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bind != null) {
            sb.append("bind:");
            sb.append(this.bind + ",");
        }
        if (this.defaultEndpoint != null) {
            sb.append("defaultEndpoint:");
            sb.append(this.defaultEndpoint + ",");
        }
        if (this.hosts != null && !this.hosts.isEmpty()) {
            sb.append("hosts:");
            sb.append(this.hosts + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append((Object)((Object)this.port) + ",");
        }
        if (this.tls != null) {
            sb.append("tls:");
            sb.append((Object)this.tls);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TlsNested<N>
    extends ServerTLSSettingsFluent<TlsNested<N>>
    implements Nested<N> {
        ServerTLSSettingsBuilder builder;

        TlsNested(ServerTLSSettings item) {
            this.builder = new ServerTLSSettingsBuilder(this, item);
        }

        public N and() {
            return (N)ServerFluent.this.withTls(this.builder.build());
        }

        public N endTls() {
            return this.and();
        }
    }

    public class PortNested<N>
    extends PortFluent<PortNested<N>>
    implements Nested<N> {
        PortBuilder builder;

        PortNested(Port item) {
            this.builder = new PortBuilder(this, item);
        }

        public N and() {
            return (N)ServerFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

