/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.istio.api.networking.v1beta1.Destination;
import io.fabric8.istio.api.networking.v1beta1.PortSelector;
import io.fabric8.istio.api.networking.v1beta1.PortSelectorBuilder;
import io.fabric8.istio.api.networking.v1beta1.PortSelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class DestinationFluent<A extends DestinationFluent<A>>
extends BaseFluent<A> {
    private String host;
    private PortSelectorBuilder port;
    private String subset;

    public DestinationFluent() {
    }

    public DestinationFluent(Destination instance) {
        Destination destination = instance = instance != null ? instance : new Destination();
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withPort(instance.getPort());
            this.withSubset(instance.getSubset());
            this.withHost(instance.getHost());
            this.withPort(instance.getPort());
            this.withSubset(instance.getSubset());
        }
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public PortSelector buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    public A withPort(PortSelector port) {
        this._visitables.get((Object)"port").remove((Object)this.port);
        if (port != null) {
            this.port = new PortSelectorBuilder(port);
            this._visitables.get((Object)"port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get((Object)"port").remove((Object)this.port);
        }
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(Integer number) {
        return this.withPort(new PortSelector(number));
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public PortNested<A> withNewPortLike(PortSelector item) {
        return new PortNested(item);
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new PortSelectorBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(PortSelector item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    public String getSubset() {
        return this.subset;
    }

    public A withSubset(String subset) {
        this.subset = subset;
        return (A)((Object)this);
    }

    public boolean hasSubset() {
        return this.subset != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DestinationFluent that = (DestinationFluent)((Object)o);
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals((Object)this.port, (Object)that.port)) {
            return false;
        }
        return Objects.equals(this.subset, that.subset);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.port, this.subset, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append((Object)((Object)this.port) + ",");
        }
        if (this.subset != null) {
            sb.append("subset:");
            sb.append(this.subset);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortNested<N>
    extends PortSelectorFluent<PortNested<N>>
    implements Nested<N> {
        PortSelectorBuilder builder;

        PortNested(PortSelector item) {
            this.builder = new PortSelectorBuilder(this, item);
        }

        public N and() {
            return (N)DestinationFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

