/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.IstioEgressListener;
import io.fabric8.istio.api.networking.v1alpha3.IstioEgressListenerBuilder;
import io.fabric8.istio.api.networking.v1alpha3.IstioEgressListenerFluent;
import io.fabric8.istio.api.networking.v1alpha3.IstioIngressListener;
import io.fabric8.istio.api.networking.v1alpha3.IstioIngressListenerBuilder;
import io.fabric8.istio.api.networking.v1alpha3.IstioIngressListenerFluent;
import io.fabric8.istio.api.networking.v1alpha3.OutboundTrafficPolicy;
import io.fabric8.istio.api.networking.v1alpha3.OutboundTrafficPolicyBuilder;
import io.fabric8.istio.api.networking.v1alpha3.OutboundTrafficPolicyFluent;
import io.fabric8.istio.api.networking.v1alpha3.SidecarSpec;
import io.fabric8.istio.api.networking.v1alpha3.WorkloadSelector;
import io.fabric8.istio.api.networking.v1alpha3.WorkloadSelectorBuilder;
import io.fabric8.istio.api.networking.v1alpha3.WorkloadSelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class SidecarSpecFluent<A extends SidecarSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<IstioEgressListenerBuilder> egress = new ArrayList();
    private ArrayList<IstioIngressListenerBuilder> ingress = new ArrayList();
    private OutboundTrafficPolicyBuilder outboundTrafficPolicy;
    private WorkloadSelectorBuilder workloadSelector;

    public SidecarSpecFluent() {
    }

    public SidecarSpecFluent(SidecarSpec instance) {
        SidecarSpec sidecarSpec = instance = instance != null ? instance : new SidecarSpec();
        if (instance != null) {
            this.withEgress(instance.getEgress());
            this.withIngress(instance.getIngress());
            this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy());
            this.withWorkloadSelector(instance.getWorkloadSelector());
            this.withEgress(instance.getEgress());
            this.withIngress(instance.getIngress());
            this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy());
            this.withWorkloadSelector(instance.getWorkloadSelector());
        }
    }

    public A addToEgress(int index, IstioEgressListener item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
        if (index < 0 || index >= this.egress.size()) {
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        } else {
            this._visitables.get((Object)"egress").add(index, builder);
            this.egress.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEgress(int index, IstioEgressListener item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
        if (index < 0 || index >= this.egress.size()) {
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        } else {
            this._visitables.get((Object)"egress").set(index, builder);
            this.egress.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEgress(IstioEgressListener ... items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (IstioEgressListener item : items) {
            IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEgress(Collection<IstioEgressListener> items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (IstioEgressListener item : items) {
            IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEgress(IstioEgressListener ... items) {
        if (this.egress == null) {
            return (A)((Object)this);
        }
        for (IstioEgressListener item : items) {
            IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
            this._visitables.get((Object)"egress").remove((Object)builder);
            this.egress.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEgress(Collection<IstioEgressListener> items) {
        if (this.egress == null) {
            return (A)((Object)this);
        }
        for (IstioEgressListener item : items) {
            IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
            this._visitables.get((Object)"egress").remove((Object)builder);
            this.egress.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEgress(Predicate<IstioEgressListenerBuilder> predicate) {
        if (this.egress == null) {
            return (A)((Object)this);
        }
        Iterator<IstioEgressListenerBuilder> each = this.egress.iterator();
        List visitables = this._visitables.get((Object)"egress");
        while (each.hasNext()) {
            IstioEgressListenerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<IstioEgressListener> buildEgress() {
        return this.egress != null ? SidecarSpecFluent.build(this.egress) : null;
    }

    public IstioEgressListener buildEgress(int index) {
        return this.egress.get(index).build();
    }

    public IstioEgressListener buildFirstEgress() {
        return this.egress.get(0).build();
    }

    public IstioEgressListener buildLastEgress() {
        return this.egress.get(this.egress.size() - 1).build();
    }

    public IstioEgressListener buildMatchingEgress(Predicate<IstioEgressListenerBuilder> predicate) {
        for (IstioEgressListenerBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEgress(Predicate<IstioEgressListenerBuilder> predicate) {
        for (IstioEgressListenerBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEgress(List<IstioEgressListener> egress) {
        if (this.egress != null) {
            this._visitables.get((Object)"egress").clear();
        }
        if (egress != null) {
            this.egress = new ArrayList();
            for (IstioEgressListener item : egress) {
                this.addToEgress(item);
            }
        } else {
            this.egress = null;
        }
        return (A)((Object)this);
    }

    public A withEgress(IstioEgressListener ... egress) {
        if (this.egress != null) {
            this.egress.clear();
            this._visitables.remove((Object)"egress");
        }
        if (egress != null) {
            for (IstioEgressListener item : egress) {
                this.addToEgress(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEgress() {
        return this.egress != null && !this.egress.isEmpty();
    }

    public EgressNested<A> addNewEgress() {
        return new EgressNested(-1, null);
    }

    public EgressNested<A> addNewEgressLike(IstioEgressListener item) {
        return new EgressNested(-1, item);
    }

    public EgressNested<A> setNewEgressLike(int index, IstioEgressListener item) {
        return new EgressNested(index, item);
    }

    public EgressNested<A> editEgress(int index) {
        if (this.egress.size() <= index) {
            throw new RuntimeException("Can't edit egress. Index exceeds size.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public EgressNested<A> editFirstEgress() {
        if (this.egress.size() == 0) {
            throw new RuntimeException("Can't edit first egress. The list is empty.");
        }
        return this.setNewEgressLike(0, this.buildEgress(0));
    }

    public EgressNested<A> editLastEgress() {
        int index = this.egress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last egress. The list is empty.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public EgressNested<A> editMatchingEgress(Predicate<IstioEgressListenerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.egress.size(); ++i) {
            if (!predicate.test(this.egress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching egress. No match found.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    public A addToIngress(int index, IstioIngressListener item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get((Object)"ingress").add(index, builder);
            this.ingress.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToIngress(int index, IstioIngressListener item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get((Object)"ingress").set(index, builder);
            this.ingress.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToIngress(IstioIngressListener ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (IstioIngressListener item : items) {
            IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIngress(Collection<IstioIngressListener> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (IstioIngressListener item : items) {
            IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
            this._visitables.get((Object)"ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromIngress(IstioIngressListener ... items) {
        if (this.ingress == null) {
            return (A)((Object)this);
        }
        for (IstioIngressListener item : items) {
            IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
            this._visitables.get((Object)"ingress").remove((Object)builder);
            this.ingress.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIngress(Collection<IstioIngressListener> items) {
        if (this.ingress == null) {
            return (A)((Object)this);
        }
        for (IstioIngressListener item : items) {
            IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
            this._visitables.get((Object)"ingress").remove((Object)builder);
            this.ingress.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIngress(Predicate<IstioIngressListenerBuilder> predicate) {
        if (this.ingress == null) {
            return (A)((Object)this);
        }
        Iterator<IstioIngressListenerBuilder> each = this.ingress.iterator();
        List visitables = this._visitables.get((Object)"ingress");
        while (each.hasNext()) {
            IstioIngressListenerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<IstioIngressListener> buildIngress() {
        return this.ingress != null ? SidecarSpecFluent.build(this.ingress) : null;
    }

    public IstioIngressListener buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    public IstioIngressListener buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    public IstioIngressListener buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    public IstioIngressListener buildMatchingIngress(Predicate<IstioIngressListenerBuilder> predicate) {
        for (IstioIngressListenerBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingIngress(Predicate<IstioIngressListenerBuilder> predicate) {
        for (IstioIngressListenerBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIngress(List<IstioIngressListener> ingress) {
        if (this.ingress != null) {
            this._visitables.get((Object)"ingress").clear();
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (IstioIngressListener item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)((Object)this);
    }

    public A withIngress(IstioIngressListener ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
            this._visitables.remove((Object)"ingress");
        }
        if (ingress != null) {
            for (IstioIngressListener item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    public IngressNested<A> addNewIngress() {
        return new IngressNested(-1, null);
    }

    public IngressNested<A> addNewIngressLike(IstioIngressListener item) {
        return new IngressNested(-1, item);
    }

    public IngressNested<A> setNewIngressLike(int index, IstioIngressListener item) {
        return new IngressNested(index, item);
    }

    public IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    public IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public IngressNested<A> editMatchingIngress(Predicate<IstioIngressListenerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    public OutboundTrafficPolicy buildOutboundTrafficPolicy() {
        return this.outboundTrafficPolicy != null ? this.outboundTrafficPolicy.build() : null;
    }

    public A withOutboundTrafficPolicy(OutboundTrafficPolicy outboundTrafficPolicy) {
        this._visitables.get((Object)"outboundTrafficPolicy").remove((Object)this.outboundTrafficPolicy);
        if (outboundTrafficPolicy != null) {
            this.outboundTrafficPolicy = new OutboundTrafficPolicyBuilder(outboundTrafficPolicy);
            this._visitables.get((Object)"outboundTrafficPolicy").add(this.outboundTrafficPolicy);
        } else {
            this.outboundTrafficPolicy = null;
            this._visitables.get((Object)"outboundTrafficPolicy").remove((Object)this.outboundTrafficPolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasOutboundTrafficPolicy() {
        return this.outboundTrafficPolicy != null;
    }

    public OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicy() {
        return new OutboundTrafficPolicyNested(null);
    }

    public OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item) {
        return new OutboundTrafficPolicyNested(item);
    }

    public OutboundTrafficPolicyNested<A> editOutboundTrafficPolicy() {
        return this.withNewOutboundTrafficPolicyLike(Optional.ofNullable(this.buildOutboundTrafficPolicy()).orElse(null));
    }

    public OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicy() {
        return this.withNewOutboundTrafficPolicyLike(Optional.ofNullable(this.buildOutboundTrafficPolicy()).orElse(new OutboundTrafficPolicyBuilder().build()));
    }

    public OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item) {
        return this.withNewOutboundTrafficPolicyLike(Optional.ofNullable(this.buildOutboundTrafficPolicy()).orElse(item));
    }

    public WorkloadSelector buildWorkloadSelector() {
        return this.workloadSelector != null ? this.workloadSelector.build() : null;
    }

    public A withWorkloadSelector(WorkloadSelector workloadSelector) {
        this._visitables.get((Object)"workloadSelector").remove((Object)this.workloadSelector);
        if (workloadSelector != null) {
            this.workloadSelector = new WorkloadSelectorBuilder(workloadSelector);
            this._visitables.get((Object)"workloadSelector").add(this.workloadSelector);
        } else {
            this.workloadSelector = null;
            this._visitables.get((Object)"workloadSelector").remove((Object)this.workloadSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasWorkloadSelector() {
        return this.workloadSelector != null;
    }

    public WorkloadSelectorNested<A> withNewWorkloadSelector() {
        return new WorkloadSelectorNested(null);
    }

    public WorkloadSelectorNested<A> withNewWorkloadSelectorLike(WorkloadSelector item) {
        return new WorkloadSelectorNested(item);
    }

    public WorkloadSelectorNested<A> editWorkloadSelector() {
        return this.withNewWorkloadSelectorLike(Optional.ofNullable(this.buildWorkloadSelector()).orElse(null));
    }

    public WorkloadSelectorNested<A> editOrNewWorkloadSelector() {
        return this.withNewWorkloadSelectorLike(Optional.ofNullable(this.buildWorkloadSelector()).orElse(new WorkloadSelectorBuilder().build()));
    }

    public WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(WorkloadSelector item) {
        return this.withNewWorkloadSelectorLike(Optional.ofNullable(this.buildWorkloadSelector()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SidecarSpecFluent that = (SidecarSpecFluent)((Object)o);
        if (!Objects.equals(this.egress, that.egress)) {
            return false;
        }
        if (!Objects.equals(this.ingress, that.ingress)) {
            return false;
        }
        if (!Objects.equals((Object)this.outboundTrafficPolicy, (Object)that.outboundTrafficPolicy)) {
            return false;
        }
        return Objects.equals((Object)this.workloadSelector, (Object)that.workloadSelector);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.egress, this.ingress, this.outboundTrafficPolicy, this.workloadSelector, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.egress != null && !this.egress.isEmpty()) {
            sb.append("egress:");
            sb.append(this.egress + ",");
        }
        if (this.ingress != null && !this.ingress.isEmpty()) {
            sb.append("ingress:");
            sb.append(this.ingress + ",");
        }
        if (this.outboundTrafficPolicy != null) {
            sb.append("outboundTrafficPolicy:");
            sb.append((Object)((Object)this.outboundTrafficPolicy) + ",");
        }
        if (this.workloadSelector != null) {
            sb.append("workloadSelector:");
            sb.append((Object)this.workloadSelector);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WorkloadSelectorNested<N>
    extends WorkloadSelectorFluent<WorkloadSelectorNested<N>>
    implements Nested<N> {
        WorkloadSelectorBuilder builder;

        WorkloadSelectorNested(WorkloadSelector item) {
            this.builder = new WorkloadSelectorBuilder(this, item);
        }

        public N and() {
            return (N)SidecarSpecFluent.this.withWorkloadSelector(this.builder.build());
        }

        public N endWorkloadSelector() {
            return this.and();
        }
    }

    public class OutboundTrafficPolicyNested<N>
    extends OutboundTrafficPolicyFluent<OutboundTrafficPolicyNested<N>>
    implements Nested<N> {
        OutboundTrafficPolicyBuilder builder;

        OutboundTrafficPolicyNested(OutboundTrafficPolicy item) {
            this.builder = new OutboundTrafficPolicyBuilder(this, item);
        }

        public N and() {
            return (N)SidecarSpecFluent.this.withOutboundTrafficPolicy(this.builder.build());
        }

        public N endOutboundTrafficPolicy() {
            return this.and();
        }
    }

    public class IngressNested<N>
    extends IstioIngressListenerFluent<IngressNested<N>>
    implements Nested<N> {
        IstioIngressListenerBuilder builder;
        int index;

        IngressNested(int index, IstioIngressListener item) {
            this.index = index;
            this.builder = new IstioIngressListenerBuilder(this, item);
        }

        public N and() {
            return (N)SidecarSpecFluent.this.setToIngress(this.index, this.builder.build());
        }

        public N endIngress() {
            return this.and();
        }
    }

    public class EgressNested<N>
    extends IstioEgressListenerFluent<EgressNested<N>>
    implements Nested<N> {
        IstioEgressListenerBuilder builder;
        int index;

        EgressNested(int index, IstioEgressListener item) {
            this.index = index;
            this.builder = new IstioEgressListenerBuilder(this, item);
        }

        public N and() {
            return (N)SidecarSpecFluent.this.setToEgress(this.index, this.builder.build());
        }

        public N endEgress() {
            return this.and();
        }
    }
}

