package io.fabric8.istio.api.security.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SourceFluent<A extends SourceFluent<A>> extends BaseFluent<A>{
  public SourceFluent() {
  }
  public SourceFluent(Source instance) {
    instance = (instance != null ? instance : new Source());

    if (instance != null) {
      this.withIpBlocks(instance.getIpBlocks());
      this.withNamespaces(instance.getNamespaces());
      this.withNotIpBlocks(instance.getNotIpBlocks());
      this.withNotNamespaces(instance.getNotNamespaces());
      this.withNotPrincipals(instance.getNotPrincipals());
      this.withNotRemoteIpBlocks(instance.getNotRemoteIpBlocks());
      this.withNotRequestPrincipals(instance.getNotRequestPrincipals());
      this.withPrincipals(instance.getPrincipals());
      this.withRemoteIpBlocks(instance.getRemoteIpBlocks());
      this.withRequestPrincipals(instance.getRequestPrincipals());
      this.withIpBlocks(instance.getIpBlocks());
      this.withNamespaces(instance.getNamespaces());
      this.withNotIpBlocks(instance.getNotIpBlocks());
      this.withNotNamespaces(instance.getNotNamespaces());
      this.withNotPrincipals(instance.getNotPrincipals());
      this.withNotRemoteIpBlocks(instance.getNotRemoteIpBlocks());
      this.withNotRequestPrincipals(instance.getNotRequestPrincipals());
      this.withPrincipals(instance.getPrincipals());
      this.withRemoteIpBlocks(instance.getRemoteIpBlocks());
      this.withRequestPrincipals(instance.getRequestPrincipals());
    }
  }
  private List<String> ipBlocks = new ArrayList<String>();
  private List<String> namespaces = new ArrayList<String>();
  private List<String> notIpBlocks = new ArrayList<String>();
  private List<String> notNamespaces = new ArrayList<String>();
  private List<String> notPrincipals = new ArrayList<String>();
  private List<String> notRemoteIpBlocks = new ArrayList<String>();
  private List<String> notRequestPrincipals = new ArrayList<String>();
  private List<String> principals = new ArrayList<String>();
  private List<String> remoteIpBlocks = new ArrayList<String>();
  private List<String> requestPrincipals = new ArrayList<String>();
  public A addToIpBlocks(int index,String item) {
    if (this.ipBlocks == null) {this.ipBlocks = new ArrayList<String>();}
    this.ipBlocks.add(index, item);
    return (A)this;
  }
  public A setToIpBlocks(int index,String item) {
    if (this.ipBlocks == null) {this.ipBlocks = new ArrayList<String>();}
    this.ipBlocks.set(index, item); return (A)this;
  }
  public A addToIpBlocks(java.lang.String... items) {
    if (this.ipBlocks == null) {this.ipBlocks = new ArrayList<String>();}
    for (String item : items) {this.ipBlocks.add(item);} return (A)this;
  }
  public A addAllToIpBlocks(Collection<String> items) {
    if (this.ipBlocks == null) {this.ipBlocks = new ArrayList<String>();}
    for (String item : items) {this.ipBlocks.add(item);} return (A)this;
  }
  public A removeFromIpBlocks(java.lang.String... items) {
    if (this.ipBlocks == null) return (A)this;
    for (String item : items) { this.ipBlocks.remove(item);} return (A)this;
  }
  public A removeAllFromIpBlocks(Collection<String> items) {
    if (this.ipBlocks == null) return (A)this;
    for (String item : items) { this.ipBlocks.remove(item);} return (A)this;
  }
  public List<String> getIpBlocks() {
    return this.ipBlocks;
  }
  public String getIpBlock(int index) {
    return this.ipBlocks.get(index);
  }
  public String getFirstIpBlock() {
    return this.ipBlocks.get(0);
  }
  public String getLastIpBlock() {
    return this.ipBlocks.get(ipBlocks.size() - 1);
  }
  public String getMatchingIpBlock(Predicate<String> predicate) {
    for (String item: ipBlocks) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingIpBlock(Predicate<String> predicate) {
    for (String item: ipBlocks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIpBlocks(List<String> ipBlocks) {
    if (ipBlocks != null) {this.ipBlocks = new ArrayList(); for (String item : ipBlocks){this.addToIpBlocks(item);}} else { this.ipBlocks = null;} return (A) this;
  }
  public A withIpBlocks(java.lang.String... ipBlocks) {
    if (this.ipBlocks != null) {this.ipBlocks.clear(); _visitables.remove("ipBlocks"); }
    if (ipBlocks != null) {for (String item :ipBlocks){ this.addToIpBlocks(item);}} return (A) this;
  }
  public boolean hasIpBlocks() {
    return ipBlocks != null && !ipBlocks.isEmpty();
  }
  public A addToNamespaces(int index,String item) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
    this.namespaces.add(index, item);
    return (A)this;
  }
  public A setToNamespaces(int index,String item) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
    this.namespaces.set(index, item); return (A)this;
  }
  public A addToNamespaces(java.lang.String... items) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
    for (String item : items) {this.namespaces.add(item);} return (A)this;
  }
  public A addAllToNamespaces(Collection<String> items) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
    for (String item : items) {this.namespaces.add(item);} return (A)this;
  }
  public A removeFromNamespaces(java.lang.String... items) {
    if (this.namespaces == null) return (A)this;
    for (String item : items) { this.namespaces.remove(item);} return (A)this;
  }
  public A removeAllFromNamespaces(Collection<String> items) {
    if (this.namespaces == null) return (A)this;
    for (String item : items) { this.namespaces.remove(item);} return (A)this;
  }
  public List<String> getNamespaces() {
    return this.namespaces;
  }
  public String getNamespace(int index) {
    return this.namespaces.get(index);
  }
  public String getFirstNamespace() {
    return this.namespaces.get(0);
  }
  public String getLastNamespace() {
    return this.namespaces.get(namespaces.size() - 1);
  }
  public String getMatchingNamespace(Predicate<String> predicate) {
    for (String item: namespaces) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingNamespace(Predicate<String> predicate) {
    for (String item: namespaces) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNamespaces(List<String> namespaces) {
    if (namespaces != null) {this.namespaces = new ArrayList(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
  }
  public A withNamespaces(java.lang.String... namespaces) {
    if (this.namespaces != null) {this.namespaces.clear(); _visitables.remove("namespaces"); }
    if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
  }
  public boolean hasNamespaces() {
    return namespaces != null && !namespaces.isEmpty();
  }
  public A addToNotIpBlocks(int index,String item) {
    if (this.notIpBlocks == null) {this.notIpBlocks = new ArrayList<String>();}
    this.notIpBlocks.add(index, item);
    return (A)this;
  }
  public A setToNotIpBlocks(int index,String item) {
    if (this.notIpBlocks == null) {this.notIpBlocks = new ArrayList<String>();}
    this.notIpBlocks.set(index, item); return (A)this;
  }
  public A addToNotIpBlocks(java.lang.String... items) {
    if (this.notIpBlocks == null) {this.notIpBlocks = new ArrayList<String>();}
    for (String item : items) {this.notIpBlocks.add(item);} return (A)this;
  }
  public A addAllToNotIpBlocks(Collection<String> items) {
    if (this.notIpBlocks == null) {this.notIpBlocks = new ArrayList<String>();}
    for (String item : items) {this.notIpBlocks.add(item);} return (A)this;
  }
  public A removeFromNotIpBlocks(java.lang.String... items) {
    if (this.notIpBlocks == null) return (A)this;
    for (String item : items) { this.notIpBlocks.remove(item);} return (A)this;
  }
  public A removeAllFromNotIpBlocks(Collection<String> items) {
    if (this.notIpBlocks == null) return (A)this;
    for (String item : items) { this.notIpBlocks.remove(item);} return (A)this;
  }
  public List<String> getNotIpBlocks() {
    return this.notIpBlocks;
  }
  public String getNotIpBlock(int index) {
    return this.notIpBlocks.get(index);
  }
  public String getFirstNotIpBlock() {
    return this.notIpBlocks.get(0);
  }
  public String getLastNotIpBlock() {
    return this.notIpBlocks.get(notIpBlocks.size() - 1);
  }
  public String getMatchingNotIpBlock(Predicate<String> predicate) {
    for (String item: notIpBlocks) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingNotIpBlock(Predicate<String> predicate) {
    for (String item: notIpBlocks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNotIpBlocks(List<String> notIpBlocks) {
    if (notIpBlocks != null) {this.notIpBlocks = new ArrayList(); for (String item : notIpBlocks){this.addToNotIpBlocks(item);}} else { this.notIpBlocks = null;} return (A) this;
  }
  public A withNotIpBlocks(java.lang.String... notIpBlocks) {
    if (this.notIpBlocks != null) {this.notIpBlocks.clear(); _visitables.remove("notIpBlocks"); }
    if (notIpBlocks != null) {for (String item :notIpBlocks){ this.addToNotIpBlocks(item);}} return (A) this;
  }
  public boolean hasNotIpBlocks() {
    return notIpBlocks != null && !notIpBlocks.isEmpty();
  }
  public A addToNotNamespaces(int index,String item) {
    if (this.notNamespaces == null) {this.notNamespaces = new ArrayList<String>();}
    this.notNamespaces.add(index, item);
    return (A)this;
  }
  public A setToNotNamespaces(int index,String item) {
    if (this.notNamespaces == null) {this.notNamespaces = new ArrayList<String>();}
    this.notNamespaces.set(index, item); return (A)this;
  }
  public A addToNotNamespaces(java.lang.String... items) {
    if (this.notNamespaces == null) {this.notNamespaces = new ArrayList<String>();}
    for (String item : items) {this.notNamespaces.add(item);} return (A)this;
  }
  public A addAllToNotNamespaces(Collection<String> items) {
    if (this.notNamespaces == null) {this.notNamespaces = new ArrayList<String>();}
    for (String item : items) {this.notNamespaces.add(item);} return (A)this;
  }
  public A removeFromNotNamespaces(java.lang.String... items) {
    if (this.notNamespaces == null) return (A)this;
    for (String item : items) { this.notNamespaces.remove(item);} return (A)this;
  }
  public A removeAllFromNotNamespaces(Collection<String> items) {
    if (this.notNamespaces == null) return (A)this;
    for (String item : items) { this.notNamespaces.remove(item);} return (A)this;
  }
  public List<String> getNotNamespaces() {
    return this.notNamespaces;
  }
  public String getNotNamespace(int index) {
    return this.notNamespaces.get(index);
  }
  public String getFirstNotNamespace() {
    return this.notNamespaces.get(0);
  }
  public String getLastNotNamespace() {
    return this.notNamespaces.get(notNamespaces.size() - 1);
  }
  public String getMatchingNotNamespace(Predicate<String> predicate) {
    for (String item: notNamespaces) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingNotNamespace(Predicate<String> predicate) {
    for (String item: notNamespaces) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNotNamespaces(List<String> notNamespaces) {
    if (notNamespaces != null) {this.notNamespaces = new ArrayList(); for (String item : notNamespaces){this.addToNotNamespaces(item);}} else { this.notNamespaces = null;} return (A) this;
  }
  public A withNotNamespaces(java.lang.String... notNamespaces) {
    if (this.notNamespaces != null) {this.notNamespaces.clear(); _visitables.remove("notNamespaces"); }
    if (notNamespaces != null) {for (String item :notNamespaces){ this.addToNotNamespaces(item);}} return (A) this;
  }
  public boolean hasNotNamespaces() {
    return notNamespaces != null && !notNamespaces.isEmpty();
  }
  public A addToNotPrincipals(int index,String item) {
    if (this.notPrincipals == null) {this.notPrincipals = new ArrayList<String>();}
    this.notPrincipals.add(index, item);
    return (A)this;
  }
  public A setToNotPrincipals(int index,String item) {
    if (this.notPrincipals == null) {this.notPrincipals = new ArrayList<String>();}
    this.notPrincipals.set(index, item); return (A)this;
  }
  public A addToNotPrincipals(java.lang.String... items) {
    if (this.notPrincipals == null) {this.notPrincipals = new ArrayList<String>();}
    for (String item : items) {this.notPrincipals.add(item);} return (A)this;
  }
  public A addAllToNotPrincipals(Collection<String> items) {
    if (this.notPrincipals == null) {this.notPrincipals = new ArrayList<String>();}
    for (String item : items) {this.notPrincipals.add(item);} return (A)this;
  }
  public A removeFromNotPrincipals(java.lang.String... items) {
    if (this.notPrincipals == null) return (A)this;
    for (String item : items) { this.notPrincipals.remove(item);} return (A)this;
  }
  public A removeAllFromNotPrincipals(Collection<String> items) {
    if (this.notPrincipals == null) return (A)this;
    for (String item : items) { this.notPrincipals.remove(item);} return (A)this;
  }
  public List<String> getNotPrincipals() {
    return this.notPrincipals;
  }
  public String getNotPrincipal(int index) {
    return this.notPrincipals.get(index);
  }
  public String getFirstNotPrincipal() {
    return this.notPrincipals.get(0);
  }
  public String getLastNotPrincipal() {
    return this.notPrincipals.get(notPrincipals.size() - 1);
  }
  public String getMatchingNotPrincipal(Predicate<String> predicate) {
    for (String item: notPrincipals) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingNotPrincipal(Predicate<String> predicate) {
    for (String item: notPrincipals) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNotPrincipals(List<String> notPrincipals) {
    if (notPrincipals != null) {this.notPrincipals = new ArrayList(); for (String item : notPrincipals){this.addToNotPrincipals(item);}} else { this.notPrincipals = null;} return (A) this;
  }
  public A withNotPrincipals(java.lang.String... notPrincipals) {
    if (this.notPrincipals != null) {this.notPrincipals.clear(); _visitables.remove("notPrincipals"); }
    if (notPrincipals != null) {for (String item :notPrincipals){ this.addToNotPrincipals(item);}} return (A) this;
  }
  public boolean hasNotPrincipals() {
    return notPrincipals != null && !notPrincipals.isEmpty();
  }
  public A addToNotRemoteIpBlocks(int index,String item) {
    if (this.notRemoteIpBlocks == null) {this.notRemoteIpBlocks = new ArrayList<String>();}
    this.notRemoteIpBlocks.add(index, item);
    return (A)this;
  }
  public A setToNotRemoteIpBlocks(int index,String item) {
    if (this.notRemoteIpBlocks == null) {this.notRemoteIpBlocks = new ArrayList<String>();}
    this.notRemoteIpBlocks.set(index, item); return (A)this;
  }
  public A addToNotRemoteIpBlocks(java.lang.String... items) {
    if (this.notRemoteIpBlocks == null) {this.notRemoteIpBlocks = new ArrayList<String>();}
    for (String item : items) {this.notRemoteIpBlocks.add(item);} return (A)this;
  }
  public A addAllToNotRemoteIpBlocks(Collection<String> items) {
    if (this.notRemoteIpBlocks == null) {this.notRemoteIpBlocks = new ArrayList<String>();}
    for (String item : items) {this.notRemoteIpBlocks.add(item);} return (A)this;
  }
  public A removeFromNotRemoteIpBlocks(java.lang.String... items) {
    if (this.notRemoteIpBlocks == null) return (A)this;
    for (String item : items) { this.notRemoteIpBlocks.remove(item);} return (A)this;
  }
  public A removeAllFromNotRemoteIpBlocks(Collection<String> items) {
    if (this.notRemoteIpBlocks == null) return (A)this;
    for (String item : items) { this.notRemoteIpBlocks.remove(item);} return (A)this;
  }
  public List<String> getNotRemoteIpBlocks() {
    return this.notRemoteIpBlocks;
  }
  public String getNotRemoteIpBlock(int index) {
    return this.notRemoteIpBlocks.get(index);
  }
  public String getFirstNotRemoteIpBlock() {
    return this.notRemoteIpBlocks.get(0);
  }
  public String getLastNotRemoteIpBlock() {
    return this.notRemoteIpBlocks.get(notRemoteIpBlocks.size() - 1);
  }
  public String getMatchingNotRemoteIpBlock(Predicate<String> predicate) {
    for (String item: notRemoteIpBlocks) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingNotRemoteIpBlock(Predicate<String> predicate) {
    for (String item: notRemoteIpBlocks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNotRemoteIpBlocks(List<String> notRemoteIpBlocks) {
    if (notRemoteIpBlocks != null) {this.notRemoteIpBlocks = new ArrayList(); for (String item : notRemoteIpBlocks){this.addToNotRemoteIpBlocks(item);}} else { this.notRemoteIpBlocks = null;} return (A) this;
  }
  public A withNotRemoteIpBlocks(java.lang.String... notRemoteIpBlocks) {
    if (this.notRemoteIpBlocks != null) {this.notRemoteIpBlocks.clear(); _visitables.remove("notRemoteIpBlocks"); }
    if (notRemoteIpBlocks != null) {for (String item :notRemoteIpBlocks){ this.addToNotRemoteIpBlocks(item);}} return (A) this;
  }
  public boolean hasNotRemoteIpBlocks() {
    return notRemoteIpBlocks != null && !notRemoteIpBlocks.isEmpty();
  }
  public A addToNotRequestPrincipals(int index,String item) {
    if (this.notRequestPrincipals == null) {this.notRequestPrincipals = new ArrayList<String>();}
    this.notRequestPrincipals.add(index, item);
    return (A)this;
  }
  public A setToNotRequestPrincipals(int index,String item) {
    if (this.notRequestPrincipals == null) {this.notRequestPrincipals = new ArrayList<String>();}
    this.notRequestPrincipals.set(index, item); return (A)this;
  }
  public A addToNotRequestPrincipals(java.lang.String... items) {
    if (this.notRequestPrincipals == null) {this.notRequestPrincipals = new ArrayList<String>();}
    for (String item : items) {this.notRequestPrincipals.add(item);} return (A)this;
  }
  public A addAllToNotRequestPrincipals(Collection<String> items) {
    if (this.notRequestPrincipals == null) {this.notRequestPrincipals = new ArrayList<String>();}
    for (String item : items) {this.notRequestPrincipals.add(item);} return (A)this;
  }
  public A removeFromNotRequestPrincipals(java.lang.String... items) {
    if (this.notRequestPrincipals == null) return (A)this;
    for (String item : items) { this.notRequestPrincipals.remove(item);} return (A)this;
  }
  public A removeAllFromNotRequestPrincipals(Collection<String> items) {
    if (this.notRequestPrincipals == null) return (A)this;
    for (String item : items) { this.notRequestPrincipals.remove(item);} return (A)this;
  }
  public List<String> getNotRequestPrincipals() {
    return this.notRequestPrincipals;
  }
  public String getNotRequestPrincipal(int index) {
    return this.notRequestPrincipals.get(index);
  }
  public String getFirstNotRequestPrincipal() {
    return this.notRequestPrincipals.get(0);
  }
  public String getLastNotRequestPrincipal() {
    return this.notRequestPrincipals.get(notRequestPrincipals.size() - 1);
  }
  public String getMatchingNotRequestPrincipal(Predicate<String> predicate) {
    for (String item: notRequestPrincipals) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingNotRequestPrincipal(Predicate<String> predicate) {
    for (String item: notRequestPrincipals) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNotRequestPrincipals(List<String> notRequestPrincipals) {
    if (notRequestPrincipals != null) {this.notRequestPrincipals = new ArrayList(); for (String item : notRequestPrincipals){this.addToNotRequestPrincipals(item);}} else { this.notRequestPrincipals = null;} return (A) this;
  }
  public A withNotRequestPrincipals(java.lang.String... notRequestPrincipals) {
    if (this.notRequestPrincipals != null) {this.notRequestPrincipals.clear(); _visitables.remove("notRequestPrincipals"); }
    if (notRequestPrincipals != null) {for (String item :notRequestPrincipals){ this.addToNotRequestPrincipals(item);}} return (A) this;
  }
  public boolean hasNotRequestPrincipals() {
    return notRequestPrincipals != null && !notRequestPrincipals.isEmpty();
  }
  public A addToPrincipals(int index,String item) {
    if (this.principals == null) {this.principals = new ArrayList<String>();}
    this.principals.add(index, item);
    return (A)this;
  }
  public A setToPrincipals(int index,String item) {
    if (this.principals == null) {this.principals = new ArrayList<String>();}
    this.principals.set(index, item); return (A)this;
  }
  public A addToPrincipals(java.lang.String... items) {
    if (this.principals == null) {this.principals = new ArrayList<String>();}
    for (String item : items) {this.principals.add(item);} return (A)this;
  }
  public A addAllToPrincipals(Collection<String> items) {
    if (this.principals == null) {this.principals = new ArrayList<String>();}
    for (String item : items) {this.principals.add(item);} return (A)this;
  }
  public A removeFromPrincipals(java.lang.String... items) {
    if (this.principals == null) return (A)this;
    for (String item : items) { this.principals.remove(item);} return (A)this;
  }
  public A removeAllFromPrincipals(Collection<String> items) {
    if (this.principals == null) return (A)this;
    for (String item : items) { this.principals.remove(item);} return (A)this;
  }
  public List<String> getPrincipals() {
    return this.principals;
  }
  public String getPrincipal(int index) {
    return this.principals.get(index);
  }
  public String getFirstPrincipal() {
    return this.principals.get(0);
  }
  public String getLastPrincipal() {
    return this.principals.get(principals.size() - 1);
  }
  public String getMatchingPrincipal(Predicate<String> predicate) {
    for (String item: principals) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingPrincipal(Predicate<String> predicate) {
    for (String item: principals) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPrincipals(List<String> principals) {
    if (principals != null) {this.principals = new ArrayList(); for (String item : principals){this.addToPrincipals(item);}} else { this.principals = null;} return (A) this;
  }
  public A withPrincipals(java.lang.String... principals) {
    if (this.principals != null) {this.principals.clear(); _visitables.remove("principals"); }
    if (principals != null) {for (String item :principals){ this.addToPrincipals(item);}} return (A) this;
  }
  public boolean hasPrincipals() {
    return principals != null && !principals.isEmpty();
  }
  public A addToRemoteIpBlocks(int index,String item) {
    if (this.remoteIpBlocks == null) {this.remoteIpBlocks = new ArrayList<String>();}
    this.remoteIpBlocks.add(index, item);
    return (A)this;
  }
  public A setToRemoteIpBlocks(int index,String item) {
    if (this.remoteIpBlocks == null) {this.remoteIpBlocks = new ArrayList<String>();}
    this.remoteIpBlocks.set(index, item); return (A)this;
  }
  public A addToRemoteIpBlocks(java.lang.String... items) {
    if (this.remoteIpBlocks == null) {this.remoteIpBlocks = new ArrayList<String>();}
    for (String item : items) {this.remoteIpBlocks.add(item);} return (A)this;
  }
  public A addAllToRemoteIpBlocks(Collection<String> items) {
    if (this.remoteIpBlocks == null) {this.remoteIpBlocks = new ArrayList<String>();}
    for (String item : items) {this.remoteIpBlocks.add(item);} return (A)this;
  }
  public A removeFromRemoteIpBlocks(java.lang.String... items) {
    if (this.remoteIpBlocks == null) return (A)this;
    for (String item : items) { this.remoteIpBlocks.remove(item);} return (A)this;
  }
  public A removeAllFromRemoteIpBlocks(Collection<String> items) {
    if (this.remoteIpBlocks == null) return (A)this;
    for (String item : items) { this.remoteIpBlocks.remove(item);} return (A)this;
  }
  public List<String> getRemoteIpBlocks() {
    return this.remoteIpBlocks;
  }
  public String getRemoteIpBlock(int index) {
    return this.remoteIpBlocks.get(index);
  }
  public String getFirstRemoteIpBlock() {
    return this.remoteIpBlocks.get(0);
  }
  public String getLastRemoteIpBlock() {
    return this.remoteIpBlocks.get(remoteIpBlocks.size() - 1);
  }
  public String getMatchingRemoteIpBlock(Predicate<String> predicate) {
    for (String item: remoteIpBlocks) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingRemoteIpBlock(Predicate<String> predicate) {
    for (String item: remoteIpBlocks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRemoteIpBlocks(List<String> remoteIpBlocks) {
    if (remoteIpBlocks != null) {this.remoteIpBlocks = new ArrayList(); for (String item : remoteIpBlocks){this.addToRemoteIpBlocks(item);}} else { this.remoteIpBlocks = null;} return (A) this;
  }
  public A withRemoteIpBlocks(java.lang.String... remoteIpBlocks) {
    if (this.remoteIpBlocks != null) {this.remoteIpBlocks.clear(); _visitables.remove("remoteIpBlocks"); }
    if (remoteIpBlocks != null) {for (String item :remoteIpBlocks){ this.addToRemoteIpBlocks(item);}} return (A) this;
  }
  public boolean hasRemoteIpBlocks() {
    return remoteIpBlocks != null && !remoteIpBlocks.isEmpty();
  }
  public A addToRequestPrincipals(int index,String item) {
    if (this.requestPrincipals == null) {this.requestPrincipals = new ArrayList<String>();}
    this.requestPrincipals.add(index, item);
    return (A)this;
  }
  public A setToRequestPrincipals(int index,String item) {
    if (this.requestPrincipals == null) {this.requestPrincipals = new ArrayList<String>();}
    this.requestPrincipals.set(index, item); return (A)this;
  }
  public A addToRequestPrincipals(java.lang.String... items) {
    if (this.requestPrincipals == null) {this.requestPrincipals = new ArrayList<String>();}
    for (String item : items) {this.requestPrincipals.add(item);} return (A)this;
  }
  public A addAllToRequestPrincipals(Collection<String> items) {
    if (this.requestPrincipals == null) {this.requestPrincipals = new ArrayList<String>();}
    for (String item : items) {this.requestPrincipals.add(item);} return (A)this;
  }
  public A removeFromRequestPrincipals(java.lang.String... items) {
    if (this.requestPrincipals == null) return (A)this;
    for (String item : items) { this.requestPrincipals.remove(item);} return (A)this;
  }
  public A removeAllFromRequestPrincipals(Collection<String> items) {
    if (this.requestPrincipals == null) return (A)this;
    for (String item : items) { this.requestPrincipals.remove(item);} return (A)this;
  }
  public List<String> getRequestPrincipals() {
    return this.requestPrincipals;
  }
  public String getRequestPrincipal(int index) {
    return this.requestPrincipals.get(index);
  }
  public String getFirstRequestPrincipal() {
    return this.requestPrincipals.get(0);
  }
  public String getLastRequestPrincipal() {
    return this.requestPrincipals.get(requestPrincipals.size() - 1);
  }
  public String getMatchingRequestPrincipal(Predicate<String> predicate) {
    for (String item: requestPrincipals) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingRequestPrincipal(Predicate<String> predicate) {
    for (String item: requestPrincipals) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRequestPrincipals(List<String> requestPrincipals) {
    if (requestPrincipals != null) {this.requestPrincipals = new ArrayList(); for (String item : requestPrincipals){this.addToRequestPrincipals(item);}} else { this.requestPrincipals = null;} return (A) this;
  }
  public A withRequestPrincipals(java.lang.String... requestPrincipals) {
    if (this.requestPrincipals != null) {this.requestPrincipals.clear(); _visitables.remove("requestPrincipals"); }
    if (requestPrincipals != null) {for (String item :requestPrincipals){ this.addToRequestPrincipals(item);}} return (A) this;
  }
  public boolean hasRequestPrincipals() {
    return requestPrincipals != null && !requestPrincipals.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SourceFluent that = (SourceFluent) o;
    if (!java.util.Objects.equals(ipBlocks, that.ipBlocks)) return false;

    if (!java.util.Objects.equals(namespaces, that.namespaces)) return false;

    if (!java.util.Objects.equals(notIpBlocks, that.notIpBlocks)) return false;

    if (!java.util.Objects.equals(notNamespaces, that.notNamespaces)) return false;

    if (!java.util.Objects.equals(notPrincipals, that.notPrincipals)) return false;

    if (!java.util.Objects.equals(notRemoteIpBlocks, that.notRemoteIpBlocks)) return false;

    if (!java.util.Objects.equals(notRequestPrincipals, that.notRequestPrincipals)) return false;

    if (!java.util.Objects.equals(principals, that.principals)) return false;

    if (!java.util.Objects.equals(remoteIpBlocks, that.remoteIpBlocks)) return false;

    if (!java.util.Objects.equals(requestPrincipals, that.requestPrincipals)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ipBlocks,  namespaces,  notIpBlocks,  notNamespaces,  notPrincipals,  notRemoteIpBlocks,  notRequestPrincipals,  principals,  remoteIpBlocks,  requestPrincipals,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ipBlocks != null && !ipBlocks.isEmpty()) { sb.append("ipBlocks:"); sb.append(ipBlocks + ","); }
    if (namespaces != null && !namespaces.isEmpty()) { sb.append("namespaces:"); sb.append(namespaces + ","); }
    if (notIpBlocks != null && !notIpBlocks.isEmpty()) { sb.append("notIpBlocks:"); sb.append(notIpBlocks + ","); }
    if (notNamespaces != null && !notNamespaces.isEmpty()) { sb.append("notNamespaces:"); sb.append(notNamespaces + ","); }
    if (notPrincipals != null && !notPrincipals.isEmpty()) { sb.append("notPrincipals:"); sb.append(notPrincipals + ","); }
    if (notRemoteIpBlocks != null && !notRemoteIpBlocks.isEmpty()) { sb.append("notRemoteIpBlocks:"); sb.append(notRemoteIpBlocks + ","); }
    if (notRequestPrincipals != null && !notRequestPrincipals.isEmpty()) { sb.append("notRequestPrincipals:"); sb.append(notRequestPrincipals + ","); }
    if (principals != null && !principals.isEmpty()) { sb.append("principals:"); sb.append(principals + ","); }
    if (remoteIpBlocks != null && !remoteIpBlocks.isEmpty()) { sb.append("remoteIpBlocks:"); sb.append(remoteIpBlocks + ","); }
    if (requestPrincipals != null && !requestPrincipals.isEmpty()) { sb.append("requestPrincipals:"); sb.append(requestPrincipals); }
    sb.append("}");
    return sb.toString();
  }
  
}