package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RequestAuthenticationSpecBuilder extends RequestAuthenticationSpecFluent<RequestAuthenticationSpecBuilder> implements VisitableBuilder<RequestAuthenticationSpec,RequestAuthenticationSpecBuilder>{
  public RequestAuthenticationSpecBuilder() {
    this(false);
  }
  public RequestAuthenticationSpecBuilder(Boolean validationEnabled) {
    this(new RequestAuthenticationSpec(), validationEnabled);
  }
  public RequestAuthenticationSpecBuilder(RequestAuthenticationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RequestAuthenticationSpecBuilder(RequestAuthenticationSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RequestAuthenticationSpec(), validationEnabled);
  }
  public RequestAuthenticationSpecBuilder(RequestAuthenticationSpecFluent<?> fluent,RequestAuthenticationSpec instance) {
    this(fluent, instance, false);
  }
  public RequestAuthenticationSpecBuilder(RequestAuthenticationSpecFluent<?> fluent,RequestAuthenticationSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RequestAuthenticationSpec());

    if (instance != null) {
      fluent.withJwtRules(instance.getJwtRules());
      fluent.withSelector(instance.getSelector());
      fluent.withJwtRules(instance.getJwtRules());
      fluent.withSelector(instance.getSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RequestAuthenticationSpecBuilder(RequestAuthenticationSpec instance) {
    this(instance,false);
  }
  public RequestAuthenticationSpecBuilder(RequestAuthenticationSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RequestAuthenticationSpec());

    if (instance != null) {
      this.withJwtRules(instance.getJwtRules());
      this.withSelector(instance.getSelector());
      this.withJwtRules(instance.getJwtRules());
      this.withSelector(instance.getSelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  RequestAuthenticationSpecFluent<?> fluent;
  Boolean validationEnabled;
  public RequestAuthenticationSpec build() {
    RequestAuthenticationSpec buildable = new RequestAuthenticationSpec(fluent.buildJwtRules(),fluent.buildSelector());
    return buildable;
  }
  
}