package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PeerAuthenticationBuilder extends PeerAuthenticationFluent<PeerAuthenticationBuilder> implements VisitableBuilder<PeerAuthentication,PeerAuthenticationBuilder>{
  public PeerAuthenticationBuilder() {
    this(false);
  }
  public PeerAuthenticationBuilder(Boolean validationEnabled) {
    this(new PeerAuthentication(), validationEnabled);
  }
  public PeerAuthenticationBuilder(PeerAuthenticationFluent<?> fluent) {
    this(fluent, false);
  }
  public PeerAuthenticationBuilder(PeerAuthenticationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PeerAuthentication(), validationEnabled);
  }
  public PeerAuthenticationBuilder(PeerAuthenticationFluent<?> fluent,PeerAuthentication instance) {
    this(fluent, instance, false);
  }
  public PeerAuthenticationBuilder(PeerAuthenticationFluent<?> fluent,PeerAuthentication instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PeerAuthentication());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PeerAuthenticationBuilder(PeerAuthentication instance) {
    this(instance,false);
  }
  public PeerAuthenticationBuilder(PeerAuthentication instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PeerAuthentication());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  PeerAuthenticationFluent<?> fluent;
  Boolean validationEnabled;
  public PeerAuthentication build() {
    PeerAuthentication buildable = new PeerAuthentication(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.getStatus());
    return buildable;
  }
  
}