package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperationBuilder extends OperationFluent<OperationBuilder> implements VisitableBuilder<Operation,OperationBuilder>{
  public OperationBuilder() {
    this(false);
  }
  public OperationBuilder(Boolean validationEnabled) {
    this(new Operation(), validationEnabled);
  }
  public OperationBuilder(OperationFluent<?> fluent) {
    this(fluent, false);
  }
  public OperationBuilder(OperationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Operation(), validationEnabled);
  }
  public OperationBuilder(OperationFluent<?> fluent,Operation instance) {
    this(fluent, instance, false);
  }
  public OperationBuilder(OperationFluent<?> fluent,Operation instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Operation());

    if (instance != null) {
      fluent.withHosts(instance.getHosts());
      fluent.withMethods(instance.getMethods());
      fluent.withNotHosts(instance.getNotHosts());
      fluent.withNotMethods(instance.getNotMethods());
      fluent.withNotPaths(instance.getNotPaths());
      fluent.withNotPorts(instance.getNotPorts());
      fluent.withPaths(instance.getPaths());
      fluent.withPorts(instance.getPorts());
      fluent.withHosts(instance.getHosts());
      fluent.withMethods(instance.getMethods());
      fluent.withNotHosts(instance.getNotHosts());
      fluent.withNotMethods(instance.getNotMethods());
      fluent.withNotPaths(instance.getNotPaths());
      fluent.withNotPorts(instance.getNotPorts());
      fluent.withPaths(instance.getPaths());
      fluent.withPorts(instance.getPorts());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperationBuilder(Operation instance) {
    this(instance,false);
  }
  public OperationBuilder(Operation instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Operation());

    if (instance != null) {
      this.withHosts(instance.getHosts());
      this.withMethods(instance.getMethods());
      this.withNotHosts(instance.getNotHosts());
      this.withNotMethods(instance.getNotMethods());
      this.withNotPaths(instance.getNotPaths());
      this.withNotPorts(instance.getNotPorts());
      this.withPaths(instance.getPaths());
      this.withPorts(instance.getPorts());
      this.withHosts(instance.getHosts());
      this.withMethods(instance.getMethods());
      this.withNotHosts(instance.getNotHosts());
      this.withNotMethods(instance.getNotMethods());
      this.withNotPaths(instance.getNotPaths());
      this.withNotPorts(instance.getNotPorts());
      this.withPaths(instance.getPaths());
      this.withPorts(instance.getPorts());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperationFluent<?> fluent;
  Boolean validationEnabled;
  public Operation build() {
    Operation buildable = new Operation(fluent.getHosts(),fluent.getMethods(),fluent.getNotHosts(),fluent.getNotMethods(),fluent.getNotPaths(),fluent.getNotPorts(),fluent.getPaths(),fluent.getPorts());
    return buildable;
  }
  
}