package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelector;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorFluent;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AuthorizationPolicySpecFluent<A extends AuthorizationPolicySpecFluent<A>> extends BaseFluent<A>{
  public AuthorizationPolicySpecFluent() {
  }
  public AuthorizationPolicySpecFluent(AuthorizationPolicySpec instance) {
    instance = (instance != null ? instance : new AuthorizationPolicySpec());

    if (instance != null) {
      this.withActionDetail(instance.getActionDetail());
      this.withAction(instance.getAction());
      this.withRules(instance.getRules());
      this.withSelector(instance.getSelector());
      this.withActionDetail(instance.getActionDetail());
      this.withAction(instance.getAction());
      this.withRules(instance.getRules());
      this.withSelector(instance.getSelector());
    }
  }
  private VisitableBuilder<? extends IsAuthorizationPolicyActionDetail,?> actionDetail;
  private AuthorizationPolicyAction action;
  private ArrayList<RuleBuilder> rules = new ArrayList<RuleBuilder>();
  private WorkloadSelectorBuilder selector;
  public IsAuthorizationPolicyActionDetail buildActionDetail() {
    return this.actionDetail!=null?this.actionDetail.build():null;
  }
  public A withActionDetail(IsAuthorizationPolicyActionDetail actionDetail) {
    if (actionDetail==null){ this.actionDetail = null; _visitables.remove("actionDetail"); return (A) this;}
    VisitableBuilder<? extends IsAuthorizationPolicyActionDetail,?> builder = builder(actionDetail); _visitables.get("actionDetail").clear();_visitables.get("actionDetail").add(builder);this.actionDetail = builder;
    return (A) this;
  }
  public boolean hasActionDetail() {
    return this.actionDetail != null;
  }
  public AuthorizationPolicyProviderActionDetailNested<A> withNewAuthorizationPolicyProviderActionDetail() {
    return new AuthorizationPolicyProviderActionDetailNested(null);
  }
  public AuthorizationPolicyProviderActionDetailNested<A> withNewAuthorizationPolicyProviderActionDetailLike(AuthorizationPolicyProvider item) {
    return new AuthorizationPolicyProviderActionDetailNested(item);
  }
  public AuthorizationPolicyAction getAction() {
    return this.action;
  }
  public A withAction(AuthorizationPolicyAction action) {
    this.action=action; return (A) this;
  }
  public boolean hasAction() {
    return this.action != null;
  }
  public A addToRules(int index,Rule item) {
    if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
    RuleBuilder builder = new RuleBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").add(index, builder); rules.add(index, builder);}
    return (A)this;
  }
  public A setToRules(int index,Rule item) {
    if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
    RuleBuilder builder = new RuleBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").set(index, builder); rules.set(index, builder);}
    return (A)this;
  }
  public A addToRules(io.fabric8.istio.api.security.v1beta1.Rule... items) {
    if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
    for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A addAllToRules(Collection<Rule> items) {
    if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
    for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A removeFromRules(io.fabric8.istio.api.security.v1beta1.Rule... items) {
    if (this.rules == null) return (A)this;
    for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  public A removeAllFromRules(Collection<Rule> items) {
    if (this.rules == null) return (A)this;
    for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  public A removeMatchingFromRules(Predicate<RuleBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<RuleBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      RuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Rule> buildRules() {
    return rules != null ? build(rules) : null;
  }
  public Rule buildRule(int index) {
    return this.rules.get(index).build();
  }
  public Rule buildFirstRule() {
    return this.rules.get(0).build();
  }
  public Rule buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  public Rule buildMatchingRule(Predicate<RuleBuilder> predicate) {
    for (RuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingRule(Predicate<RuleBuilder> predicate) {
    for (RuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRules(List<Rule> rules) {
    if (this.rules != null) { _visitables.get("rules").clear();}
    if (rules != null) {this.rules = new ArrayList(); for (Rule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
  }
  public A withRules(io.fabric8.istio.api.security.v1beta1.Rule... rules) {
    if (this.rules != null) {this.rules.clear(); _visitables.remove("rules"); }
    if (rules != null) {for (Rule item :rules){ this.addToRules(item);}} return (A) this;
  }
  public boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  public RulesNested<A> addNewRule() {
    return new RulesNested(-1, null);
  }
  public RulesNested<A> addNewRuleLike(Rule item) {
    return new RulesNested(-1, item);
  }
  public RulesNested<A> setNewRuleLike(int index,Rule item) {
    return new RulesNested(index, item);
  }
  public RulesNested<A> editRule(int index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  public RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  public RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  public RulesNested<A> editMatchingRule(Predicate<RuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  public WorkloadSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(WorkloadSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new WorkloadSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public boolean hasSelector() {
    return this.selector != null;
  }
  public TypeSelectorNested<A> withNewTypeSelector() {
    return new TypeSelectorNested(null);
  }
  public TypeSelectorNested<A> withNewSelectorLike(WorkloadSelector item) {
    return new TypeSelectorNested(item);
  }
  public TypeSelectorNested<A> editTypeSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  public TypeSelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new WorkloadSelectorBuilder().build()));
  }
  public TypeSelectorNested<A> editOrNewSelectorLike(WorkloadSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AuthorizationPolicySpecFluent that = (AuthorizationPolicySpecFluent) o;
    if (!java.util.Objects.equals(actionDetail, that.actionDetail)) return false;

    if (!java.util.Objects.equals(action, that.action)) return false;

    if (!java.util.Objects.equals(rules, that.rules)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(actionDetail,  action,  rules,  selector,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (actionDetail != null) { sb.append("actionDetail:"); sb.append(actionDetail + ","); }
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (rules != null && !rules.isEmpty()) { sb.append("rules:"); sb.append(rules + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.istio.api.security.v1beta1."+"AuthorizationPolicyProvider": return (VisitableBuilder<T, ?>)new AuthorizationPolicyProviderBuilder((AuthorizationPolicyProvider) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class AuthorizationPolicyProviderActionDetailNested<N> extends AuthorizationPolicyProviderFluent<AuthorizationPolicyProviderActionDetailNested<N>> implements Nested<N>{
    AuthorizationPolicyProviderActionDetailNested(AuthorizationPolicyProvider item) {
      this.builder = new AuthorizationPolicyProviderBuilder(this, item);
    }
    AuthorizationPolicyProviderBuilder builder;
    public N and() {
      return (N) AuthorizationPolicySpecFluent.this.withActionDetail(builder.build());
    }
    public N endAuthorizationPolicyProviderActionDetail() {
      return and();
    }
    
  }
  public class RulesNested<N> extends RuleFluent<RulesNested<N>> implements Nested<N>{
    RulesNested(int index,Rule item) {
      this.index = index;
      this.builder = new RuleBuilder(this, item);
    }
    RuleBuilder builder;
    int index;
    public N and() {
      return (N) AuthorizationPolicySpecFluent.this.setToRules(index,builder.build());
    }
    public N endRule() {
      return and();
    }
    
  }
  public class TypeSelectorNested<N> extends WorkloadSelectorFluent<TypeSelectorNested<N>> implements Nested<N>{
    TypeSelectorNested(WorkloadSelector item) {
      this.builder = new WorkloadSelectorBuilder(this, item);
    }
    WorkloadSelectorBuilder builder;
    public N and() {
      return (N) AuthorizationPolicySpecFluent.this.withSelector(builder.build());
    }
    public N endTypeSelector() {
      return and();
    }
    
  }
  
}