package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthorizationPolicyBuilder extends AuthorizationPolicyFluent<AuthorizationPolicyBuilder> implements VisitableBuilder<AuthorizationPolicy,AuthorizationPolicyBuilder>{
  public AuthorizationPolicyBuilder() {
    this(false);
  }
  public AuthorizationPolicyBuilder(Boolean validationEnabled) {
    this(new AuthorizationPolicy(), validationEnabled);
  }
  public AuthorizationPolicyBuilder(AuthorizationPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthorizationPolicyBuilder(AuthorizationPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AuthorizationPolicy(), validationEnabled);
  }
  public AuthorizationPolicyBuilder(AuthorizationPolicyFluent<?> fluent,AuthorizationPolicy instance) {
    this(fluent, instance, false);
  }
  public AuthorizationPolicyBuilder(AuthorizationPolicyFluent<?> fluent,AuthorizationPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AuthorizationPolicy());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AuthorizationPolicyBuilder(AuthorizationPolicy instance) {
    this(instance,false);
  }
  public AuthorizationPolicyBuilder(AuthorizationPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AuthorizationPolicy());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  AuthorizationPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public AuthorizationPolicy build() {
    AuthorizationPolicy buildable = new AuthorizationPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.getStatus());
    return buildable;
  }
  
}