package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VirtualServiceBuilder extends VirtualServiceFluent<VirtualServiceBuilder> implements VisitableBuilder<VirtualService,VirtualServiceBuilder>{
  public VirtualServiceBuilder() {
    this(false);
  }
  public VirtualServiceBuilder(Boolean validationEnabled) {
    this(new VirtualService(), validationEnabled);
  }
  public VirtualServiceBuilder(VirtualServiceFluent<?> fluent) {
    this(fluent, false);
  }
  public VirtualServiceBuilder(VirtualServiceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VirtualService(), validationEnabled);
  }
  public VirtualServiceBuilder(VirtualServiceFluent<?> fluent,VirtualService instance) {
    this(fluent, instance, false);
  }
  public VirtualServiceBuilder(VirtualServiceFluent<?> fluent,VirtualService instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VirtualService());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VirtualServiceBuilder(VirtualService instance) {
    this(instance,false);
  }
  public VirtualServiceBuilder(VirtualService instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VirtualService());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  VirtualServiceFluent<?> fluent;
  Boolean validationEnabled;
  public VirtualService build() {
    VirtualService buildable = new VirtualService(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.getStatus());
    return buildable;
  }
  
}