package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TrafficPolicyBuilder extends TrafficPolicyFluent<TrafficPolicyBuilder> implements VisitableBuilder<TrafficPolicy,TrafficPolicyBuilder>{
  public TrafficPolicyBuilder() {
    this(false);
  }
  public TrafficPolicyBuilder(Boolean validationEnabled) {
    this(new TrafficPolicy(), validationEnabled);
  }
  public TrafficPolicyBuilder(TrafficPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public TrafficPolicyBuilder(TrafficPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TrafficPolicy(), validationEnabled);
  }
  public TrafficPolicyBuilder(TrafficPolicyFluent<?> fluent,TrafficPolicy instance) {
    this(fluent, instance, false);
  }
  public TrafficPolicyBuilder(TrafficPolicyFluent<?> fluent,TrafficPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TrafficPolicy());

    if (instance != null) {
      fluent.withConnectionPool(instance.getConnectionPool());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withOutlierDetection(instance.getOutlierDetection());
      fluent.withPortLevelSettings(instance.getPortLevelSettings());
      fluent.withTls(instance.getTls());
      fluent.withConnectionPool(instance.getConnectionPool());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withOutlierDetection(instance.getOutlierDetection());
      fluent.withPortLevelSettings(instance.getPortLevelSettings());
      fluent.withTls(instance.getTls());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TrafficPolicyBuilder(TrafficPolicy instance) {
    this(instance,false);
  }
  public TrafficPolicyBuilder(TrafficPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TrafficPolicy());

    if (instance != null) {
      this.withConnectionPool(instance.getConnectionPool());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withOutlierDetection(instance.getOutlierDetection());
      this.withPortLevelSettings(instance.getPortLevelSettings());
      this.withTls(instance.getTls());
      this.withConnectionPool(instance.getConnectionPool());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withOutlierDetection(instance.getOutlierDetection());
      this.withPortLevelSettings(instance.getPortLevelSettings());
      this.withTls(instance.getTls());
    }
    this.validationEnabled = validationEnabled; 
  }
  TrafficPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public TrafficPolicy build() {
    TrafficPolicy buildable = new TrafficPolicy(fluent.buildConnectionPool(),fluent.buildLoadBalancer(),fluent.buildOutlierDetection(),fluent.buildPortLevelSettings(),fluent.buildTls());
    return buildable;
  }
  
}