package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TLSMatchAttributesBuilder extends TLSMatchAttributesFluent<TLSMatchAttributesBuilder> implements VisitableBuilder<TLSMatchAttributes,TLSMatchAttributesBuilder>{
  public TLSMatchAttributesBuilder() {
    this(false);
  }
  public TLSMatchAttributesBuilder(Boolean validationEnabled) {
    this(new TLSMatchAttributes(), validationEnabled);
  }
  public TLSMatchAttributesBuilder(TLSMatchAttributesFluent<?> fluent) {
    this(fluent, false);
  }
  public TLSMatchAttributesBuilder(TLSMatchAttributesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TLSMatchAttributes(), validationEnabled);
  }
  public TLSMatchAttributesBuilder(TLSMatchAttributesFluent<?> fluent,TLSMatchAttributes instance) {
    this(fluent, instance, false);
  }
  public TLSMatchAttributesBuilder(TLSMatchAttributesFluent<?> fluent,TLSMatchAttributes instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TLSMatchAttributes());

    if (instance != null) {
      fluent.withDestinationSubnets(instance.getDestinationSubnets());
      fluent.withGateways(instance.getGateways());
      fluent.withPort(instance.getPort());
      fluent.withSniHosts(instance.getSniHosts());
      fluent.withSourceLabels(instance.getSourceLabels());
      fluent.withSourceNamespace(instance.getSourceNamespace());
      fluent.withDestinationSubnets(instance.getDestinationSubnets());
      fluent.withGateways(instance.getGateways());
      fluent.withPort(instance.getPort());
      fluent.withSniHosts(instance.getSniHosts());
      fluent.withSourceLabels(instance.getSourceLabels());
      fluent.withSourceNamespace(instance.getSourceNamespace());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TLSMatchAttributesBuilder(TLSMatchAttributes instance) {
    this(instance,false);
  }
  public TLSMatchAttributesBuilder(TLSMatchAttributes instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TLSMatchAttributes());

    if (instance != null) {
      this.withDestinationSubnets(instance.getDestinationSubnets());
      this.withGateways(instance.getGateways());
      this.withPort(instance.getPort());
      this.withSniHosts(instance.getSniHosts());
      this.withSourceLabels(instance.getSourceLabels());
      this.withSourceNamespace(instance.getSourceNamespace());
      this.withDestinationSubnets(instance.getDestinationSubnets());
      this.withGateways(instance.getGateways());
      this.withPort(instance.getPort());
      this.withSniHosts(instance.getSniHosts());
      this.withSourceLabels(instance.getSourceLabels());
      this.withSourceNamespace(instance.getSourceNamespace());
    }
    this.validationEnabled = validationEnabled; 
  }
  TLSMatchAttributesFluent<?> fluent;
  Boolean validationEnabled;
  public TLSMatchAttributes build() {
    TLSMatchAttributes buildable = new TLSMatchAttributes(fluent.getDestinationSubnets(),fluent.getGateways(),fluent.getPort(),fluent.getSniHosts(),fluent.getSourceLabels(),fluent.getSourceNamespace());
    return buildable;
  }
  
}