package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TCPRouteBuilder extends TCPRouteFluent<TCPRouteBuilder> implements VisitableBuilder<TCPRoute,TCPRouteBuilder>{
  public TCPRouteBuilder() {
    this(false);
  }
  public TCPRouteBuilder(Boolean validationEnabled) {
    this(new TCPRoute(), validationEnabled);
  }
  public TCPRouteBuilder(TCPRouteFluent<?> fluent) {
    this(fluent, false);
  }
  public TCPRouteBuilder(TCPRouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TCPRoute(), validationEnabled);
  }
  public TCPRouteBuilder(TCPRouteFluent<?> fluent,TCPRoute instance) {
    this(fluent, instance, false);
  }
  public TCPRouteBuilder(TCPRouteFluent<?> fluent,TCPRoute instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TCPRoute());

    if (instance != null) {
      fluent.withMatch(instance.getMatch());
      fluent.withRoute(instance.getRoute());
      fluent.withMatch(instance.getMatch());
      fluent.withRoute(instance.getRoute());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TCPRouteBuilder(TCPRoute instance) {
    this(instance,false);
  }
  public TCPRouteBuilder(TCPRoute instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TCPRoute());

    if (instance != null) {
      this.withMatch(instance.getMatch());
      this.withRoute(instance.getRoute());
      this.withMatch(instance.getMatch());
      this.withRoute(instance.getRoute());
    }
    this.validationEnabled = validationEnabled; 
  }
  TCPRouteFluent<?> fluent;
  Boolean validationEnabled;
  public TCPRoute build() {
    TCPRoute buildable = new TCPRoute(fluent.buildMatch(),fluent.buildRoute());
    return buildable;
  }
  
}