package io.fabric8.istio.api.networking.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DestinationFluent<A extends DestinationFluent<A>> extends BaseFluent<A>{
  public DestinationFluent() {
  }
  public DestinationFluent(Destination instance) {
    instance = (instance != null ? instance : new Destination());

    if (instance != null) {
      this.withHost(instance.getHost());
      this.withPort(instance.getPort());
      this.withSubset(instance.getSubset());
      this.withHost(instance.getHost());
      this.withPort(instance.getPort());
      this.withSubset(instance.getSubset());
    }
  }
  private String host;
  private PortSelectorBuilder port;
  private String subset;
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public boolean hasHost() {
    return this.host != null;
  }
  public PortSelector buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(PortSelector port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new PortSelectorBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(Integer number) {
    return (A)withPort(new PortSelector(number));
  }
  public PortNested<A> withNewPort() {
    return new PortNested(null);
  }
  public PortNested<A> withNewPortLike(PortSelector item) {
    return new PortNested(item);
  }
  public PortNested<A> editPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(null));
  }
  public PortNested<A> editOrNewPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(new PortSelectorBuilder().build()));
  }
  public PortNested<A> editOrNewPortLike(PortSelector item) {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(item));
  }
  public String getSubset() {
    return this.subset;
  }
  public A withSubset(String subset) {
    this.subset=subset; return (A) this;
  }
  public boolean hasSubset() {
    return this.subset != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DestinationFluent that = (DestinationFluent) o;
    if (!java.util.Objects.equals(host, that.host)) return false;

    if (!java.util.Objects.equals(port, that.port)) return false;

    if (!java.util.Objects.equals(subset, that.subset)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(host,  port,  subset,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (subset != null) { sb.append("subset:"); sb.append(subset); }
    sb.append("}");
    return sb.toString();
  }
  public class PortNested<N> extends PortSelectorFluent<PortNested<N>> implements Nested<N>{
    PortNested(PortSelector item) {
      this.builder = new PortSelectorBuilder(this, item);
    }
    PortSelectorBuilder builder;
    public N and() {
      return (N) DestinationFluent.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}