/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.istio.api.security.v1beta1.JWTRule;
import io.fabric8.istio.api.security.v1beta1.JWTRuleBuilder;
import io.fabric8.istio.api.security.v1beta1.JWTRuleFluent;
import io.fabric8.istio.api.security.v1beta1.RequestAuthenticationSpec;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelector;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorBuilder;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RequestAuthenticationSpecFluent<A extends RequestAuthenticationSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<JWTRuleBuilder> jwtRules = new ArrayList();
    private WorkloadSelectorBuilder selector;

    public RequestAuthenticationSpecFluent() {
    }

    public RequestAuthenticationSpecFluent(RequestAuthenticationSpec instance) {
        RequestAuthenticationSpec requestAuthenticationSpec = instance = instance != null ? instance : new RequestAuthenticationSpec();
        if (instance != null) {
            this.withJwtRules(instance.getJwtRules());
            this.withSelector(instance.getSelector());
            this.withJwtRules(instance.getJwtRules());
            this.withSelector(instance.getSelector());
        }
    }

    public A addToJwtRules(int index, JWTRule item) {
        if (this.jwtRules == null) {
            this.jwtRules = new ArrayList();
        }
        JWTRuleBuilder builder = new JWTRuleBuilder(item);
        if (index < 0 || index >= this.jwtRules.size()) {
            this._visitables.get((Object)"jwtRules").add(builder);
            this.jwtRules.add(builder);
        } else {
            this._visitables.get((Object)"jwtRules").add(index, builder);
            this.jwtRules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToJwtRules(int index, JWTRule item) {
        if (this.jwtRules == null) {
            this.jwtRules = new ArrayList();
        }
        JWTRuleBuilder builder = new JWTRuleBuilder(item);
        if (index < 0 || index >= this.jwtRules.size()) {
            this._visitables.get((Object)"jwtRules").add(builder);
            this.jwtRules.add(builder);
        } else {
            this._visitables.get((Object)"jwtRules").set(index, builder);
            this.jwtRules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToJwtRules(JWTRule ... items) {
        if (this.jwtRules == null) {
            this.jwtRules = new ArrayList();
        }
        for (JWTRule item : items) {
            JWTRuleBuilder builder = new JWTRuleBuilder(item);
            this._visitables.get((Object)"jwtRules").add(builder);
            this.jwtRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToJwtRules(Collection<JWTRule> items) {
        if (this.jwtRules == null) {
            this.jwtRules = new ArrayList();
        }
        for (JWTRule item : items) {
            JWTRuleBuilder builder = new JWTRuleBuilder(item);
            this._visitables.get((Object)"jwtRules").add(builder);
            this.jwtRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromJwtRules(JWTRule ... items) {
        if (this.jwtRules == null) {
            return (A)((Object)this);
        }
        for (JWTRule item : items) {
            JWTRuleBuilder builder = new JWTRuleBuilder(item);
            this._visitables.get((Object)"jwtRules").remove((Object)builder);
            this.jwtRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromJwtRules(Collection<JWTRule> items) {
        if (this.jwtRules == null) {
            return (A)((Object)this);
        }
        for (JWTRule item : items) {
            JWTRuleBuilder builder = new JWTRuleBuilder(item);
            this._visitables.get((Object)"jwtRules").remove((Object)builder);
            this.jwtRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromJwtRules(Predicate<JWTRuleBuilder> predicate) {
        if (this.jwtRules == null) {
            return (A)((Object)this);
        }
        Iterator<JWTRuleBuilder> each = this.jwtRules.iterator();
        List visitables = this._visitables.get((Object)"jwtRules");
        while (each.hasNext()) {
            JWTRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<JWTRule> buildJwtRules() {
        return this.jwtRules != null ? RequestAuthenticationSpecFluent.build(this.jwtRules) : null;
    }

    public JWTRule buildJwtRule(int index) {
        return this.jwtRules.get(index).build();
    }

    public JWTRule buildFirstJwtRule() {
        return this.jwtRules.get(0).build();
    }

    public JWTRule buildLastJwtRule() {
        return this.jwtRules.get(this.jwtRules.size() - 1).build();
    }

    public JWTRule buildMatchingJwtRule(Predicate<JWTRuleBuilder> predicate) {
        for (JWTRuleBuilder item : this.jwtRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingJwtRule(Predicate<JWTRuleBuilder> predicate) {
        for (JWTRuleBuilder item : this.jwtRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withJwtRules(List<JWTRule> jwtRules) {
        if (this.jwtRules != null) {
            this._visitables.get((Object)"jwtRules").clear();
        }
        if (jwtRules != null) {
            this.jwtRules = new ArrayList();
            for (JWTRule item : jwtRules) {
                this.addToJwtRules(item);
            }
        } else {
            this.jwtRules = null;
        }
        return (A)((Object)this);
    }

    public A withJwtRules(JWTRule ... jwtRules) {
        if (this.jwtRules != null) {
            this.jwtRules.clear();
            this._visitables.remove((Object)"jwtRules");
        }
        if (jwtRules != null) {
            for (JWTRule item : jwtRules) {
                this.addToJwtRules(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasJwtRules() {
        return this.jwtRules != null && !this.jwtRules.isEmpty();
    }

    public JwtRulesNested<A> addNewJwtRule() {
        return new JwtRulesNested(-1, null);
    }

    public JwtRulesNested<A> addNewJwtRuleLike(JWTRule item) {
        return new JwtRulesNested(-1, item);
    }

    public JwtRulesNested<A> setNewJwtRuleLike(int index, JWTRule item) {
        return new JwtRulesNested(index, item);
    }

    public JwtRulesNested<A> editJwtRule(int index) {
        if (this.jwtRules.size() <= index) {
            throw new RuntimeException("Can't edit jwtRules. Index exceeds size.");
        }
        return this.setNewJwtRuleLike(index, this.buildJwtRule(index));
    }

    public JwtRulesNested<A> editFirstJwtRule() {
        if (this.jwtRules.size() == 0) {
            throw new RuntimeException("Can't edit first jwtRules. The list is empty.");
        }
        return this.setNewJwtRuleLike(0, this.buildJwtRule(0));
    }

    public JwtRulesNested<A> editLastJwtRule() {
        int index = this.jwtRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last jwtRules. The list is empty.");
        }
        return this.setNewJwtRuleLike(index, this.buildJwtRule(index));
    }

    public JwtRulesNested<A> editMatchingJwtRule(Predicate<JWTRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.jwtRules.size(); ++i) {
            if (!predicate.test(this.jwtRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching jwtRules. No match found.");
        }
        return this.setNewJwtRuleLike(index, this.buildJwtRule(index));
    }

    public WorkloadSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(WorkloadSelector selector) {
        this._visitables.get((Object)"selector").remove((Object)this.selector);
        if (selector != null) {
            this.selector = new WorkloadSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove((Object)this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public TypeSelectorNested<A> withNewTypeSelector() {
        return new TypeSelectorNested(null);
    }

    public TypeSelectorNested<A> withNewSelectorLike(WorkloadSelector item) {
        return new TypeSelectorNested(item);
    }

    public TypeSelectorNested<A> editTypeSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public TypeSelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new WorkloadSelectorBuilder().build()));
    }

    public TypeSelectorNested<A> editOrNewSelectorLike(WorkloadSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestAuthenticationSpecFluent that = (RequestAuthenticationSpecFluent)((Object)o);
        if (!Objects.equals(this.jwtRules, that.jwtRules)) {
            return false;
        }
        return Objects.equals((Object)this.selector, (Object)that.selector);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jwtRules, this.selector, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jwtRules != null && !this.jwtRules.isEmpty()) {
            sb.append("jwtRules:");
            sb.append(this.jwtRules + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append((Object)this.selector);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TypeSelectorNested<N>
    extends WorkloadSelectorFluent<TypeSelectorNested<N>>
    implements Nested<N> {
        WorkloadSelectorBuilder builder;

        TypeSelectorNested(WorkloadSelector item) {
            this.builder = new WorkloadSelectorBuilder(this, item);
        }

        public N and() {
            return (N)RequestAuthenticationSpecFluent.this.withSelector(this.builder.build());
        }

        public N endTypeSelector() {
            return this.and();
        }
    }

    public class JwtRulesNested<N>
    extends JWTRuleFluent<JwtRulesNested<N>>
    implements Nested<N> {
        JWTRuleBuilder builder;
        int index;

        JwtRulesNested(int index, JWTRule item) {
            this.index = index;
            this.builder = new JWTRuleBuilder(this, item);
        }

        public N and() {
            return (N)RequestAuthenticationSpecFluent.this.setToJwtRules(this.index, this.builder.build());
        }

        public N endJwtRule() {
            return this.and();
        }
    }
}

