/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.istio.api.networking.v1beta1.CaptureMode;
import io.fabric8.istio.api.networking.v1beta1.IstioEgressListener;
import io.fabric8.istio.api.networking.v1beta1.Port;
import io.fabric8.istio.api.networking.v1beta1.PortBuilder;
import io.fabric8.istio.api.networking.v1beta1.PortFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class IstioEgressListenerFluent<A extends IstioEgressListenerFluent<A>>
extends BaseFluent<A> {
    private String bind;
    private CaptureMode captureMode;
    private List<String> hosts = new ArrayList<String>();
    private PortBuilder port;

    public IstioEgressListenerFluent() {
    }

    public IstioEgressListenerFluent(IstioEgressListener instance) {
        IstioEgressListener istioEgressListener = instance = instance != null ? instance : new IstioEgressListener();
        if (instance != null) {
            this.withBind(instance.getBind());
            this.withCaptureMode(instance.getCaptureMode());
            this.withHosts(instance.getHosts());
            this.withPort(instance.getPort());
            this.withBind(instance.getBind());
            this.withCaptureMode(instance.getCaptureMode());
            this.withHosts(instance.getHosts());
            this.withPort(instance.getPort());
        }
    }

    public String getBind() {
        return this.bind;
    }

    public A withBind(String bind) {
        this.bind = bind;
        return (A)((Object)this);
    }

    public boolean hasBind() {
        return this.bind != null;
    }

    public CaptureMode getCaptureMode() {
        return this.captureMode;
    }

    public A withCaptureMode(CaptureMode captureMode) {
        this.captureMode = captureMode;
        return (A)((Object)this);
    }

    public boolean hasCaptureMode() {
        return this.captureMode != null;
    }

    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)((Object)this);
    }

    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)((Object)this);
    }

    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromHosts(String ... items) {
        if (this.hosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHosts(Collection<String> items) {
        if (this.hosts == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.hosts.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public String getHost(int index) {
        return this.hosts.get(index);
    }

    public String getFirstHost() {
        return this.hosts.get(0);
    }

    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHosts(List<String> hosts) {
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)((Object)this);
    }

    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
            this._visitables.remove((Object)"hosts");
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    public Port buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    public A withPort(Port port) {
        this._visitables.get((Object)"port").remove((Object)this.port);
        if (port != null) {
            this.port = new PortBuilder(port);
            this._visitables.get((Object)"port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get((Object)"port").remove((Object)this.port);
        }
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(String name, Integer number, String protocol, Integer targetPort) {
        return this.withPort(new Port(name, number, protocol, targetPort));
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public PortNested<A> withNewPortLike(Port item) {
        return new PortNested(item);
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new PortBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(Port item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IstioEgressListenerFluent that = (IstioEgressListenerFluent)((Object)o);
        if (!Objects.equals(this.bind, that.bind)) {
            return false;
        }
        if (!Objects.equals((Object)this.captureMode, (Object)that.captureMode)) {
            return false;
        }
        if (!Objects.equals(this.hosts, that.hosts)) {
            return false;
        }
        return Objects.equals((Object)this.port, (Object)that.port);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bind, this.captureMode, this.hosts, this.port, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bind != null) {
            sb.append("bind:");
            sb.append(this.bind + ",");
        }
        if (this.captureMode != null) {
            sb.append("captureMode:");
            sb.append((Object)((Object)this.captureMode) + ",");
        }
        if (this.hosts != null && !this.hosts.isEmpty()) {
            sb.append("hosts:");
            sb.append(this.hosts + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append((Object)this.port);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortNested<N>
    extends PortFluent<PortNested<N>>
    implements Nested<N> {
        PortBuilder builder;

        PortNested(Port item) {
            this.builder = new PortBuilder(this, item);
        }

        public N and() {
            return (N)IstioEgressListenerFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

