/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.istio.api.networking.v1beta1.HTTPMatchRequest;
import io.fabric8.istio.api.networking.v1beta1.StringMatch;
import io.fabric8.istio.api.networking.v1beta1.StringMatchBuilder;
import io.fabric8.istio.api.networking.v1beta1.StringMatchFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class HTTPMatchRequestFluent<A extends HTTPMatchRequestFluent<A>>
extends BaseFluent<A> {
    private StringMatchBuilder authority;
    private List<String> gateways = new ArrayList<String>();
    private Map<String, StringMatch> headers;
    private Boolean ignoreUriCase;
    private StringMatchBuilder method;
    private String name;
    private Integer port;
    private Map<String, StringMatch> queryParams;
    private StringMatchBuilder scheme;
    private Map<String, String> sourceLabels;
    private String sourceNamespace;
    private StringMatchBuilder uri;
    private Map<String, StringMatch> withoutHeaders;

    public HTTPMatchRequestFluent() {
    }

    public HTTPMatchRequestFluent(HTTPMatchRequest instance) {
        HTTPMatchRequest hTTPMatchRequest = instance = instance != null ? instance : new HTTPMatchRequest();
        if (instance != null) {
            this.withAuthority(instance.getAuthority());
            this.withGateways(instance.getGateways());
            this.withHeaders(instance.getHeaders());
            this.withIgnoreUriCase(instance.getIgnoreUriCase());
            this.withMethod(instance.getMethod());
            this.withName(instance.getName());
            this.withPort(instance.getPort());
            this.withQueryParams(instance.getQueryParams());
            this.withScheme(instance.getScheme());
            this.withSourceLabels(instance.getSourceLabels());
            this.withSourceNamespace(instance.getSourceNamespace());
            this.withUri(instance.getUri());
            this.withWithoutHeaders(instance.getWithoutHeaders());
            this.withAuthority(instance.getAuthority());
            this.withGateways(instance.getGateways());
            this.withHeaders(instance.getHeaders());
            this.withIgnoreUriCase(instance.getIgnoreUriCase());
            this.withMethod(instance.getMethod());
            this.withName(instance.getName());
            this.withPort(instance.getPort());
            this.withQueryParams(instance.getQueryParams());
            this.withScheme(instance.getScheme());
            this.withSourceLabels(instance.getSourceLabels());
            this.withSourceNamespace(instance.getSourceNamespace());
            this.withUri(instance.getUri());
            this.withWithoutHeaders(instance.getWithoutHeaders());
        }
    }

    public StringMatch buildAuthority() {
        return this.authority != null ? this.authority.build() : null;
    }

    public A withAuthority(StringMatch authority) {
        this._visitables.get((Object)"authority").remove((Object)this.authority);
        if (authority != null) {
            this.authority = new StringMatchBuilder(authority);
            this._visitables.get((Object)"authority").add(this.authority);
        } else {
            this.authority = null;
            this._visitables.get((Object)"authority").remove((Object)this.authority);
        }
        return (A)((Object)this);
    }

    public boolean hasAuthority() {
        return this.authority != null;
    }

    public AuthorityNested<A> withNewAuthority() {
        return new AuthorityNested(null);
    }

    public AuthorityNested<A> withNewAuthorityLike(StringMatch item) {
        return new AuthorityNested(item);
    }

    public AuthorityNested<A> editAuthority() {
        return this.withNewAuthorityLike(Optional.ofNullable(this.buildAuthority()).orElse(null));
    }

    public AuthorityNested<A> editOrNewAuthority() {
        return this.withNewAuthorityLike(Optional.ofNullable(this.buildAuthority()).orElse(new StringMatchBuilder().build()));
    }

    public AuthorityNested<A> editOrNewAuthorityLike(StringMatch item) {
        return this.withNewAuthorityLike(Optional.ofNullable(this.buildAuthority()).orElse(item));
    }

    public A addToGateways(int index, String item) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        this.gateways.add(index, item);
        return (A)((Object)this);
    }

    public A setToGateways(int index, String item) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        this.gateways.set(index, item);
        return (A)((Object)this);
    }

    public A addToGateways(String ... items) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        for (String item : items) {
            this.gateways.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToGateways(Collection<String> items) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        for (String item : items) {
            this.gateways.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromGateways(String ... items) {
        if (this.gateways == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.gateways.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromGateways(Collection<String> items) {
        if (this.gateways == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.gateways.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getGateways() {
        return this.gateways;
    }

    public String getGateway(int index) {
        return this.gateways.get(index);
    }

    public String getFirstGateway() {
        return this.gateways.get(0);
    }

    public String getLastGateway() {
        return this.gateways.get(this.gateways.size() - 1);
    }

    public String getMatchingGateway(Predicate<String> predicate) {
        for (String item : this.gateways) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGateway(Predicate<String> predicate) {
        for (String item : this.gateways) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGateways(List<String> gateways) {
        if (gateways != null) {
            this.gateways = new ArrayList<String>();
            for (String item : gateways) {
                this.addToGateways(item);
            }
        } else {
            this.gateways = null;
        }
        return (A)((Object)this);
    }

    public A withGateways(String ... gateways) {
        if (this.gateways != null) {
            this.gateways.clear();
            this._visitables.remove((Object)"gateways");
        }
        if (gateways != null) {
            for (String item : gateways) {
                this.addToGateways(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasGateways() {
        return this.gateways != null && !this.gateways.isEmpty();
    }

    public A addToHeaders(String key, StringMatch value) {
        if (this.headers == null && key != null && value != null) {
            this.headers = new LinkedHashMap<String, StringMatch>();
        }
        if (key != null && value != null) {
            this.headers.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToHeaders(Map<String, StringMatch> map) {
        if (this.headers == null && map != null) {
            this.headers = new LinkedHashMap<String, StringMatch>();
        }
        if (map != null) {
            this.headers.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromHeaders(String key) {
        if (this.headers == null) {
            return (A)((Object)this);
        }
        if (key != null && this.headers != null) {
            this.headers.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromHeaders(Map<String, StringMatch> map) {
        if (this.headers == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.headers == null) continue;
                this.headers.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, StringMatch> getHeaders() {
        return this.headers;
    }

    public <K, V> A withHeaders(Map<String, StringMatch> headers) {
        this.headers = headers == null ? null : new LinkedHashMap<String, StringMatch>(headers);
        return (A)((Object)this);
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public Boolean getIgnoreUriCase() {
        return this.ignoreUriCase;
    }

    public A withIgnoreUriCase(Boolean ignoreUriCase) {
        this.ignoreUriCase = ignoreUriCase;
        return (A)((Object)this);
    }

    public boolean hasIgnoreUriCase() {
        return this.ignoreUriCase != null;
    }

    public StringMatch buildMethod() {
        return this.method != null ? this.method.build() : null;
    }

    public A withMethod(StringMatch method) {
        this._visitables.get((Object)"method").remove((Object)this.method);
        if (method != null) {
            this.method = new StringMatchBuilder(method);
            this._visitables.get((Object)"method").add(this.method);
        } else {
            this.method = null;
            this._visitables.get((Object)"method").remove((Object)this.method);
        }
        return (A)((Object)this);
    }

    public boolean hasMethod() {
        return this.method != null;
    }

    public MethodNested<A> withNewMethod() {
        return new MethodNested(null);
    }

    public MethodNested<A> withNewMethodLike(StringMatch item) {
        return new MethodNested(item);
    }

    public MethodNested<A> editMethod() {
        return this.withNewMethodLike(Optional.ofNullable(this.buildMethod()).orElse(null));
    }

    public MethodNested<A> editOrNewMethod() {
        return this.withNewMethodLike(Optional.ofNullable(this.buildMethod()).orElse(new StringMatchBuilder().build()));
    }

    public MethodNested<A> editOrNewMethodLike(StringMatch item) {
        return this.withNewMethodLike(Optional.ofNullable(this.buildMethod()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A addToQueryParams(String key, StringMatch value) {
        if (this.queryParams == null && key != null && value != null) {
            this.queryParams = new LinkedHashMap<String, StringMatch>();
        }
        if (key != null && value != null) {
            this.queryParams.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToQueryParams(Map<String, StringMatch> map) {
        if (this.queryParams == null && map != null) {
            this.queryParams = new LinkedHashMap<String, StringMatch>();
        }
        if (map != null) {
            this.queryParams.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromQueryParams(String key) {
        if (this.queryParams == null) {
            return (A)((Object)this);
        }
        if (key != null && this.queryParams != null) {
            this.queryParams.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromQueryParams(Map<String, StringMatch> map) {
        if (this.queryParams == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.queryParams == null) continue;
                this.queryParams.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, StringMatch> getQueryParams() {
        return this.queryParams;
    }

    public <K, V> A withQueryParams(Map<String, StringMatch> queryParams) {
        this.queryParams = queryParams == null ? null : new LinkedHashMap<String, StringMatch>(queryParams);
        return (A)((Object)this);
    }

    public boolean hasQueryParams() {
        return this.queryParams != null;
    }

    public StringMatch buildScheme() {
        return this.scheme != null ? this.scheme.build() : null;
    }

    public A withScheme(StringMatch scheme) {
        this._visitables.get((Object)"scheme").remove((Object)this.scheme);
        if (scheme != null) {
            this.scheme = new StringMatchBuilder(scheme);
            this._visitables.get((Object)"scheme").add(this.scheme);
        } else {
            this.scheme = null;
            this._visitables.get((Object)"scheme").remove((Object)this.scheme);
        }
        return (A)((Object)this);
    }

    public boolean hasScheme() {
        return this.scheme != null;
    }

    public SchemeNested<A> withNewScheme() {
        return new SchemeNested(null);
    }

    public SchemeNested<A> withNewSchemeLike(StringMatch item) {
        return new SchemeNested(item);
    }

    public SchemeNested<A> editScheme() {
        return this.withNewSchemeLike(Optional.ofNullable(this.buildScheme()).orElse(null));
    }

    public SchemeNested<A> editOrNewScheme() {
        return this.withNewSchemeLike(Optional.ofNullable(this.buildScheme()).orElse(new StringMatchBuilder().build()));
    }

    public SchemeNested<A> editOrNewSchemeLike(StringMatch item) {
        return this.withNewSchemeLike(Optional.ofNullable(this.buildScheme()).orElse(item));
    }

    public A addToSourceLabels(String key, String value) {
        if (this.sourceLabels == null && key != null && value != null) {
            this.sourceLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.sourceLabels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSourceLabels(Map<String, String> map) {
        if (this.sourceLabels == null && map != null) {
            this.sourceLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.sourceLabels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromSourceLabels(String key) {
        if (this.sourceLabels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.sourceLabels != null) {
            this.sourceLabels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromSourceLabels(Map<String, String> map) {
        if (this.sourceLabels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.sourceLabels == null) continue;
                this.sourceLabels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getSourceLabels() {
        return this.sourceLabels;
    }

    public <K, V> A withSourceLabels(Map<String, String> sourceLabels) {
        this.sourceLabels = sourceLabels == null ? null : new LinkedHashMap<String, String>(sourceLabels);
        return (A)((Object)this);
    }

    public boolean hasSourceLabels() {
        return this.sourceLabels != null;
    }

    public String getSourceNamespace() {
        return this.sourceNamespace;
    }

    public A withSourceNamespace(String sourceNamespace) {
        this.sourceNamespace = sourceNamespace;
        return (A)((Object)this);
    }

    public boolean hasSourceNamespace() {
        return this.sourceNamespace != null;
    }

    public StringMatch buildUri() {
        return this.uri != null ? this.uri.build() : null;
    }

    public A withUri(StringMatch uri) {
        this._visitables.get((Object)"uri").remove((Object)this.uri);
        if (uri != null) {
            this.uri = new StringMatchBuilder(uri);
            this._visitables.get((Object)"uri").add(this.uri);
        } else {
            this.uri = null;
            this._visitables.get((Object)"uri").remove((Object)this.uri);
        }
        return (A)((Object)this);
    }

    public boolean hasUri() {
        return this.uri != null;
    }

    public UriNested<A> withNewUri() {
        return new UriNested(null);
    }

    public UriNested<A> withNewUriLike(StringMatch item) {
        return new UriNested(item);
    }

    public UriNested<A> editUri() {
        return this.withNewUriLike(Optional.ofNullable(this.buildUri()).orElse(null));
    }

    public UriNested<A> editOrNewUri() {
        return this.withNewUriLike(Optional.ofNullable(this.buildUri()).orElse(new StringMatchBuilder().build()));
    }

    public UriNested<A> editOrNewUriLike(StringMatch item) {
        return this.withNewUriLike(Optional.ofNullable(this.buildUri()).orElse(item));
    }

    public A addToWithoutHeaders(String key, StringMatch value) {
        if (this.withoutHeaders == null && key != null && value != null) {
            this.withoutHeaders = new LinkedHashMap<String, StringMatch>();
        }
        if (key != null && value != null) {
            this.withoutHeaders.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToWithoutHeaders(Map<String, StringMatch> map) {
        if (this.withoutHeaders == null && map != null) {
            this.withoutHeaders = new LinkedHashMap<String, StringMatch>();
        }
        if (map != null) {
            this.withoutHeaders.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromWithoutHeaders(String key) {
        if (this.withoutHeaders == null) {
            return (A)((Object)this);
        }
        if (key != null && this.withoutHeaders != null) {
            this.withoutHeaders.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromWithoutHeaders(Map<String, StringMatch> map) {
        if (this.withoutHeaders == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.withoutHeaders == null) continue;
                this.withoutHeaders.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, StringMatch> getWithoutHeaders() {
        return this.withoutHeaders;
    }

    public <K, V> A withWithoutHeaders(Map<String, StringMatch> withoutHeaders) {
        this.withoutHeaders = withoutHeaders == null ? null : new LinkedHashMap<String, StringMatch>(withoutHeaders);
        return (A)((Object)this);
    }

    public boolean hasWithoutHeaders() {
        return this.withoutHeaders != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPMatchRequestFluent that = (HTTPMatchRequestFluent)((Object)o);
        if (!Objects.equals((Object)this.authority, (Object)that.authority)) {
            return false;
        }
        if (!Objects.equals(this.gateways, that.gateways)) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.ignoreUriCase, that.ignoreUriCase)) {
            return false;
        }
        if (!Objects.equals((Object)this.method, (Object)that.method)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.queryParams, that.queryParams)) {
            return false;
        }
        if (!Objects.equals((Object)this.scheme, (Object)that.scheme)) {
            return false;
        }
        if (!Objects.equals(this.sourceLabels, that.sourceLabels)) {
            return false;
        }
        if (!Objects.equals(this.sourceNamespace, that.sourceNamespace)) {
            return false;
        }
        if (!Objects.equals((Object)this.uri, (Object)that.uri)) {
            return false;
        }
        return Objects.equals(this.withoutHeaders, that.withoutHeaders);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authority, this.gateways, this.headers, this.ignoreUriCase, this.method, this.name, this.port, this.queryParams, this.scheme, this.sourceLabels, this.sourceNamespace, this.uri, this.withoutHeaders, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authority != null) {
            sb.append("authority:");
            sb.append((Object)((Object)this.authority) + ",");
        }
        if (this.gateways != null && !this.gateways.isEmpty()) {
            sb.append("gateways:");
            sb.append(this.gateways + ",");
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.ignoreUriCase != null) {
            sb.append("ignoreUriCase:");
            sb.append(this.ignoreUriCase + ",");
        }
        if (this.method != null) {
            sb.append("method:");
            sb.append((Object)((Object)this.method) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            sb.append("queryParams:");
            sb.append(this.queryParams + ",");
        }
        if (this.scheme != null) {
            sb.append("scheme:");
            sb.append((Object)((Object)this.scheme) + ",");
        }
        if (this.sourceLabels != null && !this.sourceLabels.isEmpty()) {
            sb.append("sourceLabels:");
            sb.append(this.sourceLabels + ",");
        }
        if (this.sourceNamespace != null) {
            sb.append("sourceNamespace:");
            sb.append(this.sourceNamespace + ",");
        }
        if (this.uri != null) {
            sb.append("uri:");
            sb.append((Object)((Object)this.uri) + ",");
        }
        if (this.withoutHeaders != null && !this.withoutHeaders.isEmpty()) {
            sb.append("withoutHeaders:");
            sb.append(this.withoutHeaders);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIgnoreUriCase() {
        return this.withIgnoreUriCase(true);
    }

    public class UriNested<N>
    extends StringMatchFluent<UriNested<N>>
    implements Nested<N> {
        StringMatchBuilder builder;

        UriNested(StringMatch item) {
            this.builder = new StringMatchBuilder(this, item);
        }

        public N and() {
            return (N)HTTPMatchRequestFluent.this.withUri(this.builder.build());
        }

        public N endUri() {
            return this.and();
        }
    }

    public class SchemeNested<N>
    extends StringMatchFluent<SchemeNested<N>>
    implements Nested<N> {
        StringMatchBuilder builder;

        SchemeNested(StringMatch item) {
            this.builder = new StringMatchBuilder(this, item);
        }

        public N and() {
            return (N)HTTPMatchRequestFluent.this.withScheme(this.builder.build());
        }

        public N endScheme() {
            return this.and();
        }
    }

    public class MethodNested<N>
    extends StringMatchFluent<MethodNested<N>>
    implements Nested<N> {
        StringMatchBuilder builder;

        MethodNested(StringMatch item) {
            this.builder = new StringMatchBuilder(this, item);
        }

        public N and() {
            return (N)HTTPMatchRequestFluent.this.withMethod(this.builder.build());
        }

        public N endMethod() {
            return this.and();
        }
    }

    public class AuthorityNested<N>
    extends StringMatchFluent<AuthorityNested<N>>
    implements Nested<N> {
        StringMatchBuilder builder;

        AuthorityNested(StringMatch item) {
            this.builder = new StringMatchBuilder(this, item);
        }

        public N and() {
            return (N)HTTPMatchRequestFluent.this.withAuthority(this.builder.build());
        }

        public N endAuthority() {
            return this.and();
        }
    }
}

