/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.istio.api.networking.v1beta1.GatewaySpec;
import io.fabric8.istio.api.networking.v1beta1.Server;
import io.fabric8.istio.api.networking.v1beta1.ServerBuilder;
import io.fabric8.istio.api.networking.v1beta1.ServerFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GatewaySpecFluent<A extends GatewaySpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> selector;
    private ArrayList<ServerBuilder> servers = new ArrayList();

    public GatewaySpecFluent() {
    }

    public GatewaySpecFluent(GatewaySpec instance) {
        GatewaySpec gatewaySpec = instance = instance != null ? instance : new GatewaySpec();
        if (instance != null) {
            this.withSelector(instance.getSelector());
            this.withServers(instance.getServers());
            this.withSelector(instance.getSelector());
            this.withServers(instance.getServers());
        }
    }

    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getSelector() {
        return this.selector;
    }

    public <K, V> A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? null : new LinkedHashMap<String, String>(selector);
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public A addToServers(int index, Server item) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        ServerBuilder builder = new ServerBuilder(item);
        if (index < 0 || index >= this.servers.size()) {
            this._visitables.get((Object)"servers").add(builder);
            this.servers.add(builder);
        } else {
            this._visitables.get((Object)"servers").add(index, builder);
            this.servers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToServers(int index, Server item) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        ServerBuilder builder = new ServerBuilder(item);
        if (index < 0 || index >= this.servers.size()) {
            this._visitables.get((Object)"servers").add(builder);
            this.servers.add(builder);
        } else {
            this._visitables.get((Object)"servers").set(index, builder);
            this.servers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToServers(Server ... items) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").add(builder);
            this.servers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToServers(Collection<Server> items) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").add(builder);
            this.servers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromServers(Server ... items) {
        if (this.servers == null) {
            return (A)((Object)this);
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").remove((Object)builder);
            this.servers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServers(Collection<Server> items) {
        if (this.servers == null) {
            return (A)((Object)this);
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get((Object)"servers").remove((Object)builder);
            this.servers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromServers(Predicate<ServerBuilder> predicate) {
        if (this.servers == null) {
            return (A)((Object)this);
        }
        Iterator<ServerBuilder> each = this.servers.iterator();
        List visitables = this._visitables.get((Object)"servers");
        while (each.hasNext()) {
            ServerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Server> buildServers() {
        return this.servers != null ? GatewaySpecFluent.build(this.servers) : null;
    }

    public Server buildServer(int index) {
        return this.servers.get(index).build();
    }

    public Server buildFirstServer() {
        return this.servers.get(0).build();
    }

    public Server buildLastServer() {
        return this.servers.get(this.servers.size() - 1).build();
    }

    public Server buildMatchingServer(Predicate<ServerBuilder> predicate) {
        for (ServerBuilder item : this.servers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingServer(Predicate<ServerBuilder> predicate) {
        for (ServerBuilder item : this.servers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServers(List<Server> servers) {
        if (this.servers != null) {
            this._visitables.get((Object)"servers").clear();
        }
        if (servers != null) {
            this.servers = new ArrayList();
            for (Server item : servers) {
                this.addToServers(item);
            }
        } else {
            this.servers = null;
        }
        return (A)((Object)this);
    }

    public A withServers(Server ... servers) {
        if (this.servers != null) {
            this.servers.clear();
            this._visitables.remove((Object)"servers");
        }
        if (servers != null) {
            for (Server item : servers) {
                this.addToServers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasServers() {
        return this.servers != null && !this.servers.isEmpty();
    }

    public ServersNested<A> addNewServer() {
        return new ServersNested(-1, null);
    }

    public ServersNested<A> addNewServerLike(Server item) {
        return new ServersNested(-1, item);
    }

    public ServersNested<A> setNewServerLike(int index, Server item) {
        return new ServersNested(index, item);
    }

    public ServersNested<A> editServer(int index) {
        if (this.servers.size() <= index) {
            throw new RuntimeException("Can't edit servers. Index exceeds size.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    public ServersNested<A> editFirstServer() {
        if (this.servers.size() == 0) {
            throw new RuntimeException("Can't edit first servers. The list is empty.");
        }
        return this.setNewServerLike(0, this.buildServer(0));
    }

    public ServersNested<A> editLastServer() {
        int index = this.servers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last servers. The list is empty.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    public ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!predicate.test(this.servers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching servers. No match found.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GatewaySpecFluent that = (GatewaySpecFluent)((Object)o);
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        return Objects.equals(this.servers, that.servers);
    }

    public int hashCode() {
        return Objects.hash(this.selector, this.servers, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.selector != null && !this.selector.isEmpty()) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.servers != null && !this.servers.isEmpty()) {
            sb.append("servers:");
            sb.append(this.servers);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServersNested<N>
    extends ServerFluent<ServersNested<N>>
    implements Nested<N> {
        ServerBuilder builder;
        int index;

        ServersNested(int index, Server item) {
            this.index = index;
            this.builder = new ServerBuilder(this, item);
        }

        public N and() {
            return (N)GatewaySpecFluent.this.setToServers(this.index, this.builder.build());
        }

        public N endServer() {
            return this.and();
        }
    }
}

