package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuleToBuilder extends RuleToFluent<RuleToBuilder> implements VisitableBuilder<RuleTo,RuleToBuilder>{
  public RuleToBuilder() {
    this(false);
  }
  public RuleToBuilder(Boolean validationEnabled) {
    this(new RuleTo(), validationEnabled);
  }
  public RuleToBuilder(RuleToFluent<?> fluent) {
    this(fluent, false);
  }
  public RuleToBuilder(RuleToFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RuleTo(), validationEnabled);
  }
  public RuleToBuilder(RuleToFluent<?> fluent,RuleTo instance) {
    this(fluent, instance, false);
  }
  public RuleToBuilder(RuleToFluent<?> fluent,RuleTo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RuleTo());

    if (instance != null) {
      fluent.withOperation(instance.getOperation());
      fluent.withOperation(instance.getOperation());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RuleToBuilder(RuleTo instance) {
    this(instance,false);
  }
  public RuleToBuilder(RuleTo instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RuleTo());

    if (instance != null) {
      this.withOperation(instance.getOperation());
      this.withOperation(instance.getOperation());
    }
    this.validationEnabled = validationEnabled; 
  }
  RuleToFluent<?> fluent;
  Boolean validationEnabled;
  public RuleTo build() {
    RuleTo buildable = new RuleTo(fluent.buildOperation());
    return buildable;
  }
  
}