package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RequestAuthenticationBuilder extends RequestAuthenticationFluent<RequestAuthenticationBuilder> implements VisitableBuilder<RequestAuthentication,RequestAuthenticationBuilder>{
  public RequestAuthenticationBuilder() {
    this(false);
  }
  public RequestAuthenticationBuilder(Boolean validationEnabled) {
    this(new RequestAuthentication(), validationEnabled);
  }
  public RequestAuthenticationBuilder(RequestAuthenticationFluent<?> fluent) {
    this(fluent, false);
  }
  public RequestAuthenticationBuilder(RequestAuthenticationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RequestAuthentication(), validationEnabled);
  }
  public RequestAuthenticationBuilder(RequestAuthenticationFluent<?> fluent,RequestAuthentication instance) {
    this(fluent, instance, false);
  }
  public RequestAuthenticationBuilder(RequestAuthenticationFluent<?> fluent,RequestAuthentication instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RequestAuthentication());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RequestAuthenticationBuilder(RequestAuthentication instance) {
    this(instance,false);
  }
  public RequestAuthenticationBuilder(RequestAuthentication instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RequestAuthentication());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  RequestAuthenticationFluent<?> fluent;
  Boolean validationEnabled;
  public RequestAuthentication build() {
    RequestAuthentication buildable = new RequestAuthentication(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.getStatus());
    return buildable;
  }
  
}