package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JWTRuleBuilder extends JWTRuleFluent<JWTRuleBuilder> implements VisitableBuilder<JWTRule,JWTRuleBuilder>{
  public JWTRuleBuilder() {
    this(false);
  }
  public JWTRuleBuilder(Boolean validationEnabled) {
    this(new JWTRule(), validationEnabled);
  }
  public JWTRuleBuilder(JWTRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public JWTRuleBuilder(JWTRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JWTRule(), validationEnabled);
  }
  public JWTRuleBuilder(JWTRuleFluent<?> fluent,JWTRule instance) {
    this(fluent, instance, false);
  }
  public JWTRuleBuilder(JWTRuleFluent<?> fluent,JWTRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new JWTRule());

    if (instance != null) {
      fluent.withAudiences(instance.getAudiences());
      fluent.withForwardOriginalToken(instance.getForwardOriginalToken());
      fluent.withFromHeaders(instance.getFromHeaders());
      fluent.withFromParams(instance.getFromParams());
      fluent.withIssuer(instance.getIssuer());
      fluent.withJwks(instance.getJwks());
      fluent.withJwksUri(instance.getJwksUri());
      fluent.withOutputPayloadToHeader(instance.getOutputPayloadToHeader());
      fluent.withAudiences(instance.getAudiences());
      fluent.withForwardOriginalToken(instance.getForwardOriginalToken());
      fluent.withFromHeaders(instance.getFromHeaders());
      fluent.withFromParams(instance.getFromParams());
      fluent.withIssuer(instance.getIssuer());
      fluent.withJwks(instance.getJwks());
      fluent.withJwksUri(instance.getJwksUri());
      fluent.withOutputPayloadToHeader(instance.getOutputPayloadToHeader());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JWTRuleBuilder(JWTRule instance) {
    this(instance,false);
  }
  public JWTRuleBuilder(JWTRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new JWTRule());

    if (instance != null) {
      this.withAudiences(instance.getAudiences());
      this.withForwardOriginalToken(instance.getForwardOriginalToken());
      this.withFromHeaders(instance.getFromHeaders());
      this.withFromParams(instance.getFromParams());
      this.withIssuer(instance.getIssuer());
      this.withJwks(instance.getJwks());
      this.withJwksUri(instance.getJwksUri());
      this.withOutputPayloadToHeader(instance.getOutputPayloadToHeader());
      this.withAudiences(instance.getAudiences());
      this.withForwardOriginalToken(instance.getForwardOriginalToken());
      this.withFromHeaders(instance.getFromHeaders());
      this.withFromParams(instance.getFromParams());
      this.withIssuer(instance.getIssuer());
      this.withJwks(instance.getJwks());
      this.withJwksUri(instance.getJwksUri());
      this.withOutputPayloadToHeader(instance.getOutputPayloadToHeader());
    }
    this.validationEnabled = validationEnabled; 
  }
  JWTRuleFluent<?> fluent;
  Boolean validationEnabled;
  public JWTRule build() {
    JWTRule buildable = new JWTRule(fluent.getAudiences(),fluent.getForwardOriginalToken(),fluent.buildFromHeaders(),fluent.getFromParams(),fluent.getIssuer(),fluent.getJwks(),fluent.getJwksUri(),fluent.getOutputPayloadToHeader());
    return buildable;
  }
  
}