package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkloadEntryListBuilder extends WorkloadEntryListFluent<WorkloadEntryListBuilder> implements VisitableBuilder<WorkloadEntryList,WorkloadEntryListBuilder>{
  public WorkloadEntryListBuilder() {
    this(false);
  }
  public WorkloadEntryListBuilder(Boolean validationEnabled) {
    this(new WorkloadEntryList(), validationEnabled);
  }
  public WorkloadEntryListBuilder(WorkloadEntryListFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkloadEntryListBuilder(WorkloadEntryListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkloadEntryList(), validationEnabled);
  }
  public WorkloadEntryListBuilder(WorkloadEntryListFluent<?> fluent,WorkloadEntryList instance) {
    this(fluent, instance, false);
  }
  public WorkloadEntryListBuilder(WorkloadEntryListFluent<?> fluent,WorkloadEntryList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WorkloadEntryList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WorkloadEntryListBuilder(WorkloadEntryList instance) {
    this(instance,false);
  }
  public WorkloadEntryListBuilder(WorkloadEntryList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WorkloadEntryList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  WorkloadEntryListFluent<?> fluent;
  Boolean validationEnabled;
  public WorkloadEntryList build() {
    WorkloadEntryList buildable = new WorkloadEntryList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}