package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubsetBuilder extends SubsetFluent<SubsetBuilder> implements VisitableBuilder<Subset,SubsetBuilder>{
  public SubsetBuilder() {
    this(false);
  }
  public SubsetBuilder(Boolean validationEnabled) {
    this(new Subset(), validationEnabled);
  }
  public SubsetBuilder(SubsetFluent<?> fluent) {
    this(fluent, false);
  }
  public SubsetBuilder(SubsetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Subset(), validationEnabled);
  }
  public SubsetBuilder(SubsetFluent<?> fluent,Subset instance) {
    this(fluent, instance, false);
  }
  public SubsetBuilder(SubsetFluent<?> fluent,Subset instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Subset());

    if (instance != null) {
      fluent.withLabels(instance.getLabels());
      fluent.withName(instance.getName());
      fluent.withTrafficPolicy(instance.getTrafficPolicy());
      fluent.withLabels(instance.getLabels());
      fluent.withName(instance.getName());
      fluent.withTrafficPolicy(instance.getTrafficPolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubsetBuilder(Subset instance) {
    this(instance,false);
  }
  public SubsetBuilder(Subset instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Subset());

    if (instance != null) {
      this.withLabels(instance.getLabels());
      this.withName(instance.getName());
      this.withTrafficPolicy(instance.getTrafficPolicy());
      this.withLabels(instance.getLabels());
      this.withName(instance.getName());
      this.withTrafficPolicy(instance.getTrafficPolicy());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubsetFluent<?> fluent;
  Boolean validationEnabled;
  public Subset build() {
    Subset buildable = new Subset(fluent.getLabels(),fluent.getName(),fluent.buildTrafficPolicy());
    return buildable;
  }
  
}