package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServerBuilder extends ServerFluent<ServerBuilder> implements VisitableBuilder<Server,ServerBuilder>{
  public ServerBuilder() {
    this(false);
  }
  public ServerBuilder(Boolean validationEnabled) {
    this(new Server(), validationEnabled);
  }
  public ServerBuilder(ServerFluent<?> fluent) {
    this(fluent, false);
  }
  public ServerBuilder(ServerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Server(), validationEnabled);
  }
  public ServerBuilder(ServerFluent<?> fluent,Server instance) {
    this(fluent, instance, false);
  }
  public ServerBuilder(ServerFluent<?> fluent,Server instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Server());

    if (instance != null) {
      fluent.withBind(instance.getBind());
      fluent.withDefaultEndpoint(instance.getDefaultEndpoint());
      fluent.withHosts(instance.getHosts());
      fluent.withName(instance.getName());
      fluent.withPort(instance.getPort());
      fluent.withTls(instance.getTls());
      fluent.withBind(instance.getBind());
      fluent.withDefaultEndpoint(instance.getDefaultEndpoint());
      fluent.withHosts(instance.getHosts());
      fluent.withName(instance.getName());
      fluent.withPort(instance.getPort());
      fluent.withTls(instance.getTls());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServerBuilder(Server instance) {
    this(instance,false);
  }
  public ServerBuilder(Server instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Server());

    if (instance != null) {
      this.withBind(instance.getBind());
      this.withDefaultEndpoint(instance.getDefaultEndpoint());
      this.withHosts(instance.getHosts());
      this.withName(instance.getName());
      this.withPort(instance.getPort());
      this.withTls(instance.getTls());
      this.withBind(instance.getBind());
      this.withDefaultEndpoint(instance.getDefaultEndpoint());
      this.withHosts(instance.getHosts());
      this.withName(instance.getName());
      this.withPort(instance.getPort());
      this.withTls(instance.getTls());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServerFluent<?> fluent;
  Boolean validationEnabled;
  public Server build() {
    Server buildable = new Server(fluent.getBind(),fluent.getDefaultEndpoint(),fluent.getHosts(),fluent.getName(),fluent.buildPort(),fluent.buildTls());
    return buildable;
  }
  
}