package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PortBuilder extends PortFluent<PortBuilder> implements VisitableBuilder<Port,PortBuilder>{
  public PortBuilder() {
    this(false);
  }
  public PortBuilder(Boolean validationEnabled) {
    this(new Port(), validationEnabled);
  }
  public PortBuilder(PortFluent<?> fluent) {
    this(fluent, false);
  }
  public PortBuilder(PortFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Port(), validationEnabled);
  }
  public PortBuilder(PortFluent<?> fluent,Port instance) {
    this(fluent, instance, false);
  }
  public PortBuilder(PortFluent<?> fluent,Port instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Port());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNumber(instance.getNumber());
      fluent.withProtocol(instance.getProtocol());
      fluent.withTargetPort(instance.getTargetPort());
      fluent.withName(instance.getName());
      fluent.withNumber(instance.getNumber());
      fluent.withProtocol(instance.getProtocol());
      fluent.withTargetPort(instance.getTargetPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PortBuilder(Port instance) {
    this(instance,false);
  }
  public PortBuilder(Port instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Port());

    if (instance != null) {
      this.withName(instance.getName());
      this.withNumber(instance.getNumber());
      this.withProtocol(instance.getProtocol());
      this.withTargetPort(instance.getTargetPort());
      this.withName(instance.getName());
      this.withNumber(instance.getNumber());
      this.withProtocol(instance.getProtocol());
      this.withTargetPort(instance.getTargetPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  PortFluent<?> fluent;
  Boolean validationEnabled;
  public Port build() {
    Port buildable = new Port(fluent.getName(),fluent.getNumber(),fluent.getProtocol(),fluent.getTargetPort());
    return buildable;
  }
  
}