package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPMatchRequestBuilder extends HTTPMatchRequestFluent<HTTPMatchRequestBuilder> implements VisitableBuilder<HTTPMatchRequest,HTTPMatchRequestBuilder>{
  public HTTPMatchRequestBuilder() {
    this(false);
  }
  public HTTPMatchRequestBuilder(Boolean validationEnabled) {
    this(new HTTPMatchRequest(), validationEnabled);
  }
  public HTTPMatchRequestBuilder(HTTPMatchRequestFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPMatchRequestBuilder(HTTPMatchRequestFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPMatchRequest(), validationEnabled);
  }
  public HTTPMatchRequestBuilder(HTTPMatchRequestFluent<?> fluent,HTTPMatchRequest instance) {
    this(fluent, instance, false);
  }
  public HTTPMatchRequestBuilder(HTTPMatchRequestFluent<?> fluent,HTTPMatchRequest instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HTTPMatchRequest());

    if (instance != null) {
      fluent.withAuthority(instance.getAuthority());
      fluent.withGateways(instance.getGateways());
      fluent.withHeaders(instance.getHeaders());
      fluent.withIgnoreUriCase(instance.getIgnoreUriCase());
      fluent.withMethod(instance.getMethod());
      fluent.withName(instance.getName());
      fluent.withPort(instance.getPort());
      fluent.withQueryParams(instance.getQueryParams());
      fluent.withScheme(instance.getScheme());
      fluent.withSourceLabels(instance.getSourceLabels());
      fluent.withSourceNamespace(instance.getSourceNamespace());
      fluent.withUri(instance.getUri());
      fluent.withWithoutHeaders(instance.getWithoutHeaders());
      fluent.withAuthority(instance.getAuthority());
      fluent.withGateways(instance.getGateways());
      fluent.withHeaders(instance.getHeaders());
      fluent.withIgnoreUriCase(instance.getIgnoreUriCase());
      fluent.withMethod(instance.getMethod());
      fluent.withName(instance.getName());
      fluent.withPort(instance.getPort());
      fluent.withQueryParams(instance.getQueryParams());
      fluent.withScheme(instance.getScheme());
      fluent.withSourceLabels(instance.getSourceLabels());
      fluent.withSourceNamespace(instance.getSourceNamespace());
      fluent.withUri(instance.getUri());
      fluent.withWithoutHeaders(instance.getWithoutHeaders());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPMatchRequestBuilder(HTTPMatchRequest instance) {
    this(instance,false);
  }
  public HTTPMatchRequestBuilder(HTTPMatchRequest instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HTTPMatchRequest());

    if (instance != null) {
      this.withAuthority(instance.getAuthority());
      this.withGateways(instance.getGateways());
      this.withHeaders(instance.getHeaders());
      this.withIgnoreUriCase(instance.getIgnoreUriCase());
      this.withMethod(instance.getMethod());
      this.withName(instance.getName());
      this.withPort(instance.getPort());
      this.withQueryParams(instance.getQueryParams());
      this.withScheme(instance.getScheme());
      this.withSourceLabels(instance.getSourceLabels());
      this.withSourceNamespace(instance.getSourceNamespace());
      this.withUri(instance.getUri());
      this.withWithoutHeaders(instance.getWithoutHeaders());
      this.withAuthority(instance.getAuthority());
      this.withGateways(instance.getGateways());
      this.withHeaders(instance.getHeaders());
      this.withIgnoreUriCase(instance.getIgnoreUriCase());
      this.withMethod(instance.getMethod());
      this.withName(instance.getName());
      this.withPort(instance.getPort());
      this.withQueryParams(instance.getQueryParams());
      this.withScheme(instance.getScheme());
      this.withSourceLabels(instance.getSourceLabels());
      this.withSourceNamespace(instance.getSourceNamespace());
      this.withUri(instance.getUri());
      this.withWithoutHeaders(instance.getWithoutHeaders());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPMatchRequestFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPMatchRequest build() {
    HTTPMatchRequest buildable = new HTTPMatchRequest(fluent.buildAuthority(),fluent.getGateways(),fluent.getHeaders(),fluent.getIgnoreUriCase(),fluent.buildMethod(),fluent.getName(),fluent.getPort(),fluent.getQueryParams(),fluent.buildScheme(),fluent.getSourceLabels(),fluent.getSourceNamespace(),fluent.buildUri(),fluent.getWithoutHeaders());
    return buildable;
  }
  
}