package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPFaultInjectionDelayBuilder extends HTTPFaultInjectionDelayFluent<HTTPFaultInjectionDelayBuilder> implements VisitableBuilder<HTTPFaultInjectionDelay,HTTPFaultInjectionDelayBuilder>{
  public HTTPFaultInjectionDelayBuilder() {
    this(false);
  }
  public HTTPFaultInjectionDelayBuilder(Boolean validationEnabled) {
    this(new HTTPFaultInjectionDelay(), validationEnabled);
  }
  public HTTPFaultInjectionDelayBuilder(HTTPFaultInjectionDelayFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPFaultInjectionDelayBuilder(HTTPFaultInjectionDelayFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPFaultInjectionDelay(), validationEnabled);
  }
  public HTTPFaultInjectionDelayBuilder(HTTPFaultInjectionDelayFluent<?> fluent,HTTPFaultInjectionDelay instance) {
    this(fluent, instance, false);
  }
  public HTTPFaultInjectionDelayBuilder(HTTPFaultInjectionDelayFluent<?> fluent,HTTPFaultInjectionDelay instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HTTPFaultInjectionDelay());

    if (instance != null) {
      fluent.withHttpDelayType(instance.getHttpDelayType());
      fluent.withPercent(instance.getPercent());
      fluent.withPercentage(instance.getPercentage());
      fluent.withHttpDelayType(instance.getHttpDelayType());
      fluent.withPercent(instance.getPercent());
      fluent.withPercentage(instance.getPercentage());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPFaultInjectionDelayBuilder(HTTPFaultInjectionDelay instance) {
    this(instance,false);
  }
  public HTTPFaultInjectionDelayBuilder(HTTPFaultInjectionDelay instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HTTPFaultInjectionDelay());

    if (instance != null) {
      this.withHttpDelayType(instance.getHttpDelayType());
      this.withPercent(instance.getPercent());
      this.withPercentage(instance.getPercentage());
      this.withHttpDelayType(instance.getHttpDelayType());
      this.withPercent(instance.getPercent());
      this.withPercentage(instance.getPercentage());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPFaultInjectionDelayFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPFaultInjectionDelay build() {
    HTTPFaultInjectionDelay buildable = new HTTPFaultInjectionDelay(fluent.buildHttpDelayType(),fluent.getPercent(),fluent.buildPercentage());
    return buildable;
  }
  
}