package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CorsPolicyBuilder extends CorsPolicyFluent<CorsPolicyBuilder> implements VisitableBuilder<CorsPolicy,CorsPolicyBuilder>{
  public CorsPolicyBuilder() {
    this(false);
  }
  public CorsPolicyBuilder(Boolean validationEnabled) {
    this(new CorsPolicy(), validationEnabled);
  }
  public CorsPolicyBuilder(CorsPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public CorsPolicyBuilder(CorsPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CorsPolicy(), validationEnabled);
  }
  public CorsPolicyBuilder(CorsPolicyFluent<?> fluent,CorsPolicy instance) {
    this(fluent, instance, false);
  }
  public CorsPolicyBuilder(CorsPolicyFluent<?> fluent,CorsPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CorsPolicy());

    if (instance != null) {
      fluent.withAllowCredentials(instance.getAllowCredentials());
      fluent.withAllowHeaders(instance.getAllowHeaders());
      fluent.withAllowMethods(instance.getAllowMethods());
      fluent.withDeprecatedAllowOrigin(instance.getDeprecatedAllowOrigin());
      fluent.withAllowOrigins(instance.getAllowOrigins());
      fluent.withExposeHeaders(instance.getExposeHeaders());
      fluent.withMaxAge(instance.getMaxAge());
      fluent.withAllowCredentials(instance.getAllowCredentials());
      fluent.withAllowHeaders(instance.getAllowHeaders());
      fluent.withAllowMethods(instance.getAllowMethods());
      fluent.withDeprecatedAllowOrigin(instance.getDeprecatedAllowOrigin());
      fluent.withAllowOrigins(instance.getAllowOrigins());
      fluent.withExposeHeaders(instance.getExposeHeaders());
      fluent.withMaxAge(instance.getMaxAge());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CorsPolicyBuilder(CorsPolicy instance) {
    this(instance,false);
  }
  public CorsPolicyBuilder(CorsPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CorsPolicy());

    if (instance != null) {
      this.withAllowCredentials(instance.getAllowCredentials());
      this.withAllowHeaders(instance.getAllowHeaders());
      this.withAllowMethods(instance.getAllowMethods());
      this.withDeprecatedAllowOrigin(instance.getDeprecatedAllowOrigin());
      this.withAllowOrigins(instance.getAllowOrigins());
      this.withExposeHeaders(instance.getExposeHeaders());
      this.withMaxAge(instance.getMaxAge());
      this.withAllowCredentials(instance.getAllowCredentials());
      this.withAllowHeaders(instance.getAllowHeaders());
      this.withAllowMethods(instance.getAllowMethods());
      this.withDeprecatedAllowOrigin(instance.getDeprecatedAllowOrigin());
      this.withAllowOrigins(instance.getAllowOrigins());
      this.withExposeHeaders(instance.getExposeHeaders());
      this.withMaxAge(instance.getMaxAge());
    }
    this.validationEnabled = validationEnabled; 
  }
  CorsPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public CorsPolicy build() {
    CorsPolicy buildable = new CorsPolicy(fluent.getAllowCredentials(),fluent.getAllowHeaders(),fluent.getAllowMethods(),fluent.getDeprecatedAllowOrigin(),fluent.buildAllowOrigins(),fluent.getExposeHeaders(),fluent.getMaxAge());
    return buildable;
  }
  
}