package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConditionBuilder extends ConditionFluentImpl<ConditionBuilder> implements VisitableBuilder<Condition,ConditionBuilder>{
  public ConditionBuilder() {
    this(false);
  }
  public ConditionBuilder(Boolean validationEnabled) {
    this(new Condition(), validationEnabled);
  }
  public ConditionBuilder(ConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ConditionBuilder(ConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Condition(), validationEnabled);
  }
  public ConditionBuilder(ConditionFluent<?> fluent,Condition instance) {
    this(fluent, instance, false);
  }
  public ConditionBuilder(ConditionFluent<?> fluent,Condition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withKey(instance.getKey());
      fluent.withNotValues(instance.getNotValues());
      fluent.withValues(instance.getValues());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConditionBuilder(Condition instance) {
    this(instance,false);
  }
  public ConditionBuilder(Condition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withKey(instance.getKey());
      this.withNotValues(instance.getNotValues());
      this.withValues(instance.getValues());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConditionFluent<?> fluent;
  Boolean validationEnabled;
  public Condition build() {
    Condition buildable = new Condition(fluent.getKey(),fluent.getNotValues(),fluent.getValues());
    return buildable;
  }
  
}